/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.store.impl;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.oss.MyOSSInputStream;
import com.trs.infra.util.oss.MyOSSOutputStream;
import com.trs.infra.util.oss.OSSClientFactory;
import com.trs.infra.util.oss.OSSUtil;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreException;
import com.trs.infra.util.store.FileStoreFilter;
import com.trs.infra.util.store.FileStoreNameFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OSSFileStore
implements FileStore {
    public static final String PROTOCOL = "oss:";
    public static final String URL_PRIFIX = "http://";
    private static Logger logger = Logger.getLogger(OSSFileStore.class);
    private String bucketName = "";
    private String key = "";
    private OSSObject file = null;
    private OSSFileStore destOss = null;
    private OSSFileStore sourceOss = null;

    public OSSFileStore(String path) {
        try {
            int index;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("oss\u6587\u4ef6\u8def\u5f84first\uff1a" + path));
            }
            path = OSSUtil.getValidPath(path);
            if (logger.isDebugEnabled()) {
                logger.info((Object)("oss\u6587\u4ef6\u8def\u5f84second\uff1a" + path));
            }
            if (path.startsWith(PROTOCOL)) {
                path = path.substring(PROTOCOL.length());
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)("oss\u6587\u4ef6\u8def\u5f84third\uff1a" + path));
            }
            if ((index = path.indexOf("/")) == 0) {
                path = path.substring(1);
            }
            index = path.indexOf("/");
            this.bucketName = path.substring(0, index);
            this.key = path.substring(index + 1);
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    public OSSFileStore(String bucketName, String key) {
        this.bucketName = bucketName;
        this.key = key;
    }

    public OSSFileStore(OSSFileStore file, String child) {
        this.bucketName = file.bucketName;
        this.key = file.key.endsWith("/") ? file.key + child : file.key + "/" + child;
    }

    @Override
    public boolean exists() {
        boolean is_exist = false;
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            is_exist = client.doesObjectExist(this.bucketName, this.key);
            client.shutdown();
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
        return is_exist;
    }

    @Override
    public boolean isDirectory() {
        boolean isDirectory = false;
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            String directory = this.key;
            if (!directory.endsWith("/")) {
                directory = directory + "/";
            }
            isDirectory = client.doesObjectExist(this.bucketName, directory);
            client.shutdown();
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
        return isDirectory;
    }

    @Override
    public boolean isFile() {
        boolean isFile = false;
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            isFile = client.doesObjectExist(this.bucketName, this.key);
            isFile = isFile && !this.key.endsWith("/");
            client.shutdown();
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
        return isFile;
    }

    @Override
    public boolean delete() {
        if (this.isDirectory()) {
            this.deleteDir(this);
            return true;
        }
        this.deleteFile();
        return true;
    }

    public void deleteOnExit() {
    }

    @Override
    public String[] list() {
        ArrayList<String> localArrayList = new ArrayList<String>();
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            String prefix = this.key;
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
            listObjectsRequest.setMaxKeys(Integer.valueOf(100));
            listObjectsRequest.setDelimiter("/");
            listObjectsRequest.setPrefix(prefix);
            ObjectListing listing = null;
            do {
                listing = client.listObjects(listObjectsRequest);
                for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                    String key = objectSummary.getKey();
                    if (key.equals(prefix)) continue;
                    localArrayList.add(objectSummary.getKey().substring(prefix.length()));
                }
                for (String commonPrefix : listing.getCommonPrefixes()) {
                    localArrayList.add(commonPrefix.substring(prefix.length()));
                }
                listObjectsRequest.setMarker(listing.getNextMarker());
            } while (listing.isTruncated());
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
        return localArrayList.toArray(new String[localArrayList.size()]);
    }

    private Map listAll() {
        HashMap<String, String> map = new HashMap<String, String>();
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            String prefix = this.key;
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
            listObjectsRequest.setMaxKeys(Integer.valueOf(100));
            listObjectsRequest.setPrefix(prefix);
            ObjectListing listing = null;
            do {
                listing = client.listObjects(listObjectsRequest);
                for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                    String key = objectSummary.getKey();
                    if (key.equals(prefix)) continue;
                    map.put(objectSummary.getKey().substring(prefix.length()), objectSummary.getKey());
                }
                listObjectsRequest.setMarker(listing.getNextMarker());
            } while (listing.isTruncated());
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
        return map;
    }

    @Override
    public String[] list(FileStoreNameFilter filter) {
        ArrayList<String> localArrayList = new ArrayList<String>();
        try {
            String[] arrayOfString = this.list();
            if (arrayOfString == null || filter == null) {
                return arrayOfString;
            }
            for (int i = 0; i < arrayOfString.length; ++i) {
                if (!filter.accept(this, arrayOfString[i])) continue;
                localArrayList.add(arrayOfString[i]);
            }
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        return localArrayList.toArray(new String[localArrayList.size()]);
    }

    @Override
    public FileStore[] listFiles() {
        try {
            String[] arrayOfString = this.list();
            if (arrayOfString == null) {
                return null;
            }
            FileStore[] arrayOfFile = new FileStore[arrayOfString.length];
            for (int i = 0; i < arrayOfString.length; ++i) {
                arrayOfFile[i] = new OSSFileStore(this, arrayOfString[i]);
            }
            return arrayOfFile;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public FileStore[] listFiles(FileStoreNameFilter filter) {
        try {
            String[] arrayOfString = this.list();
            if (arrayOfString == null || filter == null) {
                return null;
            }
            ArrayList<OSSFileStore> localArrayList = new ArrayList<OSSFileStore>();
            for (int i = 0; i < arrayOfString.length; ++i) {
                if (!filter.accept(this, arrayOfString[i])) continue;
                localArrayList.add(new OSSFileStore(this, arrayOfString[i]));
            }
            return localArrayList.toArray(new FileStore[localArrayList.size()]);
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public FileStore[] listFiles(FileStoreFilter filter) {
        try {
            String[] arrayOfString = this.list();
            if (arrayOfString == null || filter == null) {
                return null;
            }
            ArrayList<OSSFileStore> localArrayList = new ArrayList<OSSFileStore>();
            for (int i = 0; i < arrayOfString.length; ++i) {
                if (!filter.accept(this)) continue;
                localArrayList.add(new OSSFileStore(this, arrayOfString[i]));
            }
            return localArrayList.toArray(new FileStore[localArrayList.size()]);
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean mkdir() {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            if (!this.key.endsWith("/")) {
                this.key = this.key + "/";
            }
            client.putObject(this.bucketName, this.key, (InputStream)new ByteArrayInputStream(new byte[0]), null);
            client.shutdown();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            OSSObject object = client.getObject(this.bucketName, this.key);
            InputStream objectContent = object.getObjectContent();
            MyOSSInputStream myOSSInputStream = new MyOSSInputStream(objectContent, client);
            return myOSSInputStream;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return new MyOSSOutputStream(this);
    }

    @Override
    public String getAbsolutePath() {
        return "oss:/" + this.bucketName + "/" + this.key;
    }

    @Override
    public String getPath() {
        return this.getAbsolutePath();
    }

    @Override
    public FileStore getParentFileStore() {
        String parent = this.getParent();
        if (!CMyString.isEmpty(parent)) {
            return new OSSFileStore(parent);
        }
        return null;
    }

    @Override
    public long length() {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            OSSObject object = client.getObject(this.bucketName, this.key);
            ObjectMetadata info = object.getObjectMetadata();
            long l = info.getContentLength();
            return l;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    @Override
    public String getName() {
        String temp_key = "";
        temp_key = this.key.endsWith("/") && this.key.length() > 1 ? this.key.substring(0, this.key.length() - 1) : this.key;
        int lastIndex = temp_key.lastIndexOf("/");
        if (lastIndex > 0) {
            return temp_key.substring(lastIndex + 1);
        }
        if (lastIndex == 0) {
            return temp_key.replaceAll("/", "");
        }
        return null;
    }

    @Override
    public String getParent() {
        String temp_key = "";
        temp_key = this.key.endsWith("/") && this.key.length() > 1 ? this.key.substring(0, this.key.length() - 1) : this.key;
        int lastIndex = temp_key.lastIndexOf("/");
        if (lastIndex > 0) {
            return "oss:/" + this.bucketName + "/" + temp_key.substring(0, lastIndex);
        }
        return null;
    }

    @Override
    public long lastModified() {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            OSSObject object = client.getObject(this.bucketName, this.key);
            ObjectMetadata info = object.getObjectMetadata();
            long l = info.getLastModified().getTime();
            return l;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    @Override
    public boolean setLastModified(long time) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameTo(FileStore dest) {
        if (dest instanceof FileService) {
            dest = ((FileService)dest).getFileStore();
        }
        if (!(dest instanceof OSSFileStore)) {
            return false;
        }
        OSSFileStore destOSSFileStore = (OSSFileStore)dest;
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            if (this.isFile()) {
                this.renameFileTo(destOSSFileStore, client);
            } else {
                this.renameDirTo(destOSSFileStore, client);
            }
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
        return true;
    }

    private boolean renameDirTo(OSSFileStore dest, OSSClient client) {
        FileStore[] children = this.listFiles();
        for (int i = 0; i < children.length; ++i) {
            OSSFileStore srcOSSChild = (OSSFileStore)children[i];
            OSSFileStore destOSSChild = new OSSFileStore(dest, children[i].getName());
            if (srcOSSChild.isDirectory()) {
                srcOSSChild.renameDirTo(destOSSChild, client);
                continue;
            }
            srcOSSChild.renameFileTo(destOSSChild, client);
        }
        return this.delete();
    }

    private boolean renameFileTo(OSSFileStore dest, OSSClient client) {
        try {
            client.copyObject(this.bucketName, this.key, dest.bucketName, dest.key);
            this.delete();
        }
        catch (Exception e) {
            logger.error((Object)("\u91cd\u547d\u540d\u76ee\u5f55[" + this.getAbsolutePath() + "]\u5230\u76ee\u5f55[" + dest.getAbsolutePath() + "]\u5931\u8d25"), (Throwable)e);
        }
        return true;
    }

    private boolean deleteDir(OSSFileStore dir) {
        if (dir.isDirectory()) {
            String[] children = this.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new OSSFileStore(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.deleteFile();
    }

    private boolean deleteFile() {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            client.deleteObject(this.bucketName, this.key);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    @Override
    public boolean mkdirs() {
        return this.mkdir();
    }

    @Override
    public boolean canRead() {
        return this.isFile();
    }

    @Override
    public boolean createNewFile() {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            client.putObject(this.bucketName, this.key, (InputStream)new ByteArrayInputStream(new byte[0]), null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public URL toURL() {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            String file_url = client.getEndpoint().toString();
            file_url = URL_PRIFIX + this.bucketName + "." + file_url.substring(URL_PRIFIX.length()) + "/" + this.key;
            URL uRL = new URL(file_url);
            return uRL;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    @Override
    public URI toURI() {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            String file_url = client.getEndpoint().toString();
            file_url = URL_PRIFIX + this.bucketName + "." + file_url.substring(URL_PRIFIX.length()) + "/" + this.key;
            URI uRI = new URI(file_url);
            return uRI;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    public void write(ByteArrayInputStream input) {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            client.putObject(this.bucketName, this.key, (InputStream)input);
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    public void write(File localFile) {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            client.putObject(this.bucketName, this.key, localFile);
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    public InputStream getInputStream(long startPos, long endPos) {
        OSSClient client = OSSClientFactory.buildFileStore();
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, this.key);
            getObjectRequest.setRange(startPos, endPos);
            OSSObject object = client.getObject(getObjectRequest);
            InputStream objectContent = object.getObjectContent();
            MyOSSInputStream myOSSInputStream = new MyOSSInputStream(objectContent, client);
            return myOSSInputStream;
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

