/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.CDB2DBCLOB2;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import java.sql.Connection;
import java.sql.ResultSet;

public class DB2UDB2
extends DBType {
    private static final int NUMERIC_MAX_LEN = 31;
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType INT = new DataType("INTEGER", 4, 4);
    public static final DataType BIGINT = new DataType("BIGINT", -5, 8);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType REAL = new DataType("REAL", 7, 4);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 8);
    public static final DataType CHAR = new DataType("CHAR", 1, -254);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -32672);
    public static final DataType CLOB = new DataType("CLOB", 2005);
    public static final DataType DBCLOB = new DataType("DBCLOB", -1, 16);
    public static final DataType BLOB = new DataType("BLOB", -4, 16);
    public static final DataType DATE = new DataType("DATE", 93, 8);
    public static final DataType TIME = new DataType("TIME", 93, 8);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType UNIQUEIDENTIFIER = new DataType("UNIQUEIDENTIFIER", -5, 16);
    public static final DataType SQL_VARIRANT = new DataType("SQL_VARIRANT", -3);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -32672);
    public static final DataType NINT = new DataType("INT", 4, 4);
    public static final DataType DATETIME = new DataType("DATETIME", 93, 8);
    public static final DataType NUMERIC = new DataType("NUMERIC", 2, -31);
    static final DataType[] m_allDataTypes = new DataType[]{SMALLINT, INT, BIGINT, DECIMAL, REAL, FLOAT, CHAR, VARCHAR, CLOB, DBCLOB, BLOB, DATE, TIME, TIMESTAMP, NVARCHAR, NINT, DATETIME, NUMERIC};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, INT, DECIMAL, VARCHAR, CLOB, TIMESTAMP};

    public DB2UDB2() {
        super("DB2 Universal Database", "com.ibm.db2.jcc.DB2Driver", false);
    }

    public DB2UDB2(String _sName, String _sDriverClass, boolean _bSupportStoredProc) {
        super(_sName, _sDriverClass, _bSupportStoredProc);
    }

    @Override
    public String sqlCreateTableWithPrimary(String tableName, String primaryFieldName) throws WCMException {
        StringBuffer buff = new StringBuffer(128);
        buff.append("create table ");
        buff.append(tableName.toUpperCase());
        buff.append('(');
        buff.append(primaryFieldName.toUpperCase());
        buff.append(" BIGINT NOT NULL PRIMARY KEY");
        buff.append(')');
        return buff.toString();
    }

    @Override
    protected void registerDBInfo() {
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varchar($l) for bit data");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
    }

    @Override
    public String sqlFilterForClob(String _sFieldName, String _sValue) {
        return "";
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2) {
        return "CONCAT(" + _strSQL1 + "," + _strSQL2 + ")";
    }

    @Override
    public String sqlAddField(String _sTableName, String _sFieldName, String _sFieldType, int _nMaxLength, boolean _bNullable, String _sDefaultValue, int _nScale) {
        DataType dataType = this.getDataType(_sFieldType);
        if (dataType == null) {
            return null;
        }
        String sFieldType = _sFieldType;
        int nMaxLength = _nMaxLength;
        boolean zVarChar = false;
        switch (dataType.getType()) {
            case 5: {
                sFieldType = "integer";
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 4: {
                sFieldType = "bigint";
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 6: {
                sFieldType = "float";
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 2: {
                sFieldType = "decimal";
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 93: {
                sFieldType = "timestamp";
                break;
            }
            case 12: {
                sFieldType = "varchar";
                zVarChar = true;
                break;
            }
        }
        StringBuffer buff = new StringBuffer(128);
        buff.append("alter table ").append(_sTableName.toUpperCase());
        buff.append(" add ").append(_sFieldName.toUpperCase());
        buff.append(' ').append(sFieldType);
        if (dataType.isLengthDefinedByUser()) {
            if (zVarChar) {
                // empty if block
            }
            buff.append('(').append(nMaxLength);
            if (_nScale > 0) {
                buff.append(',').append(_nScale);
            }
            buff.append(')');
        }
        return buff.toString();
    }

    @Override
    public String sqlAddField(String _sTableName, String _sFieldName, int _nFieldType, int _nLengthOrPrecision, boolean _sNullable, String _sDefaultValue, int _nScale) throws WCMException {
        StringBuffer buff = new StringBuffer(128);
        buff.append("alter table ");
        buff.append(_sTableName.toUpperCase());
        buff.append(" add ");
        buff.append(_sFieldName.toUpperCase());
        buff.append(' ');
        buff.append(this.getTypeName(_nFieldType, _nLengthOrPrecision, _nLengthOrPrecision, _nScale));
        return buff.toString();
    }

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws WCMException {
        if (2 == code && precision > 31) {
            precision = 31;
        }
        return super.getTypeName(code, length, precision, scale);
    }

    @Override
    public String sqlConcatStr(String[] _strSQLs) {
        String sRet = "CONCAT(" + _strSQLs[0] + "," + _strSQLs[1] + ")";
        for (int i = 2; i < _strSQLs.length; ++i) {
            sRet = "CONCAT(" + sRet + "," + _strSQLs[i] + ")";
        }
        return sRet;
    }

    @Override
    public boolean canWriteTextDirectly() {
        return false;
    }

    @Override
    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    @Override
    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    @Override
    public String sqlFilterOneDay(String _sFieldName, String _sDateTime, String _sFormat) {
        return "(DATE(" + _sFieldName + ")-DATE('" + _sDateTime + "'))=0";
    }

    @Override
    public String sqlDateTime(String _sDateTime, String _sFormat) {
        if (_sFormat.equalsIgnoreCase("YYYY-MM-DD")) {
            return "TIMESTAMP('" + _sDateTime + " 00:00:00')";
        }
        return "TIMESTAMP('" + _sDateTime + "')";
    }

    @Override
    public String sqlDate(String _sDateTime) {
        return this.sqlDateTime(_sDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public String sqlDateField(String _sDateField) {
        return "DATE(" + _sDateField + ")";
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2, String _strSQL3) {
        return "CONCAT(CONCAT(" + _strSQL1 + "," + _strSQL2 + ")," + _strSQL3 + ")";
    }

    @Override
    public String sqlGetSysDate() {
        return "(CURRENT TIMESTAMP)";
    }

    @Override
    public String encodeStrToWrite(String _strSrc) {
        return _strSrc;
    }

    public static void main(String[] args) {
    }

    @Override
    public String initQuerySQL(String _strSql, int _nStartIndex, int _nSize) {
        return _strSql;
    }

    @Override
    public String sqlQueryTableInfos(String _sOwnerUser) {
        String strSQL = "SELECT c.tbname AS TABLE_NAME,c.colno AS COLUMN_ID,c.name AS COLUMN_NAME,c.typename AS DATA_TYPE,c.longlength AS DATA_LENGTH, c.nulls AS NULLABLE,c.default AS DATA_DEFAULT,c.scale AS DATA_SCALE FROM sysibm.syscolumns c where c.tbcreator='" + _sOwnerUser.toUpperCase() + "' ORDER BY TABLE_NAME, COLUMN_ID";
        return strSQL;
    }

    @Override
    public String sqlQueryTableInfo(String _sOwnerUser, String _sTableName) {
        String strSQL = "SELECT c.tbname AS TABLE_NAME,c.colno AS COLUMN_ID,c.name AS COLUMN_NAME,c.typename AS DATA_TYPE,c.longlength AS DATA_LENGTH, c.nulls AS NULLABLE,c.default AS DATA_DEFAULT,c.scale AS DATA_SCALE FROM sysibm.syscolumns c WHERE c.tbcreator='" + _sOwnerUser.toUpperCase() + "' AND c.tbname='" + _sTableName.toUpperCase() + "' ORDER BY TABLE_NAME, COLUMN_ID";
        return strSQL;
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        return CDB2DBCLOB2.getClob(p_rsData, p_nFieldIndex);
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        return CDB2DBCLOB2.getClob(p_rsData, p_sFieldName);
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        return CDB2DBCLOB2.setClob(p_oConn, p_sTableName, p_sWhere, p_sIdFieldName, p_sClobFieldName, p_sValue);
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        return CDB2DBCLOB2.setClob(p_oConn, p_sTableName, p_sWhere, p_sIdFieldName, p_asFieldsAndValues);
    }

    @Override
    public String sqlGetNextId() {
        return null;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public boolean canDropField() {
        return false;
    }

    @Override
    public String sqlDropField(String tableName, String fieldNames) throws Exception {
        throw new UnsupportedOperationException("Drop a column is not allowed by DB2!");
    }

    @Override
    protected String keywordsModifyField() throws WCMException {
        return null;
    }

    @Override
    public String sqlModifyField(String tableName, String fieldName, int fieldType, int lengthOrPrecision, boolean nullable, int scale) throws WCMException {
        throw new UnsupportedOperationException("Modifiy a column is not allowed by DB2!");
    }

    @Override
    public String sqlRenameField(String tableName, String oldFieldName, String newFieldName) throws WCMException {
        throw new UnsupportedOperationException("Rename a column is not allowed by DB2!");
    }

    @Override
    public String sqlRenameTable(String oldTableName, String newTableName) throws WCMException {
        throw new UnsupportedOperationException("Rename a table is not allowed by DB2!");
    }
}

