/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.config;

import com.trs.DreamFactory;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.Configs;
import com.trs.infra.support.config.SystemCollocationConfig;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfigServer
extends BaseServer
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify,
IObjectLCListenerOnDel {
    private HashMap m_hmSysConfigs = null;
    public static final String INI_FILENAME = "TRSWCMApp.ini";
    private Properties m_oINIProperties = null;
    private static final int TYPE_PROXY = 1;
    private static final String WCM_PATH_CONFIG = "WCM_PATH";
    private String[] m_arTypeNames = null;
    private int[] m_arTypeIds = null;

    public int[] getTypeIds() {
        if (this.m_arTypeIds == null) {
            this.loadTypes();
        }
        return this.m_arTypeIds;
    }

    public String[] getTypeNames() {
        if (this.m_arTypeNames == null) {
            this.loadTypes();
        }
        return this.m_arTypeNames;
    }

    public static ConfigServer createInstance() {
        ConfigServer aConfigServer = (ConfigServer)DreamFactory.createObjectById("ConfigServer");
        return aConfigServer;
    }

    public void updateConfigValue(String _sConfigName, String _sValue) throws WCMException {
        if (_sConfigName == null || _sConfigName.length() == 0 || _sValue == null) {
            return;
        }
        Config currConfig = this.getSysConfig(_sConfigName);
        if (currConfig == null || _sValue.equals(currConfig.getValue())) {
            return;
        }
        currConfig.setValue(_sValue);
        currConfig.update();
    }

    @Override
    public void notifyOnModifyObj(BaseObj _currObj, int _nEventType) throws WCMException {
        if (_currObj == null || !(_currObj instanceof Config)) {
            return;
        }
        this.putConfigValue((Config)_currObj);
    }

    @Override
    public void notifyOnAddObj(BaseObj _currObj) throws WCMException {
        if (_currObj == null || !(_currObj instanceof Config)) {
            return;
        }
        this.putConfigValue((Config)_currObj);
    }

    @Override
    public void notifyOnDelObj(BaseObj _currObj, int _nEventType) throws WCMException {
        if (_currObj == null || !(_currObj instanceof Config)) {
            return;
        }
        this.removeConfigValue((Config)_currObj);
    }

    public Config getSysConfig(String _sConfigName) throws WCMException {
        return (Config)this.getSysConfigs().get(_sConfigName.toUpperCase());
    }

    public String getSysConfigValue(String _key, String _default) throws WCMException {
        Config config = this.getSysConfig(_key);
        return config == null ? _default : CMyString.showNull(config.getValue(), _default);
    }

    private synchronized boolean loadSysConfigs() throws WCMException {
        if (this.m_hmSysConfigs != null) {
            return true;
        }
        try {
            Configs configs = new Configs();
            configs.open(new WCMFilter("", "SiteId = 0", ""));
            this.m_hmSysConfigs = new HashMap(configs.size());
            for (int i = 0; i < configs.size(); ++i) {
                Config config = (Config)configs.getAt(i);
                if (config == null) continue;
                this.putConfigValue(config);
            }
            configs.clear();
            return true;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(ConfigServer.class, "ConfigServer.label1", "\u88c5\u8f7d\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f\u5931\u8d25"), ex);
        }
    }

    public synchronized void clear() {
        if (this.m_hmSysConfigs == null) {
            return;
        }
        this.m_hmSysConfigs.clear();
        this.m_hmSysConfigs = null;
        this.m_oINIProperties.clear();
        this.m_oINIProperties = null;
    }

    public static ConfigServer getServer() {
        return (ConfigServer)DreamFactory.createObjectById("ConfigServer");
    }

    public String getInitProperty(String _sKey) {
        try {
            return (String)this.getProperties().get(_sKey);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Properties getProperties() throws WCMException {
        if (this.m_oINIProperties == null) {
            this.loadIniProperties();
        }
        return this.m_oINIProperties;
    }

    private void loadIniProperties() throws WCMException {
        if (this.m_oINIProperties != null) {
            return;
        }
        this.m_oINIProperties = new Properties();
        InputStream isFile = null;
        try {
            isFile = new FileService(CMyFile.mapResouceFullPath(INI_FILENAME)).getInputStream();
            this.m_oINIProperties.load(isFile);
            Enumeration<Object> enKeys = this.m_oINIProperties.keys();
            while (enKeys.hasMoreElements()) {
                String sKey = enKeys.nextElement().toString();
                String sValue = this.m_oINIProperties.getProperty(sKey).trim();
                if (sValue.length() == 0) continue;
                this.m_oINIProperties.put(sKey, new String(sValue.getBytes("ISO8859-1"), "GBK"));
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(ConfigServer.class, "ConfigServer.label2", "\u88c5\u8f7d\u7cfb\u7edf\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff08Application.readIniProperties\uff09"), ex);
        }
        finally {
            if (isFile != null) {
                try {
                    isFile.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            String dest;
            String source;
            String sWCMPath = CMyFile.mapResouceFullPath("");
            if (File.separatorChar == '/') {
                source = "\\\\";
                dest = "/";
            } else {
                source = "/";
                dest = "\\\\";
            }
            sWCMPath = sWCMPath.replaceAll(source, dest);
            for (int i = 0; i < 3; ++i) {
                int last = sWCMPath.lastIndexOf(File.separator);
                sWCMPath = sWCMPath.substring(0, last);
            }
            sWCMPath = new File(sWCMPath).getAbsolutePath();
            this.m_oINIProperties.setProperty(WCM_PATH_CONFIG, sWCMPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInitProperties(String sKey, String sValue) throws WCMException {
        if (File.separatorChar == '\\') {
            sValue = sValue.replaceAll("\\\\", "\\\\\\\\");
        }
        try {
            String sFileName = CMyFile.mapResouceFullPath(INI_FILENAME);
            String sContent = CMyFile.readFile(sFileName, "GBK");
            String sLine = sKey + "=" + sValue;
            sContent = sContent.matches("(?m)^" + sKey + "=") ? sContent.replaceFirst("(?m)^" + sKey + "=[^\n]+$", sLine + "\n") : sContent + "\n" + sLine;
            CMyFile.writeFile(sFileName, sContent, "GBK");
            this.m_oINIProperties.put(sKey, sValue);
        }
        catch (Exception e) {
            throw new WCMException("\u4fee\u6539\u6587\u4ef6\u914d\u7f6e\u51fa\u73b0\u9519\u8bef", e);
        }
    }

    public void setInitProperties(Map properties) throws WCMException {
        try {
            String sFileName = CMyFile.mapResouceFullPath(INI_FILENAME);
            String sContent = CMyFile.readFile(sFileName, "GBK");
            for (Map.Entry entry : properties.entrySet()) {
                String sKey = (String)entry.getKey();
                String sValue = (String)entry.getValue();
                if (File.separatorChar == '\\') {
                    sValue = sValue.replaceAll("\\\\", "\\\\");
                }
                String sLine = sKey + "=" + sValue;
                sContent = sContent.matches("(?m)^" + sKey + "=") ? sContent.replaceFirst("(?m)^" + sKey + "=[^\n]+$", sLine + "\n") : sContent + "\n" + sLine;
                CMyFile.writeFile(sFileName, sContent, "GBK");
                this.m_oINIProperties.put(sKey, sValue);
            }
        }
        catch (Exception e) {
            throw new WCMException("\u4fee\u6539\u6587\u4ef6\u914d\u7f6e\u51fa\u73b0\u9519\u8bef", e);
        }
    }

    @Override
    protected void doShutdown() {
        this.clear();
    }

    @Override
    protected boolean doStart() throws WCMException {
        this.loadIniProperties();
        this.loadSysConfigs();
        return true;
    }

    protected void putConfigValue(Config _oValue) throws WCMException {
        if (_oValue.getType() == 1) {
            CMy3WLib.setProxyInfo(_oValue.getConfigKey(), _oValue.getValue());
        }
        this.getSysConfigs().put(_oValue.getConfigKey().toUpperCase(), _oValue);
    }

    protected void removeConfigValue(Config _oConfig) throws WCMException {
        this.getSysConfigs().remove(_oConfig.getConfigKey().toUpperCase());
    }

    protected HashMap getSysConfigs() throws WCMException {
        return this.getSysConfigs(true);
    }

    protected HashMap getSysConfigs(boolean _bNeedInit) throws WCMException {
        if (!_bNeedInit) {
            return this.m_hmSysConfigs;
        }
        if (this.m_hmSysConfigs == null) {
            this.loadSysConfigs();
        }
        return this.m_hmSysConfigs;
    }

    public String getTypeName(int _nTypeId) {
        if (this.m_arTypeIds == null) {
            this.loadTypes();
        }
        if (this.m_arTypeIds == null) {
            return "";
        }
        for (int i = 0; i < this.m_arTypeIds.length; ++i) {
            if (_nTypeId != this.m_arTypeIds[i]) continue;
            return this.m_arTypeNames[i];
        }
        return "";
    }

    private void loadTypes() {
        if (this.m_arTypeIds != null) {
            return;
        }
        List listSysCollocationConfigs = XMLConfigServer.getInstance().getConfigObjects(SystemCollocationConfig.class);
        if (listSysCollocationConfigs.size() == 0) {
            return;
        }
        this.m_arTypeIds = new int[listSysCollocationConfigs.size()];
        this.m_arTypeNames = new String[listSysCollocationConfigs.size()];
        for (int i = 0; i < this.m_arTypeIds.length; ++i) {
            SystemCollocationConfig oConfig = (SystemCollocationConfig)listSysCollocationConfigs.get(i);
            this.m_arTypeIds[i] = oConfig.getTypeId();
            this.m_arTypeNames[i] = oConfig.getName();
        }
    }

    public boolean isShowDetailErrorInfo() {
        try {
            return "true".equals(this.getSysConfigValue("SHOW_ERROR_DETAILINFO", "false"));
        }
        catch (WCMException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(ConfigServer.getServer().getInitProperty(WCM_PATH_CONFIG));
            System.out.println("Type 10:" + ConfigServer.getServer().getTypeName(10));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

