/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjHandler;
import com.trs.infra.persistent.BaseObjsHandler;
import com.trs.infra.util.CMyJAXPXMLParser;
import com.trs.infra.util.CMyString;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BaseObjHelper {
    public static BaseObj toWCMObj(String _sWCMObjXMLContent, BaseObj _oWCMObj) throws WCMException {
        if (_sWCMObjXMLContent == null || _sWCMObjXMLContent.length() <= 0) {
            return null;
        }
        try {
            BaseObjHandler wcmHandler = new BaseObjHandler(_oWCMObj);
            String content = CMyString.filterForJDOM(_sWCMObjXMLContent);
            BaseObjHelper.parseXMLFile(new InputSource(new StringReader(content)), wcmHandler, false);
            BaseObj updateObj = wcmHandler.getWCMObj();
            updateObj.removeProperty(updateObj.getIdFieldName());
            return updateObj;
        }
        catch (Exception ex) {
            throw new WCMException(1104, I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label1", "\u8bbe\u7f6e\u5bf9\u8c61[") + _oWCMObj.getClassName(false) + "][" + _oWCMObj.getId() + I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label2", "]\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38\uff01"), ex);
        }
    }

    public static BaseObj toWCMObj(String _sWCMObjXMLContent, int _nObjId, Class _oWCMObjClass) throws WCMException {
        if (_sWCMObjXMLContent == null || _sWCMObjXMLContent.length() <= 0) {
            return null;
        }
        BaseObj currObj = null;
        try {
            currObj = BaseObj.createNewInstance(_oWCMObjClass);
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label3", "\u4ea7\u751f\u6307\u5b9a\u5bf9\u8c61[") + _oWCMObjClass.getName() + I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label4", "]\u7684\u5b9e\u4f8b\u5931\u8d25\uff01"), ex);
        }
        if (_nObjId > 0) {
            currObj = BaseObjHelper.findAndLockWCMObj(currObj, _nObjId);
        }
        return BaseObjHelper.toWCMObj(_sWCMObjXMLContent, currObj);
    }

    public static List toWCMObjList(String _sWCMObjsXMLContent, BaseObj _obj) throws Exception {
        if (_sWCMObjsXMLContent == null || _sWCMObjsXMLContent.length() <= 0) {
            return null;
        }
        BaseObjsHandler oWCMObjsHandler = new BaseObjsHandler(_obj);
        BaseObjHelper.parseXMLFile(new InputSource(new StringReader(_sWCMObjsXMLContent)), oWCMObjsHandler, false);
        List arWCMObjList = oWCMObjsHandler.getWCMObjList();
        BaseObj currObj = null;
        for (int i = arWCMObjList.size() - 1; i >= 0; --i) {
            currObj = (BaseObj)arWCMObjList.get(i);
            if (currObj.getProperty(currObj.getIdFieldName()) == null) continue;
            int nId = currObj.getPropertyAsInt(currObj.getIdFieldName(), 0);
            if (nId > 0) {
                BaseObj newObj = BaseObjHelper.findAndLockWCMObj(currObj, nId);
                newObj.setNewProperties(currObj.getProperties());
                arWCMObjList.remove(i);
                arWCMObjList.add(i, newObj);
                currObj = newObj;
            }
            currObj.removeProperty(currObj.getIdFieldName());
        }
        return arWCMObjList;
    }

    public static String toIdsString(List _arWCMObj) {
        return BaseObjHelper.toIdsString(_arWCMObj, ",");
    }

    public static String toIdsString(List _arWCMObj, String _sDelim) {
        if (_arWCMObj == null) {
            return "";
        }
        int nId = 0;
        boolean bFirst = true;
        String sIds = "";
        for (int i = 0; i < _arWCMObj.size(); ++i) {
            nId = ((BaseObj)_arWCMObj.get(i)).getId();
            if (nId == 0) continue;
            if (bFirst) {
                sIds = String.valueOf(nId);
                bFirst = false;
                continue;
            }
            sIds = sIds + _sDelim + nId;
        }
        return sIds;
    }

    private static BaseObj findAndLockWCMObj(BaseObj _currObj, int _nObjId) throws WCMException {
        BaseObj currObj = BaseObj.findById(_currObj.getClass(), _nObjId);
        if (currObj == null) {
            throw new WCMException(200006, I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label5", "\u6307\u5b9a\u7684\u5bf9\u8c61\u6216\u8bb8\u88ab\u5220\u9664!ID\u4e3a[") + _nObjId + "]");
        }
        return currObj;
    }

    private static void parseXMLFile(InputSource is, DefaultHandler handler, boolean validating) throws WCMException {
        try {
            CMyJAXPXMLParser.parseXMLFile(is, handler, validating);
        }
        catch (SAXException e) {
            throw new WCMException(150, I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label6", "\u89e3\u6790\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff01") + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfigurationException:" + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("IOException:" + e.getMessage());
        }
    }
}

