/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.domain.job;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.log.LogServer;
import org.apache.log4j.Logger;

public class PublishJobWorker
extends BaseStatefulScheduleWorker {
    private static final Logger logger = Logger.getLogger((String)PublishJobWorker.class.getName());
    private int m_nSenderType;
    private int m_nSenderId;
    private User m_oScheduleUser;

    protected boolean analyzeParams() {
        try {
            this.m_nSenderType = Integer.parseInt(this.getArgAsString("SenderType"));
            this.m_nSenderId = Integer.parseInt(this.getArgAsString("SenderId"));
            String userName = this.getArgAsString("CrUser");
            ContextHelper.initContext(User.getSystem());
            this.m_oScheduleUser = User.findByName(userName);
            if (this.m_oScheduleUser == null || this.m_oScheduleUser.getStatus() != 30 || this.m_oScheduleUser.isDeleted()) {
                this.m_oScheduleUser = User.getSystem();
            }
            ContextHelper.setLoginUser(this.m_oScheduleUser);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"excute schedule publish failed", (Throwable)ex);
            return false;
        }
    }

    @Override
    protected void execute() throws WCMException {
        if (!this.analyzeParams()) {
            throw new WCMException(1100, "\u5206\u6790\u8ba1\u5212\u53d1\u5e03\u7684\u53c2\u6570\u5931\u8d25!");
        }
        ContextParameters.set(7, Boolean.TRUE);
        ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, "127.0.0.1");
        IPublishElement element = PublishElementFactory.lookupElement(this.m_nSenderType, this.m_nSenderId);
        if (element == null) {
            logger.error((Object)"publish failed,no element to publish!");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("schedule publish[" + element.getInfo() + "] begin...."));
        }
        if (element instanceof IPublishContent) {
            this.publishContent((IPublishContent)element);
        } else if (element instanceof IPublishFolder) {
            this.publishFolder((IPublishFolder)element);
        } else {
            logger.error((Object)("schedule publish[" + element.getInfo() + "] failed,not a valid element!"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("schedule publish[" + element.getInfo() + "] end."));
        }
    }

    private void publishFolder(IPublishFolder _folder) throws WCMException {
        if (_folder.isDeleted()) {
            return;
        }
        int nPublishType = 1;
        try {
            IPublishElements contents = _folder.getIncreasedContents(null);
            if (!_folder.isRoot() && (contents == null || contents.isEmpty())) {
                if (!"1".equals(_folder.getSubstance().getAttributeValue("FORCESCHEDULEPUB"))) {
                    return;
                }
                nPublishType = 8;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u6784\u9020\u6307\u5b9a\u7684[" + _folder.getInfo() + "]\u589e\u91cf\u53d1\u5e03\u5185\u5bb9\u5931\u8d25\uff01"), (Throwable)e);
            return;
        }
        try {
            PublishServer server = PublishServer.getInstance();
            server.publishFolder(_folder, nPublishType);
        }
        catch (Exception e) {
            logger.error((Object)("schedule publish[" + _folder.getInfo() + "] failed!"), (Throwable)e);
            throw new WCMException(1100, "\u8ba1\u5212\u53d1\u5e03\u5931\u8d25!", e);
        }
    }

    private void publishContent(IPublishContent _content) throws WCMException {
        try {
            PublishServer server = PublishServer.getInstance();
            _content.setFolder(_content.getOriginalHome());
            if (_content.getType() == 605) {
                boolean zRightCheckRequired;
                Document document = (Document)_content.getSubstance();
                if (document == null || document.isDeleted()) {
                    return;
                }
                DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
                Channels channels = documentMgr.getQutoedChannels(document, 0, null);
                channels.addElement(document.getChannelId());
                boolean bl = zRightCheckRequired = !this.m_oScheduleUser.isAdministrator() && this.m_oScheduleUser.getId() != 0;
                if (zRightCheckRequired) {
                    int nRightIndex = 39;
                    for (int i = channels.size() - 1; i >= 0; --i) {
                        Channel channel = (Channel)channels.getAt(i);
                        if (channel == null || AuthServer.hasRight(this.m_oScheduleUser, (CMSObj)channel, nRightIndex)) continue;
                        channels.removeAt(i, false);
                    }
                }
                if (channels.isEmpty()) {
                    return;
                }
                IPublishElements folders = PublishElementFactory.makeElementsFrom(channels);
                server.publishContent(_content, folders);
            } else {
                server.publishContent(_content);
            }
        }
        catch (Exception e) {
            logger.error((Object)("schedule publish[" + _content.getInfo() + "] failed!"), (Throwable)e);
            throw new WCMException(1100, "\u8ba1\u5212\u53d1\u5e03\u5931\u8d25!", e);
        }
    }
}

