/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Securities;
import com.trs.components.wcm.resource.Security;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Sources;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.AbstractXmlToObjConverter;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

public final class XmlToDocumentConverter
extends AbstractXmlToObjConverter {
    private static final String PROP_DOCSECURITY = "DOCSECURITY";
    private static final String PROP_DOCSOURCE = "DOCSOURCE";
    private static final String PROP_DOCSRCNAME = "DOCSOURCENAME";
    private static boolean DOC_HAS_DOCSRCNAME_PROP = true;
    public HashMap Doc_ChannelName = new HashMap();

    public XmlToDocumentConverter(int _nImportType) {
        super(_nImportType);
    }

    @Override
    protected Map processSpecialProperties(Element _eleProperties) throws WCMException {
        HashMap<String, String> specialValue = new HashMap<String, String>(3);
        String sValue = _eleProperties.elementTextTrim(PROP_DOCSRCNAME);
        if (!CMyString.isEmpty(sValue)) {
            specialValue.put(PROP_DOCSOURCE, "0");
        } else {
            sValue = _eleProperties.elementText(PROP_DOCSOURCE);
            if (!CMyString.isEmpty(sValue)) {
                try {
                    Integer.parseInt(sValue);
                }
                catch (NumberFormatException e) {
                    if (DOC_HAS_DOCSRCNAME_PROP) {
                        specialValue.put(PROP_DOCSOURCE, "0");
                        specialValue.put(PROP_DOCSRCNAME, sValue);
                    }
                    specialValue.put(PROP_DOCSOURCE, this.processDocSource(sValue));
                }
            }
        }
        String sSecurityValue = _eleProperties.elementText(PROP_DOCSECURITY);
        if (!CMyString.isEmpty(sSecurityValue)) {
            try {
                Integer.parseInt(sSecurityValue);
            }
            catch (NumberFormatException e) {
                specialValue.put(PROP_DOCSECURITY, this.processDocSecurity(sSecurityValue));
            }
        }
        return specialValue;
    }

    private String processDocSource(String _sDocSource) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "SRCNAME=?", "");
        aFilter.addSearchValues(0, _sDocSource);
        aFilter.setMaxRowNumber(1);
        User currUser = ContextHelper.getLoginUser();
        Sources docSources = new Sources(currUser);
        docSources.open(aFilter);
        Source docSource = null;
        if (docSources.isEmpty()) {
            docSource = new Source();
            docSource.setName(_sDocSource);
            docSource.insert(currUser);
        } else {
            docSource = (Source)docSources.getAt(0);
        }
        return String.valueOf(docSource.getId());
    }

    private String processDocSecurity(String _sDocSecurity) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "SNAME=? OR SDISP=?", "");
        aFilter.addSearchValues(0, _sDocSecurity);
        aFilter.addSearchValues(1, _sDocSecurity);
        aFilter.setMaxRowNumber(1);
        User currUser = ContextHelper.getLoginUser();
        Securities docSecurities = new Securities(currUser);
        docSecurities.open(aFilter);
        int nDocSecurity = 0;
        Security docSecurity = null;
        if (!docSecurities.isEmpty()) {
            docSecurity = (Security)docSecurities.getAt(0);
            nDocSecurity = docSecurity.getId();
        }
        return String.valueOf(nDocSecurity);
    }

    @Override
    protected void setProperty(BaseObj _currObj, String _sName, String _sValue) throws WCMException {
        block3: {
            try {
                _currObj.setPropertyWithString(_sName, _sValue);
            }
            catch (WCMException e) {
                if (e.getErrNo() != 1101) {
                    throw e;
                }
                if (!"CHNLNAME".equalsIgnoreCase(_sName)) break block3;
                this.Doc_ChannelName.put(_currObj.getPropertyAsString("DocId"), _sValue);
            }
        }
    }

    static {
        try {
            Document document = new Document();
            document.setProperty(PROP_DOCSRCNAME, "test");
        }
        catch (WCMException e) {
            DOC_HAS_DOCSRCNAME_PROP = 1101 == e.getErrNo();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

