/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.DefaultStatHandler;
import com.trs.components.stat.IStatHandler;
import com.trs.components.stat.IStatResult;
import com.trs.components.stat.IStatResults;
import com.trs.components.stat.StatResults;
import com.trs.components.stat.TimeRange;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.database.DBType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class StatAnalysisTool {
    private static Logger logger = Logger.getLogger(StatAnalysisTool.class);
    private IStatHandler m_Handler;
    private String[] m_StatSQLs;

    public StatAnalysisTool(String[] aStatSQL) {
        this.m_StatSQLs = aStatSQL;
        this.m_Handler = new DefaultStatHandler();
    }

    public StatAnalysisTool(String[] aStatSQL, IStatHandler handler) {
        this.m_StatSQLs = aStatSQL;
        this.m_Handler = handler;
    }

    public IStatResult stat(String sStartDate, String sEndDate) throws WCMException {
        CMyDateTime startDate = new CMyDateTime();
        CMyDateTime endDate = new CMyDateTime();
        try {
            startDate.setDateTimeWithString(sStartDate);
            endDate.setDateTimeWithString(sEndDate);
        }
        catch (Exception e) {
            logger.error((Object)"\u89e3\u6790\u7edf\u8ba1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u89e3\u6790\u7edf\u8ba1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", e);
        }
        return this.stat(startDate, endDate);
    }

    public IStatResult stat(CMyDateTime startDate, CMyDateTime endDate) throws WCMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4:[" + startDate + "--" + endDate + "]"));
        }
        DBType currDBType = DBManager.getDBManager().getDBType();
        String sStartTime = currDBType.sqlDate(startDate.toString());
        String sEndTime = currDBType.sqlDate(endDate.toString());
        HashMap<String, String> dateMap = new HashMap<String, String>();
        dateMap.put("STARTTIME", sStartTime);
        dateMap.put("ENDTIME", sEndTime);
        this.m_Handler.initState();
        for (int i = 0; i < this.m_StatSQLs.length; ++i) {
            String sSQL = CMyString.parsePageVariables(this.m_StatSQLs[i], dateMap);
            this.stat0(sSQL, i + 1);
        }
        return this.m_Handler.getResult();
    }

    public IStatResults stat(CMyDateTime startDate, CMyDateTime endDate, int nStepType) throws WCMException {
        StatResults results = new StatResults();
        TimeRange range = new TimeRange(startDate, endDate, nStepType);
        try {
            while (range.next()) {
                CMyDateTime start = range.getRangeStart();
                CMyDateTime end = range.getRangeEnd();
                results.addResult(this.stat(start, end));
                results.addXlabels(range.getXlabel());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"\u5904\u7406\u6bcf\u4e00\u4e2a\u5c0f\u6b65\u957f\u51fa\u73b0\u5f02\u5e38", (Throwable)ex);
            throw new WCMException("\u5904\u7406\u6bcf\u4e00\u4e2a\u5c0f\u6b65\u957f\u51fa\u73b0\u5f02\u5e38", ex);
        }
        return results;
    }

    public IStatResults stat(String sStartDate, String sEndDate, int nStepType) throws WCMException {
        CMyDateTime startDate = new CMyDateTime();
        CMyDateTime endDate = new CMyDateTime();
        try {
            startDate.setDateTimeWithString(sStartDate);
            endDate.setDateTimeWithString(sEndDate);
        }
        catch (Exception e) {
            logger.error((Object)"\u89e3\u6790\u7edf\u8ba1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u89e3\u6790\u7edf\u8ba1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", e);
        }
        return this.stat(startDate, endDate, nStepType);
    }

    private void stat0(String sSQL, int nSQLIndex) throws WCMException {
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        DBManager dbMgr = DBManager.getDBManager();
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(sSQL);
            logger.debug((Object)sSQL);
            DebugTimer timer = new DebugTimer();
            timer.start();
            rsData = oStmt.executeQuery();
            timer.stop();
            logger.debug((Object)("query use[" + timer.getTime() + "]"));
            timer.start();
            this.m_Handler.visitStart(rsData, nSQLIndex);
            while (rsData.next()) {
                this.m_Handler.visitStatItem(rsData, nSQLIndex);
            }
            this.m_Handler.visitEnd(nSQLIndex);
            timer.stop();
            logger.debug((Object)("read data use[" + timer.getTime() + "]"));
        }
        catch (SQLException ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + sSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + sSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

