/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PageGenerator;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.publish.PublishFolderClassImpl;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import org.apache.log4j.Logger;

public class WCMTagParserClassIndexGener
implements ITagParser {
    private static Logger logger = Logger.getLogger(WCMTagParserClassIndexGener.class);
    private ClassInfos m_oNeedPublishClassInfos = null;
    private IPublishFolder m_oRealRoot = null;
    private IPublishFolder m_oRealHostOfClassInfo = null;

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        TagBeanInfo tagBeanInfo = new TagBeanInfo("TRS_ClassIndexGener", I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label1", "\u5728\u5f53\u524d\u7684\u680f\u76ee\u6216\u8005\u7ad9\u70b9\u4e0b\u4ea7\u751f\u5206\u7c7b\u6cd5\u9996\u9875"), TagBeanInfo.BodyType.EMPTY);
        TagBeanAttrInfo attrInfo = null;
        attrInfo = new TagBeanAttrInfo();
        attrInfo.setName("ToLevel");
        attrInfo.setDesc(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label2", "\u53d1\u5e03\u7684\u5c42\u6b21"));
        attrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
        tagBeanInfo.addAttrInfo(attrInfo);
        attrInfo = new TagBeanAttrInfo();
        attrInfo.setName("TemplateName");
        attrInfo.setDesc(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label3", "\u5206\u7c7b\u6cd5\u4f7f\u7528\u7684\u6a21\u677f"));
        attrInfo.setType(TagBeanAttrInfo.Type.STRING);
        attrInfo.setRequired(true);
        tagBeanInfo.addAttrInfo(attrInfo);
        attrInfo = new TagBeanAttrInfo();
        attrInfo.setName("ID");
        attrInfo.setDesc(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label4", "\u6307\u5b9a\u53d1\u5e03\u7684\u5206\u7c7b\u6cd5"));
        attrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
        tagBeanInfo.addAttrInfo(attrInfo);
        attrInfo = new TagBeanAttrInfo();
        attrInfo.setName("SiteId");
        attrInfo.setDesc(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label10", "\u6307\u5b9a\u5f53\u524d\u5173\u8054\u7684root"));
        attrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
        tagBeanInfo.addAttrInfo(attrInfo);
        attrInfo = new TagBeanAttrInfo();
        attrInfo.setName("INSITE");
        attrInfo.setDesc(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label5", "\u662f\u5426\u751f\u6210\u7ad9\u70b9\u7684\u5206\u7c7b\u6cd5\u9996\u9875"));
        attrInfo.setEnumValue(new String[]{"true", "false"});
        attrInfo.setType(TagBeanAttrInfo.Type.STRING);
        tagBeanInfo.addAttrInfo(attrInfo);
        attrInfo = new TagBeanAttrInfo();
        attrInfo.setName("ClassInfoName");
        attrInfo.setDesc(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label6", "\u5206\u7c7b\u6cd5\u540d\u79f0"));
        attrInfo.setType(TagBeanAttrInfo.Type.STRING);
        tagBeanInfo.addAttrInfo(attrInfo);
        attrInfo = new TagBeanAttrInfo();
        attrInfo.setName("IGNORELEVEL");
        attrInfo.setDesc(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label11", "\u5ffd\u7565\u7684\u7ea7\u522b"));
        attrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
        tagBeanInfo.addAttrInfo(attrInfo);
        return tagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        this.makeClassInfosCanDoPublish(_context);
        if (this.m_oNeedPublishClassInfos != null && this.m_oNeedPublishClassInfos.isEmpty()) {
            return null;
        }
        this.m_oRealRoot = null;
        int nSiteId = _context.getAttribute("SiteId", 0);
        if (nSiteId > 0) {
            WebSite site = WebSite.findById(nSiteId);
            if (site == null) {
                throw new WCMException(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label7", "\u6307\u5b9a\u7684\u7ad9\u70b9\u4e0d\u5b58\u5728\uff01[SiteId=") + nSiteId + "]");
            }
            this.m_oRealRoot = (IPublishFolder)PublishElementFactory.makeElementFrom(site);
        } else {
            this.m_oRealRoot = _context.getRoot();
        }
        String sTemplateName = _context.getAttribute("TemplateName");
        if (CMyString.isEmpty(sTemplateName)) {
            throw new WCMException(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label8", "\u6ca1\u6709\u6307\u5b9a\u6a21\u677f\u540d\u79f0\uff01[\u5c5e\u6027\u540d=TemplateName]"));
        }
        Template template = TagParseHelper.findNestedTemplate(sTemplateName, this.m_oRealRoot);
        int nCurrLevel = 0;
        ClassInfo parentClassInfo = ClassInfo.findById(_context.getAttribute("ID", 0));
        if (parentClassInfo == null) {
            parentClassInfo = WCMTagParserClassIndexGener.findClassInfoByName(_context.getAttribute("ClassInfoName"));
        }
        if (parentClassInfo != null) {
            if (!this.canDoPublish(parentClassInfo.getId())) {
                return null;
            }
            this.generateClassInfoPage(_context, parentClassInfo, template);
        }
        this.publishClassInfo(_context, nCurrLevel, parentClassInfo, template);
        if (!(_context.isPreview() || this.m_oNeedPublishClassInfos != null && this.m_oNeedPublishClassInfos.isEmpty())) {
            if (this.m_oRealRoot.getId() != _context.getRoot().getId()) {
                return null;
            }
            PublishTaskContext taskContext = _context.getPageContext().getTaskContext();
            IPublishFolder taskFolder = taskContext.getStartFolder();
            if (taskFolder != null && taskFolder.equals(_context.getPageElement())) {
                String sKey;
                for (IPublishFolder parent = taskFolder.getParent(); parent != null && taskContext.getCachObject(sKey = parent.getType() + "." + parent.getId()) == null; parent = parent.getParent()) {
                    PublishServer.getInstance().publishFolder(parent, 8);
                    taskContext.putInCache(sKey, "");
                    if (parent.isRoot()) break;
                }
            }
        }
        return null;
    }

    private void makeClassInfosCanDoPublish(PublishTagContext _context) throws WCMException {
        String sContentIds;
        IPublishElement pageElement = _context.getPageElement();
        if (pageElement instanceof IPublishContent) {
            _context.addWarning(pageElement.getInfo(), pageElement.getId(), I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label9", "\u51fa\u4e8e\u6027\u80fd\u8003\u8651\uff0c\u6682\u65f6\u4e0d\u652f\u6301\u5728\u7ec6\u89c8\u4e2d\u653e\u7f6e\u8fd9\u6837\u7684\u7f6e\u6807\uff01"));
            this.m_oNeedPublishClassInfos = new ClassInfos(null);
            return;
        }
        int nPublishType = 1;
        IPublishFolder pageFolder = (IPublishFolder)pageElement;
        IPublishFolder startFolder = null;
        if (pageFolder.isRoot() && !_context.getAttribute("InSite", false)) {
            this.m_oNeedPublishClassInfos = new ClassInfos(null);
            return;
        }
        if (_context.isPreview()) {
            if (_context.getAttribute("InSite", false) && !pageFolder.isRoot()) {
                this.m_oNeedPublishClassInfos = new ClassInfos(null);
                return;
            }
            startFolder = pageFolder;
        } else {
            startFolder = _context.getPageContext().getTaskContext().getStartFolder();
            nPublishType = _context.getPageContext().getTaskContext().getTask().getPublishType();
        }
        if (startFolder.isRoot() && !pageFolder.isRoot() && _context.getAttribute("InSite", false)) {
            this.m_oNeedPublishClassInfos = new ClassInfos(null);
            return;
        }
        if (nPublishType == 7 && !CMyString.isEmpty(sContentIds = _context.getPageContext().getTaskContext().getTask().getContentIds())) {
            nPublishType = 12;
        }
        switch (nPublishType) {
            case 2: {
                return;
            }
            case 5: 
            case 8: {
                this.m_oNeedPublishClassInfos = new ClassInfos(null);
                return;
            }
            case 12: {
                if (startFolder.equals(pageFolder)) break;
                this.m_oNeedPublishClassInfos = new ClassInfos(null);
                return;
            }
        }
        WCMFilter filterQueryClassInfos = new WCMFilter();
        String sQueryClassInfoIdsWhere = null;
        switch (nPublishType) {
            case 3: 
            case 10: 
            case 12: {
                String sContentIds2 = _context.getPageContext().getTaskContext().getTask().getContentIds();
                if (CMyString.isEmpty(sContentIds2)) break;
                sQueryClassInfoIdsWhere = "ClassInfoId in(select b.ClassInfoId from XWCMClassInfoView b where b.MetaDataId in(" + sContentIds2 + "))";
                break;
            }
            default: {
                sQueryClassInfoIdsWhere = startFolder.isRoot() ? "exists(select 1 from XWCMClassInfoView a where a.ClassInfoId=XWCMClassInfo.ClassInfoId and exists(select 1 from WCMChnlDoc b where b.ChnlId in(select c.ChannelId from WCMChannel c where c.SiteId=?) and b.DocStatus=? and b.DocId=a.MetaDataId))" : "exists(select 1 from XWCMClassInfoView a where a.ClassInfoId=XWCMClassInfo.ClassInfoId and exists(select 1 from WCMChnlDoc b where b.ChnlId=? and b.DocStatus=? and b.DocId=a.MetaDataId))";
                filterQueryClassInfos.addSearchValues(startFolder.getId());
                filterQueryClassInfos.addSearchValues(10);
            }
        }
        filterQueryClassInfos.setWhere(sQueryClassInfoIdsWhere);
        logger.debug((Object)filterQueryClassInfos);
        DebugTimer timer = new DebugTimer();
        timer.start();
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, filterQueryClassInfos);
        timer.stop();
        logger.debug((Object)("query relate classinfos use[" + timer.getTime() + "]ms!"));
        int nSize = classInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            while (classInfo != null && !classInfo.isRoot() && classInfos.indexOf(classInfo.getParentId()) < 0) {
                classInfo = ClassInfo.findById(classInfo.getParentId());
                classInfos.addElement(classInfo);
            }
        }
        this.m_oNeedPublishClassInfos = classInfos;
    }

    private static boolean isClassInfoIgnored(ClassInfo _classInfo, PublishTagContext _context) throws WCMException {
        int nIgnoreLevel = _context.getAttribute("IgnoreLevel", -1);
        return WCMTagParserClassIndexGener.isClassInfoIgnored(_classInfo, nIgnoreLevel);
    }

    private static boolean isClassInfoIgnored(ClassInfo _classInfo, int _nIgnoreLevel) throws WCMException {
        if (_classInfo == null) {
            return true;
        }
        switch (_nIgnoreLevel) {
            case -1: {
                return false;
            }
            case 0: {
                return !_classInfo.isLeaf();
            }
        }
        int nLevel = WCMTagParserClassIndexGener.caculateClassInfoLevel(_classInfo);
        return nLevel <= _nIgnoreLevel;
    }

    private static int caculateClassInfoLevel(ClassInfo _classInfo) throws WCMException {
        int nLevel = 1;
        ClassInfo classInfo = _classInfo;
        while (classInfo != null && !classInfo.isRoot()) {
            classInfo = ClassInfo.findById(classInfo.getParentId());
            if (++nLevel <= 20) continue;
            logger.error((Object)(I18NMessage.get(WCMTagParserClassIndexGener.class, "WCMTagParserClassIndexGener.label12", "\u7cfb\u7edf\u5b58\u5728\u9519\u8bef\u7684\u5206\u7c7b\u6cd5\u6570\u636e\uff0c\u6709\u6b7b\u5faa\u73af\uff01[\u5f00\u59cb\u5206\u7c7b\u6cd5\u4e3a\uff1a") + _classInfo + "]"));
            break;
        }
        return nLevel;
    }

    private void publishClassInfo(PublishTagContext _context, int _nCurrLevel, ClassInfo _parentClassInfo, Template _template) throws WCMException {
        ++_nCurrLevel;
        int nToLevel = _context.getAttribute("ToLevel", 1);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("1.\u53d1\u5e03\u5206\u7c7b\u6cd5:" + _parentClassInfo + ",level:" + nToLevel));
        }
        if (_nCurrLevel > nToLevel) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("2.\u53d1\u5e03\u5206\u7c7b\u6cd5:" + _parentClassInfo + ",level:" + nToLevel));
        }
        IClassInfoMgr classInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
        ClassInfos classInfos = classInfoMgr.queryChildren(null, _parentClassInfo, null);
        int nSize = classInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo classInfo;
            if (!this.canDoPublish(classInfos.getIdAt(i)) || (classInfo = (ClassInfo)classInfos.getAt(i)) == null) continue;
            this.generateClassInfoPage(_context, classInfo, _template);
            this.publishClassInfo(_context, _nCurrLevel, classInfo, _template);
        }
    }

    private void generateClassInfoPage(PublishTagContext _context, ClassInfo classInfo, Template _template) throws WCMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("1\u5f53\u524d\u7684\u5206\u7c7b\u6cd5\u4fe1\u606f:" + classInfo));
        }
        if (WCMTagParserClassIndexGener.isClassInfoIgnored(classInfo, _context)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("2\u5f53\u524d\u7684\u5206\u7c7b\u6cd5\u4fe1\u606f:" + classInfo));
        }
        IPublishFolder root = this.m_oRealRoot == null ? _context.getRoot() : this.m_oRealRoot;
        IPublishFolder hostOfClassInfo = this.m_oRealHostOfClassInfo == null ? (IPublishFolder)_context.getUpperHost() : this.m_oRealHostOfClassInfo;
        PublishFolderClassImpl folderClassImpl = new PublishFolderClassImpl();
        folderClassImpl.setSubstance(classInfo);
        folderClassImpl.setRoot(root);
        if (_context.getAttribute("InSite", false)) {
            folderClassImpl.setHost(root);
        } else {
            folderClassImpl.setHost(hostOfClassInfo);
        }
        PublishPageContext pageContext = new PublishPageContext(folderClassImpl, _context.getPageContext().getTaskContext(), _context.getPageContext().getProgressMonitor());
        PageGenerator.generatePage(pageContext, _template);
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    public void clear() {
    }

    private boolean canDoPublish(int _nClassInfoId) {
        if (this.m_oNeedPublishClassInfos == null) {
            return true;
        }
        return this.m_oNeedPublishClassInfos.indexOf(_nClassInfoId) >= 0;
    }

    private static ClassInfo findClassInfoByName(String _sClassInfoName) throws WCMException {
        if (CMyString.isEmpty(_sClassInfoName)) {
            return null;
        }
        WCMFilter filterByName = new WCMFilter("", "CName=?", "");
        filterByName.setMaxRowNumber(1);
        filterByName.addSearchValues(_sClassInfoName);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, filterByName);
        if (classInfos.isEmpty()) {
            return null;
        }
        return (ClassInfo)classInfos.getAt(0);
    }
}

