/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyMemory;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InfoViewDatas
extends CMSBaseObjs {
    private static Logger logger = Logger.getLogger(InfoViewDatas.class);
    private String m_sIdFieldname = null;
    private String m_sDbTableName = null;
    private int m_nInfoViewId = 0;
    private InfoView m_oInfoView = null;
    public static int MAX_ROW_NUM = 1000;
    private String m_sSelectFieldsFromDB = null;
    private HashMap m_hPublicCache = new HashMap(2);
    private Map m_hViewDocumentsCache = null;
    public static int MAX_FETCH_SIZE = 1000;
    private String m_sSelectFieldsFromChnlDoc = "WCMCHNLDOC.RecId,WCMCHNLDOC.ChnlId,WCMCHNLDOC.DocId,WCMCHNLDOC.DocChannel,WCMCHNLDOC.DOCSTATUS";
    private int m_nRightIndex = -1;
    public static boolean QUERY_ACCORD_DOCUMENT_RIGHT = true;
    private static final int OPEN_MODE_OLD = 0;
    private static final int OPEN_MODE_NEW = 1;
    private int m_nOpenMode = 1;
    private int m_nRecCount = -1;
    private boolean bLoadAll = false;
    private boolean m_bFromOneTable = false;

    public InfoViewDatas() {
    }

    public InfoViewDatas(int infoViewId) throws WCMException {
        this.m_nInfoViewId = infoViewId;
        this.m_oInfoView = InfoView.findById(this.m_nInfoViewId);
        this.m_sDbTableName = InfoViewConstants.makeTrueTableName(this.getInfoViewId());
        this.m_sIdFieldname = InfoViewConstants.getIdFieldName(this.m_sDbTableName);
        this.m_sSelectFieldsFromDB = this.m_sDbTableName + ".*";
    }

    public int getInfoViewId() {
        return this.m_nInfoViewId;
    }

    public void setInfoViewId(int infoViewId) {
        this.m_nInfoViewId = infoViewId;
    }

    public InfoViewDatas(InfoView _infoview) {
        this.m_nInfoViewId = _infoview.getId();
        this.m_oInfoView = _infoview;
        this.m_sDbTableName = InfoViewConstants.makeTrueTableName(this.getInfoViewId());
        this.m_sIdFieldname = InfoViewConstants.getIdFieldName(this.m_sDbTableName);
        this.m_sSelectFieldsFromDB = this.m_sDbTableName + ".*";
    }

    public InfoViewDatas(User _currUser, int _initCapacity, int _incCapacity) {
        super(_currUser, _initCapacity, _incCapacity);
    }

    @Override
    public String getDbTableName() {
        return this.m_sDbTableName == null ? InfoViewConstants.makeTrueTableName(this.getInfoViewId()) : this.m_sDbTableName;
    }

    @Override
    public String getIdFieldName() {
        return this.m_sIdFieldname == null ? InfoViewConstants.getIdFieldName(this.getDbTableName()) : this.m_sIdFieldname;
    }

    public void setIdFieldName(String _sIdFieldName) {
        this.m_sIdFieldname = _sIdFieldName;
    }

    @Override
    public Class getElementClass() {
        return InfoViewData.class;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new InfoViewDatas(null, 1, 1);
    }

    @Override
    protected BaseObj createElementInstance() {
        InfoViewData data = new InfoViewData();
        data.setIdFieldName(this.getIdFieldName());
        return data;
    }

    public static final InfoViewDatas findByIds(User _currUser, int _nInfoViewId, String _sInfoViewDataIds) throws WCMException {
        if (_sInfoViewDataIds.length() <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewDatas.class, "InfoViewDatas.label1", "\u6307\u5b9a\u5bf9\u8c61ID\u5e8f\u5217\u65e0\u6548\uff01"));
        }
        InfoViewDatas currInfoViewDatas = InfoViewDatas.createNewInstance(_nInfoViewId);
        currInfoViewDatas.addElement(_sInfoViewDataIds);
        return currInfoViewDatas;
    }

    public static final InfoViewDatas findByDocIds(User _currUser, int _nInfoViewId, String _sDocumentIds) throws WCMException {
        if (_sDocumentIds.length() <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewDatas.class, "InfoViewDatas.label1", "\u6307\u5b9a\u5bf9\u8c61ID\u5e8f\u5217\u65e0\u6548\uff01"));
        }
        InfoViewDatas currInfoViewDatas = InfoViewDatas.createNewInstance(_nInfoViewId);
        currInfoViewDatas.setIdFieldName("DocumentId");
        currInfoViewDatas.addElement(_sDocumentIds);
        return currInfoViewDatas;
    }

    public static final InfoViewDatas openWCMObjs(int nInfoViewId, WCMFilter _filter) throws WCMException {
        InfoViewDatas currMetaViewDatas = InfoViewDatas.createNewInstance(nInfoViewId);
        currMetaViewDatas.open(_filter);
        return currMetaViewDatas;
    }

    public static InfoViewDatas createNewInstance(int _nInfoViewId) throws WCMException {
        return new InfoViewDatas(_nInfoViewId);
    }

    public int getOpenMode() {
        return this.m_nOpenMode;
    }

    public void setOpenMode(int _sOpenMode) {
        this.m_nOpenMode = _sOpenMode;
    }

    @Override
    public void setRecCount(int _nRecCount) {
        if (_nRecCount < 0) {
            return;
        }
        this.m_nRecCount = _nRecCount;
    }

    @Override
    public int getRecCount() {
        if (this.m_nRecCount < 0) {
            return this.size();
        }
        return this.m_nRecCount;
    }

    @Override
    public synchronized void open(WCMFilter _filter) throws WCMException {
        this.open(_filter, null);
    }

    public synchronized void open(WCMFilter _filter, WCMFilter _countFilter) throws WCMException {
        if (this.m_nOpenMode == 0) {
            super.open(_filter);
            return;
        }
        if (CMyString.isEmpty(_filter.getFrom())) {
            _filter.setFrom(this.getDbTableName());
        }
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)"==========open SQL Info=========");
            logger.fatal((Object)(_filter + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        int nCount = this.m_nRecCount;
        DebugTimer timer = new DebugTimer();
        if (nCount < 0) {
            timer.start();
            nCount = _countFilter != null ? DBManager.getDBManager().sqlExecuteCountQuery(_countFilter) : DBManager.getDBManager().sqlExecuteCountQuery(_filter);
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.fatal((Object)("Query Count use [" + timer.getTime() + "]ms!"));
                logger.fatal((Object)(_filter.toCountQueryInfo() + "\n"));
                logger.fatal((Object)CMyMemory.toMemoryInfo());
            }
            this.m_nRecCount = nCount;
        }
        if (nCount == 0) {
            return;
        }
        CPager currPager = new CPager(this.getPageSize());
        currPager.setItemCount(nCount);
        currPager.setCurrentPageIndex(this.getCurrPage());
        timer.start();
        int nDataCount = this.loadPrePageDatasOneTable(_filter, currPager);
        if ((nDataCount == 0 || nDataCount < nCount && nDataCount < this.getPageSize()) && _countFilter != null) {
            if ((_filter = this.removeTimeLimitFromSrcFilter(_filter, _countFilter)) == null) {
                return;
            }
            logger.info((Object)"reload data remove time limit!");
            logger.info((Object)_filter);
            nDataCount = this.loadPrePageDatasOneTable(_filter, currPager);
        }
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPrePageDatas use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (this.isEmpty()) {
            return;
        }
        timer.start();
        this.loadViewDatasOfPageOneTable(currPager.getCurrentPageIndex() - 1);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPageDocuments use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
    }

    private boolean loadViewDatasOfPageOneTable(int _pageIndex) throws WCMException {
        if (this.pageSize == -1) {
            this.pageSize = MAX_FETCH_SIZE;
            int nPageIndex = 0;
            int i = 0;
            while (i < this.size()) {
                this.loadViewDatasOfPage(_pageIndex);
                i += MAX_FETCH_SIZE;
                ++nPageIndex;
            }
            return true;
        }
        String strSQL = this.makeLoadViewDatasSQLOfPage(_pageIndex);
        if (strSQL == null) {
            return false;
        }
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        try {
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setMaxRows(this.pageSize);
            if (this.pageSize > MAX_FETCH_SIZE) {
                oStmt.setFetchSize(MAX_FETCH_SIZE);
            } else {
                oStmt.setFetchSize(this.pageSize);
            }
            this.setPreStmtParamsOfPageViewDatas(_pageIndex, oStmt);
            aTimer.start();
            rsData = oStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            aTimer.start();
            while (rsData.next()) {
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                InfoViewData currObject = new InfoViewData(this.m_oInfoView, this.m_hPublicCache);
                currObject.readFromRs(rsData, rsmdData);
                if (this.m_oObjsBuffer == null) {
                    this.m_oObjsBuffer = new Hashtable();
                }
                this.m_oObjsBuffer.put(currObject.getKey(), currObject);
            }
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            boolean currObject = true;
            return currObject;
        }
        catch (SQLException ex) {
            throw new WCMException(40, "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08" + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08" + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadPrePageDatasOneTable(WCMFilter _filter, CPager _pager) throws WCMException {
        int nCount;
        WCMFilter loadPreDataFilter;
        Statement oPreStmt;
        Connection oConn;
        block34: {
            this.m_bFromOneTable = true;
            DebugTimer aTimer = new DebugTimer();
            this.vIdList = new Vector(_pager.getItemCount());
            oConn = null;
            oPreStmt = null;
            ResultSet rsData = null;
            String strSQL = "";
            loadPreDataFilter = null;
            if (this.currMode == 2) {
                throw new WCMException(1100, "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01" + this.getClass().getName());
            }
            loadPreDataFilter = this.makeQueryPreDataFilter(_filter, this.getDbTableName() + "." + this.getIdFieldName());
            strSQL = loadPreDataFilter.toSQL();
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            int nMaxSize = MAX_FETCH_SIZE;
            if (_pager.getPageSize() < 0) {
                if (_pager.getItemCount() < nMaxSize) {
                    oPreStmt.setFetchSize(_pager.getItemCount());
                } else {
                    oPreStmt.setFetchSize(nMaxSize);
                }
            } else {
                int nMaxRowNum;
                if (_pager.getPageSize() < nMaxSize) {
                    oPreStmt.setFetchSize(_pager.getPageSize());
                } else {
                    oPreStmt.setFetchSize(nMaxSize);
                }
                if (_pager.getCurrentPageIndex() == 1) {
                    nMaxRowNum = Math.min(_pager.getPageSize(), this.m_nRecCount);
                    oPreStmt.setMaxRows(nMaxRowNum);
                } else if (MAX_ROW_NUM > 0 && _pager.getLastItemIndex() <= MAX_ROW_NUM) {
                    nMaxRowNum = Math.min(_pager.getLastItemIndex(), this.m_nRecCount);
                    oPreStmt.setMaxRows(nMaxRowNum);
                }
            }
            DBManager.setParameters((PreparedStatement)oPreStmt, loadPreDataFilter);
            aTimer.start();
            rsData = oPreStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)loadPreDataFilter);
                logger.debug((Object)("query id use[" + aTimer.getTime() + "]ms!"));
            }
            nCount = 0;
            ResultSetMetaData rsmdData = null;
            while (rsData.next()) {
                if (++nCount < _pager.getFirstItemIndex()) {
                    this.vIdList.add(ID_NOT_LOAD);
                    continue;
                }
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                int nId = rsData.getInt(this.getIdFieldName());
                this.vIdList.add(new Integer(nId));
                if (nCount < _pager.getLastItemIndex()) continue;
            }
            rsData.close();
            if (nCount != 0) break block34;
            int n = nCount;
            try {
                if (oPreStmt != null) {
                    oPreStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
            this.currIndex = this.size() > 0 ? 0 : -2;
            return n;
        }
        for (int i = nCount; i < _pager.getItemCount(); ++i) {
            this.vIdList.add(ID_NOT_LOAD);
        }
        int n = nCount;
        try {
            if (oPreStmt != null) {
                oPreStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oConn != null) {
            this.getDBManager().freeConnection(oConn);
        }
        this.currIndex = this.size() > 0 ? 0 : -2;
        return n;
        catch (SQLException ex) {
            try {
                throw new WCMException(40, "\u9884\u5148\u8bfb\u5165\u5c0f\u6570\u636e\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08" + this.getClass().getName() + ".refresh)\uff1a\n" + loadPreDataFilter, ex);
                catch (Exception ex2) {
                    throw new WCMException(0, "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08" + this.getClass().getName() + ".refresh)", ex2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oPreStmt != null) {
                        oPreStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
                this.currIndex = this.size() > 0 ? 0 : -2;
                throw throwable;
            }
        }
    }

    private WCMFilter makeQueryPreDataFilter(WCMFilter _filter, String _sSelectFields) {
        WCMFilter newFilter = new WCMFilter(_filter);
        String strFrom = _filter.getFrom();
        if (strFrom == null || (strFrom = strFrom.trim()).length() == 0) {
            newFilter.setFrom(this.getDbTableName());
        }
        newFilter.setSelect(_sSelectFields);
        return newFilter;
    }

    private WCMFilter removeTimeLimitFromSrcFilter(WCMFilter _filter, WCMFilter _countFilter) {
        if (_countFilter == null) {
            return null;
        }
        List lSearchValuesOfFirst = _filter.getSearchValues();
        if (lSearchValuesOfFirst == null) {
            return null;
        }
        List lSearchValuesOfCount = _countFilter.getSearchValues();
        if (lSearchValuesOfCount == null || lSearchValuesOfFirst.size() <= lSearchValuesOfCount.size()) {
            return null;
        }
        for (int i = lSearchValuesOfFirst.size() - 1; i >= 0; --i) {
            Object oValue = lSearchValuesOfFirst.get(i);
            if (!(oValue instanceof CMyDateTime)) continue;
            lSearchValuesOfFirst.remove(i);
        }
        _filter.setWhere(_countFilter.getWhere());
        return _filter;
    }

    private boolean hasRight(RightValue _rightValue) {
        if (this.m_nRightIndex == 64) {
            return _rightValue.getValue() > 0L;
        }
        return _rightValue.isHasRight(this.m_nRightIndex);
    }

    private boolean isVisible(InfoViewData _oInfoViewData) throws WCMException {
        if (this.m_nRightIndex == -1 || !QUERY_ACCORD_DOCUMENT_RIGHT) {
            return true;
        }
        int nDocId = _oInfoViewData.getInfoViewDataId();
        if (!DocumentAuthServer.isDefineRightOnDocument(nDocId)) {
            return true;
        }
        RightValue rightValue = new RightValue();
        rightValue.load(this.currUser, 605, nDocId, true);
        if (this.hasRight(rightValue)) {
            return true;
        }
        String GET_CRUSER_SQL = "select CrUser from WCMDocument where DocId=?";
        String sCrUser = DBManager.getDBManager().sqlExecuteStringQuery("select CrUser from WCMDocument where DocId=?", new int[]{nDocId});
        return this.currUser.getName().equals(sCrUser);
    }

    private boolean loadInfoViewDatasOfPageOneTable(int _pageIndex) throws WCMException {
        if (this.pageSize == -1) {
            this.pageSize = MAX_FETCH_SIZE;
            int nPageIndex = 1;
            int i = 0;
            while (i < this.size()) {
                this.loadViewDatasOfPage(_pageIndex);
                i += MAX_FETCH_SIZE;
                ++nPageIndex;
            }
            return true;
        }
        String strSQL = this.makeLoadViewDatasSQLOfPage(_pageIndex);
        if (strSQL == null) {
            return false;
        }
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        try {
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setMaxRows(this.pageSize);
            if (this.pageSize > MAX_FETCH_SIZE) {
                oStmt.setFetchSize(MAX_FETCH_SIZE);
            } else {
                oStmt.setFetchSize(this.pageSize);
            }
            this.setPreStmtParamsOfPageViewDatas(_pageIndex, oStmt);
            aTimer.start();
            rsData = oStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            aTimer.start();
            while (rsData.next()) {
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                InfoViewData currObject = null;
                currObject = new InfoViewData(this.m_oInfoView, this.m_hPublicCache);
                currObject.readFromRs(rsData, rsmdData);
                if (this.m_oObjsBuffer == null) {
                    this.m_oObjsBuffer = new Hashtable();
                }
                this.m_oObjsBuffer.put(currObject.getKey(), currObject);
            }
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            boolean currObject = true;
            return currObject;
        }
        catch (SQLException ex) {
            throw new WCMException(40, "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08" + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08" + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    private boolean loadViewDatasOfPage(int _pageIndex) throws WCMException {
        if (this.pageSize == -1) {
            this.pageSize = MAX_FETCH_SIZE;
            int nPageIndex = 1;
            int i = 0;
            while (i < this.size()) {
                this.loadViewDatasOfPage(_pageIndex);
                i += MAX_FETCH_SIZE;
                ++nPageIndex;
            }
            return true;
        }
        String strSQL = this.makeLoadViewDatasSQLOfPage(_pageIndex);
        if (strSQL == null) {
            return false;
        }
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        try {
            int nInfoViewDataId;
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setMaxRows(this.pageSize);
            if (this.pageSize > MAX_FETCH_SIZE) {
                oStmt.setFetchSize(MAX_FETCH_SIZE);
            } else {
                oStmt.setFetchSize(this.pageSize);
            }
            this.setPreStmtParamsOfPageViewDatas(_pageIndex, oStmt);
            aTimer.start();
            rsData = oStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            aTimer.start();
            while (rsData.next()) {
                InfoViewData[] pViewDatas;
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                if ((pViewDatas = this.getViewDocuments(nInfoViewDataId = rsData.getInt(this.m_sIdFieldname))) == null) {
                    this.printErrorInfo(nInfoViewDataId, strSQL, "ViewDocument\u7f13\u51b2\u7ef4\u62a4\u6709\u95ee\u9898\uff1f\u6307\u5b9a\u7684DocId\u5bf9\u5e94\u7684ViewDocument\u4e0d\u80fd\u83b7\u5f97\uff01");
                    continue;
                }
                InfoViewData currObject = pViewDatas[0];
                currObject.readFromRs(rsData, rsmdData);
                int nCount = pViewDatas.length;
                for (int i = 1; i < nCount; ++i) {
                    pViewDatas[i].cloneDocumentProperties(currObject);
                }
            }
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            nInfoViewDataId = 1;
            return nInfoViewDataId != 0;
        }
        catch (SQLException ex) {
            throw new WCMException(40, "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08" + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08" + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    private void putViewDocument(int _nDocId, InfoViewData _infoViewDocument) {
        if (this.m_hViewDocumentsCache == null) {
            this.m_hViewDocumentsCache = this.pageSize > 0 ? new HashMap(this.pageSize) : new HashMap(this.vIdList.capacity());
        }
        InfoViewData[] pViewDocuments = null;
        Integer iDocIdKey = new Integer(_nDocId);
        pViewDocuments = (InfoViewData[])this.m_hViewDocumentsCache.get(iDocIdKey);
        if (pViewDocuments == null) {
            pViewDocuments = new InfoViewData[]{_infoViewDocument};
        } else {
            int nOldLength = pViewDocuments.length;
            InfoViewData[] pTemp = new InfoViewData[nOldLength + 1];
            if (nOldLength > 0) {
                System.arraycopy(pViewDocuments, 0, pTemp, 0, nOldLength);
            }
            pTemp[nOldLength] = _infoViewDocument;
            pViewDocuments = pTemp;
        }
        this.m_hViewDocumentsCache.put(iDocIdKey, pViewDocuments);
    }

    private InfoViewData[] getViewDocuments(int _nInfoViewDataId) {
        if (this.m_hViewDocumentsCache == null) {
            return null;
        }
        Integer iDocIdKey = new Integer(_nInfoViewDataId);
        return (InfoViewData[])this.m_hViewDocumentsCache.get(iDocIdKey);
    }

    private String makeLoadViewDatasSQLOfPage(int _pageIndex) {
        this.m_sSelectFieldsFromDB = this.m_sIdFieldname + "," + this.m_sSelectFieldsFromDB;
        String sFrom = this.m_sDbTableName;
        String sWhere = CMyString.filterForSQL2(this.makeLoadPageWhere(_pageIndex));
        StringBuffer sbSQL = new StringBuffer(this.m_sSelectFieldsFromDB.length() + sFrom.length() + sWhere.length() + 21);
        sbSQL.append("select ");
        sbSQL.append(this.m_sSelectFieldsFromDB);
        sbSQL.append(" from ");
        sbSQL.append(sFrom);
        if (sWhere.length() > 0) {
            sbSQL.append(" where ");
            sbSQL.append(sWhere);
        }
        return sbSQL.toString();
    }

    private String makeLoadPageWhere(int _pageIndex) {
        int nEnd;
        int nStart = this.getStartPos(_pageIndex);
        if (nStart >= (nEnd = this.getEndPos(nStart)) || nStart < 0) {
            return "";
        }
        String sWhere = this.m_sIdFieldname + " in(";
        sWhere = sWhere + "?";
        for (int i = nStart + 1; i < nEnd; ++i) {
            sWhere = sWhere + ", ?";
        }
        sWhere = sWhere + ")";
        return sWhere;
    }

    /*
     * Unable to fully structure code
     */
    private void setPreStmtParamsOfPageViewDatas(int _pageIndex, PreparedStatement stmt) throws SQLException {
        nStart = this.getStartPos(_pageIndex);
        if (nStart >= (nEnd = this.getEndPos(nStart)) || nStart < 0) {
            return;
        }
        nSize = this.size();
        i = nStart;
        nParamIndex = 1;
        while (i < nEnd) {
            block4: {
                nId = 0;
                if (i >= nSize) ** GOTO lbl19
                if (!this.m_bFromOneTable) break block4;
                nId = this.getIdAt(i);
                ** GOTO lbl19
            }
            viewDocument = (InfoViewData)this.getAt(i);
            if (viewDocument == null) {
                this.printErrorInfo(this.getIdAt(i), null, "setPageDocumentsPreStmtParams\u53d1\u73b0\u7a0b\u5e8f\u9519\u8bef\uff01");
            } else {
                nId = viewDocument.getInfoViewDataId();
lbl19:
                // 3 sources

                stmt.setInt(nParamIndex, nId);
            }
            ++i;
            ++nParamIndex;
        }
    }

    private void printErrorInfo(int _nCurrDocId, String _sCurrSQL, String _sTitle) {
        logger.error((Object)_sTitle);
        logger.error((Object)("DocId:" + _nCurrDocId));
        logger.error((Object)("strSQL:" + _sCurrSQL));
        logger.error((Object)("m_oObjsBuffer:" + this.m_oObjsBuffer));
        logger.error((Object)("m_oObjsBuffer.size:" + this.m_oObjsBuffer.size()));
    }
}

