/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowNotify;
import com.trs.cms.process.IFlowNotifyAcceptor;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DefaultFlowNotify
implements IFlowNotify,
IFlowNotifyAcceptor {
    private static Logger logger = Logger.getLogger(DefaultFlowNotify.class);
    protected final String TEMPLATEPATH = "/flowservertemplate/";
    protected IFlowContent m_oFlowContent;
    protected int m_nFlowDocId;
    protected Properties properties = null;
    protected Map propertiesMap = null;
    protected boolean bLoadedTemplate = false;

    public DefaultFlowNotify(IFlowContent oFlowContent, int nFlowDocId) {
        this.m_oFlowContent = oFlowContent;
        this.m_nFlowDocId = nFlowDocId;
    }

    @Override
    public String getDesc() {
        HashMap descMap = new HashMap();
        Map propertiesMap = null;
        try {
            propertiesMap = this.getProperties();
        }
        catch (WCMException e) {
            logger.error((Object)I18NMessage.get(DefaultFlowNotify.class, "DefaultFlowNotify.label1", "\u83b7\u53d6\u5f53\u524d\u6d41\u8f6c\u5bf9\u8c61\u7684AllProperties\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)e);
        }
        for (Object key : propertiesMap.keySet()) {
            Object value = propertiesMap.get(key);
            descMap.put(key, CMyString.transDisplay(value.toString()));
        }
        String sDesc = this.getTemplate().getProperty("description");
        sDesc = CMyString.getStr(sDesc, "gbk");
        try {
            sDesc = CMyString.parsePageVariables(sDesc, descMap);
        }
        catch (WCMException e) {
            logger.error((Object)I18NMessage.get(DefaultFlowNotify.class, "DefaultFlowNotify.label2", "\u66ff\u6362\u5de5\u4f5c\u6d41\u6a21\u677f\u4e2d\u7684\u5b57\u6bb5\u53d8\u91cf\u5931\u8d25\uff01"), (Throwable)e);
        }
        return sDesc;
    }

    @Override
    public String getTitle() {
        HashMap titleMap = new HashMap();
        try {
            titleMap.putAll(this.getProperties());
        }
        catch (WCMException e) {
            logger.error((Object)I18NMessage.get(DefaultFlowNotify.class, "DefaultFlowNotify.label3", "\u83b7\u53d6\u6d41\u8f6c\u5185\u5bb9\u5173\u8054\u7684\u5bf9\u8c61\u7684\u6240\u6709\u5c5e\u6027\u5931\u8d25\uff01"), (Throwable)e);
        }
        String sTitle = this.getTemplate().getProperty("title");
        sTitle = CMyString.getStr(sTitle, "gbk");
        try {
            sTitle = CMyString.parsePageVariables(sTitle, titleMap);
        }
        catch (WCMException e) {
            logger.error((Object)I18NMessage.get(DefaultFlowNotify.class, "DefaultFlowNotify.label4", "\u66ff\u6362\u5de5\u4f5c\u6d41\u6a21\u677f\u4e2d\u7684\u5b57\u6bb5\u53d8\u91cf\u5931\u8d25\uff01"), (Throwable)e);
        }
        return sTitle;
    }

    @Override
    public boolean accept() {
        return false;
    }

    protected Properties loadTemplate(String sTemplatPath) {
        Properties props = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream(sTemplatPath);
        if (inputStream == null) {
            return null;
        }
        try {
            props.load(inputStream);
            return props;
        }
        catch (IOException e) {
            logger.error((Object)I18NMessage.get(DefaultFlowNotify.class, "DefaultFlowNotify.label5", "\u52a0\u8f7d\u5de5\u4f5c\u6d41\u6a21\u677f\u5931\u8d25\uff01"), (Throwable)e);
            return null;
        }
    }

    protected synchronized Properties getTemplate() {
        if (this.bLoadedTemplate) {
            return this.properties;
        }
        String sTemplatPath = "/flowservertemplate/" + this.m_oFlowContent.getContentType() + ".properties";
        this.properties = this.loadTemplate(sTemplatPath);
        if (this.properties == null) {
            this.properties = this.loadTemplate("/flowservertemplate/default.properties");
        }
        this.bLoadedTemplate = true;
        return this.properties;
    }

    protected synchronized Map getProperties() throws WCMException {
        if (this.propertiesMap != null) {
            return this.propertiesMap;
        }
        this.propertiesMap = this.m_oFlowContent.getSubinstance().getAllProperty();
        this.propertiesMap.put("SDOWITHURL", this.getDoWithUrl());
        this.propertiesMap.put("CONTENTDESC", this.m_oFlowContent.getDesc());
        return this.propertiesMap;
    }

    protected String getDoWithUrl() {
        try {
            String sAppDomain = ConfigServer.getServer().getSysConfigValue("WCM_URL", "htttp://localhost/wcm/");
            sAppDomain = CMyString.setStrEndWith(sAppDomain, '/');
            String sDowithURL = sAppDomain + ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME", "app") + "/flowdoc/workflow_process_render.jsp?FlowDocId=" + this.m_nFlowDocId;
            return sDowithURL;
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(DefaultFlowNotify.class, "DefaultFlowNotify.label6", "\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)e);
            return null;
        }
    }
}

