/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FormElementsValidator
extends AbstractValidator {
    protected String m_sType = I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label1", "\u8868\u5355\u63a7\u4ef6");
    protected Object m_oWarning = I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label2", "\u53ef\u80fd\u539f\u56e0:") + I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label3", "1\u3001Input(type=image)\u63a7\u4ef6\u6ca1\u6709\u6307\u5b9aalt/title\u5c5e\u6027;") + I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label4", "2\u3001Input(type=button/submit/reset)\u63a7\u4ef6\u6ca1\u6709\u6307\u5b9avalue\u5c5e\u6027;") + I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label5", "3\u3001Input(type=text/radio/checkbox/password)/Select/Textarea\u63a7\u4ef6\u6ca1\u6709\u6307\u5b9atitle\u5c5e\u6027\u4e14\u6ca1\u6709\u76f8\u5173\u7684label\u8282\u70b9") + I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label6", "4\u3001Button\u63a7\u4ef6\u6ca1\u6709\u6307\u5b9a\u6587\u672c\u5185\u5bb9\u4e14\u6ca1\u6709title\u5c5e\u6027");
    private HashMap currLabels = null;
    protected String m_oExample = I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label7", "1\u3001\u4e3aInput(type=image)\u63a7\u4ef6\u6307\u5b9aalt\u5c5e\u6027\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;input type=\"image\" src=\"search.gif\" <span style=\"color:blue\">alt=\"Do Search\"</span>&gt;<br>" + I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label8", "<br>2\u3001\u4e3aInput(type=button/submit/reset)\u63a7\u4ef6\u6307\u5b9avalue\u5c5e\u6027\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;input type=\"submit\" <span style=\"color:blue\">value=\"Ok\"</span>&gt;<br>" + I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label9", "<br>3\u3001\u4e3aInput(type=text/radio/checkbox/password)/Select/Textarea\u63a7\u4ef6\u6307\u5b9atitle\u5c5e\u6027\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;input type=\"text\" <span style=\"color:blue\">title=\"User Name\"</span>&gt;<br>" + I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label10", "<br>4\u3001\u4e3aButton\u63a7\u4ef6\u6307\u5b9a\u6587\u672c\u5185\u5bb9\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;button&gt;<span style=\"color:blue\"" + I18NMessage.get(FormElementsValidator.class, "FormElementsValidator.label11", ">\u6309\u94ae\u5185\u5bb9</span>&lt;/button&gt;");

    @Override
    public Object doValid(String content, HashMap known) {
        this.currLabels = new HashMap();
        String eleName = "LABEL";
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        for (int i = 0; i < tags.size(); ++i) {
            int[] pos = (int[])tags.get(i);
            String attrs = HTMLUtil.getEleAttrs(content, pos, eleName);
            HashMap hsAttrs = HTMLUtil.makeHsAttrs(attrs);
            String sForId = (String)hsAttrs.get("for");
            if (sForId == null) continue;
            this.currLabels.put(sForId, Boolean.TRUE);
        }
        ArrayList rst = new ArrayList();
        this.renderEleInput(content, rst, "INPUT");
        this.renderEle(content, rst, "SELECT");
        this.renderEle(content, rst, "TEXTAREA");
        this.renderEle(content, rst, "BUTTON");
        return rst;
    }

    private void renderEleInput(String content, List rstFail, String eleName) {
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        for (int i = 0; i < tags.size(); ++i) {
            int[] pos = (int[])tags.get(i);
            String attrs = HTMLUtil.getEleAttrs(content, pos, eleName);
            HashMap hsAttrs = HTMLUtil.makeHsAttrs(attrs);
            String attrType = (String)hsAttrs.get("type");
            if (this.currLabels.containsKey(CMyString.showNull((String)hsAttrs.get("id"))) || "hidden".equalsIgnoreCase(attrType) || ("submit".equalsIgnoreCase(attrType) || "button".equalsIgnoreCase(attrType) || "reset".equalsIgnoreCase(attrType) ? !CMyString.isEmpty((String)hsAttrs.get("value")) : ("image".equalsIgnoreCase(attrType) ? !CMyString.isEmpty((String)hsAttrs.get("title")) || !CMyString.isEmpty((String)hsAttrs.get("alt")) : !CMyString.isEmpty((String)hsAttrs.get("title"))))) continue;
            this.addToList(content, rstFail, pos);
        }
    }

    private void renderEle(String content, List rstFail, String eleName) {
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        for (int i = 0; i < tags.size(); ++i) {
            String innerHTML;
            int[] pos = (int[])tags.get(i);
            String attrs = HTMLUtil.getEleAttrs(content, pos, eleName);
            HashMap hsAttrs = HTMLUtil.makeHsAttrs(attrs);
            if (this.currLabels.containsKey(CMyString.showNull((String)hsAttrs.get("id"))) || "BUTTON".equalsIgnoreCase(eleName) && !CMyString.isEmpty(innerHTML = HTMLUtil.getEleInnerHTML(content, pos).trim()) || !CMyString.isEmpty((String)hsAttrs.get("title"))) continue;
            this.addToList(content, rstFail, pos);
        }
    }

    private void addToList(String content, List rstFail, int[] pos) {
        int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
        rstFail.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), HTMLUtil.getEleOuterHTML(content, pos)});
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }
}

