/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet;

import com.trs.infra.util.CMyString;
import com.trs.servlet.Acl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AclFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(AclFilter.class);
    private static final String CONF = "/acl_access.conf";
    private static final Map FILTER = new HashMap(256);
    private static final Acl DEFAULT_ACL = new Acl();

    public void destroy() {
        FILTER.clear();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            filterChain.doFilter(req, resp);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        String path = request.getServletPath();
        Acl acl = (Acl)FILTER.get(path);
        if (acl == null) {
            filterChain.doFilter(req, resp);
            return;
        }
        try {
            if (acl.isAccessable(request, (HttpServletResponse)resp)) {
                filterChain.doFilter(req, resp);
                return;
            }
        }
        catch (Exception e) {
            throw new ServletException("Oops... errors: " + CMyString.showEmpty(e.getMessage()), (Throwable)e);
        }
        throw new ServletException("Sorry, access forbidden!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig config) throws ServletException {
        Class<?> clazz = this.getClass();
        InputStream ins = null;
        BufferedReader reader = null;
        InputStreamReader insr = null;
        try {
            ins = clazz.getResourceAsStream(CONF);
            if (ins == null) {
                ins = clazz.getResourceAsStream(CONF.substring(1));
            }
            if (ins == null) {
                LOG.warn((Object)"No acl filter config.");
                return;
            }
            insr = new InputStreamReader(ins);
            reader = new BufferedReader(insr);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                int equalMarkIndex = line.indexOf(61);
                if (equalMarkIndex == -1) {
                    FILTER.put(line, DEFAULT_ACL);
                    continue;
                }
                String path = line.substring(0, equalMarkIndex);
                String clazzName = line.substring(equalMarkIndex + 1);
                Acl acl = null;
                try {
                    clazz = Class.forName(clazzName);
                    acl = (Acl)clazz.newInstance();
                }
                catch (Exception e) {
                    acl = DEFAULT_ACL;
                }
                FILTER.put(path, acl);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("filter size: " + FILTER.size()));
                for (Map.Entry entry : FILTER.entrySet()) {
                    LOG.debug((Object)(entry.getKey() + "=" + entry.getValue()));
                }
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"filter init config failed.", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

