/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskRuntime;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTasks;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.service.IPublishService;
import java.util.Iterator;

public class PublishService
implements IPublishService {
    private PublishServer m_oPublishServer = PublishServer.getInstance();
    private IPublishTaskMgr m_oPublishTaskMgr = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");

    @Override
    public User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public String[] preview(BaseChannel _siteOrChannel, String[] _warningsToReturn) throws WCMException {
        int nRightIndex;
        if (_siteOrChannel == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label1", "\u6307\u5b9a\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        int n = nRightIndex = _siteOrChannel.isSite() ? 3 : 15;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_siteOrChannel, nRightIndex)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8") + this.getSiteOrChannelMsg(_siteOrChannel));
        }
        try {
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_siteOrChannel);
            return this.m_oPublishServer.previewFolder(folder, _warningsToReturn);
        }
        catch (WCMDatainvalidException e) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishService.class, "PublishService.label3", "\u9884\u89c8[") + _siteOrChannel + I18NMessage.get(PublishService.class, "PublishService.label4", "]\u5931\u8d25\u2014\u2014\u6570\u636e\u6709\u8bef\uff1a\n") + e.getMyMessage());
        }
        catch (WCMException ex) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label5", "\u9884\u89c8") + (_siteOrChannel.isSite() ? I18NMessage.get(PublishService.class, "PublishService.label6", "\u7ad9\u70b9") : I18NMessage.get(PublishService.class, "PublishService.label7", "\u9891\u9053")) + I18NMessage.get(PublishService.class, "PublishService.label8", "\u5931\u8d25"), ex);
        }
    }

    private String getSiteOrChannelMsg(BaseChannel _siteOrChannel) {
        return (_siteOrChannel.isSite() ? I18NMessage.get(PublishService.class, "PublishService.label6", "\u7ad9\u70b9") : I18NMessage.get(PublishService.class, "PublishService.label7", "\u9891\u9053")) + "[" + _siteOrChannel.getName() + "](ID=" + _siteOrChannel.getId() + ")";
    }

    @Override
    public String preview(Document _document, String[] _warningsHolder) throws WCMException {
        if (_document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        return this.preview(_document, _document.getChannel(), _warningsHolder);
    }

    @Override
    public String preview(Document _document, Channel _channel, String[] _warningsHolder) throws WCMException {
        if (_document == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_document, 38)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8") + this.getSiteOrChannelMsg(_channel) + I18NMessage.get(PublishService.class, "PublishService.label10", "\u4e2d\u7684\u6587\u6863"));
        }
        try {
            IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(_document);
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channel);
            content.setFolder(folder);
            return this.m_oPublishServer.previewContent(content, _warningsHolder);
        }
        catch (WCMDatainvalidException e) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishService.class, "PublishService.label3", "\u9884\u89c8[") + _document + I18NMessage.get(PublishService.class, "PublishService.label11", "]\u5931\u8d25-\u6570\u636e\u6709\u8bef\uff1a") + e.getMyMessage(), e);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to preview the document!", ex);
        }
    }

    @Override
    public String previewInfoviewPrint(Document _document, Channel _channel, String[] _warningsHolder, int _templateId) throws WCMException {
        if (_document == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_document, 38)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8") + this.getSiteOrChannelMsg(_channel) + I18NMessage.get(PublishService.class, "PublishService.label10", "\u4e2d\u7684\u6587\u6863"));
        }
        try {
            IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(_document);
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channel);
            content.setFolder(folder);
            Template oTemplate = Template.findById(_templateId);
            return this.m_oPublishServer.previewContent(content, _warningsHolder, oTemplate);
        }
        catch (WCMDatainvalidException e) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishService.class, "PublishService.label3", "\u9884\u89c8[") + _document + I18NMessage.get(PublishService.class, "PublishService.label11", "]\u5931\u8d25-\u6570\u636e\u6709\u8bef\uff1a") + e.getMyMessage(), e);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to preview the document!", ex);
        }
    }

    @Override
    public void publish(BaseChannel _siteOrChannel, int _nPublishType) throws WCMException {
        int nRightIndex;
        if (_siteOrChannel == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label1", "\u6307\u5b9a\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (_siteOrChannel.isSite()) {
            nRightIndex = _nPublishType == 2 ? 4 : 5;
        } else {
            int n = nRightIndex = _nPublishType == 2 ? 16 : 17;
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_siteOrChannel, nRightIndex)) {
            throw new WCMDatainvalidException(1002, I18NMessage.get(PublishService.class, "PublishService.label12", "\u60a8\u6ca1\u6709\u6743\u9650") + (_nPublishType == 2 ? I18NMessage.get(PublishService.class, "PublishService.label13", "\u5b8c\u5168") : I18NMessage.get(PublishService.class, "PublishService.label14", "\u5feb\u901f")) + I18NMessage.get(PublishService.class, "PublishService.label15", "\u53d1\u5e03") + this.getSiteOrChannelMsg(_siteOrChannel));
        }
        try {
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_siteOrChannel);
            this.m_oPublishServer.publishFolder(folder, _nPublishType);
        }
        catch (WCMDatainvalidException ex) {
            throw new WCMDatainvalidException(1100, I18NMessage.get(PublishService.class, "PublishService.label16", "\u53d1\u5e03[") + _siteOrChannel + I18NMessage.get(PublishService.class, "PublishService.label4", "]\u5931\u8d25\u2014\u2014\u6570\u636e\u6709\u8bef\uff1a\n") + ex.getMyMessage(), ex);
        }
        catch (WCMException ex) {
            throw new WCMDatainvalidException(1100, I18NMessage.get(PublishService.class, "PublishService.label16", "\u53d1\u5e03[") + _siteOrChannel + I18NMessage.get(PublishService.class, "PublishService.label17", "]\u8fd0\u884c\u4e2d\u51fa\u73b0\u5f02\u5e38\uff01"), ex);
        }
    }

    @Override
    public void delete(BaseChannel _siteOrChannel) throws WCMException {
        int nRightIndex;
        if (_siteOrChannel == null) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishService.class, "PublishService.label1", "\u6307\u5b9a\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        int n = nRightIndex = _siteOrChannel.isSite() ? 5 : 17;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_siteOrChannel, nRightIndex)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label18", "\u60a8\u6ca1\u6709\u6743\u9650\u53d1\u5e03") + this.getSiteOrChannelMsg(_siteOrChannel));
        }
        try {
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_siteOrChannel);
            this.m_oPublishServer.deleteFolder(folder);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to delete the " + (_siteOrChannel.isSite() ? "site" : "channel") + " publish pages!", ex);
        }
    }

    @Override
    public void publish(Document _document, int _nPubType) throws Exception {
        if (_document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        this.publish(_document, _document.getChannel(), _nPubType);
    }

    @Override
    public void publish(Document _document, Channel _channel, int _nPubType) throws Exception {
        if (_document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (_channel == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_document, 39)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label18", "\u60a8\u6ca1\u6709\u6743\u9650\u53d1\u5e03") + this.getSiteOrChannelMsg(_channel) + I18NMessage.get(PublishService.class, "PublishService.label20", "\u4e0a\u7684\u6587\u6863"));
        }
        try {
            IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(_document);
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channel);
            content.setFolder(folder);
            this.m_oPublishServer.publishContent(content, _nPubType);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(PublishService.class, "PublishService.label21", "\u53d1\u5e03\u6587\u6863\u5931\u8d25!"), ex);
        }
    }

    @Override
    public void publish(Documents _documents, int _nPubType) throws Exception {
        if (_documents == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label22", "\u6307\u5b9a\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        if (_documents.isEmpty()) {
            return;
        }
        Document aDoc = null;
        for (int i = 0; i < _documents.size(); ++i) {
            aDoc = (Document)_documents.getAt(i);
            if (aDoc == null) continue;
            this.publish(aDoc, _nPubType);
        }
    }

    @Override
    public void publish(Documents _documents, Channel _channel, int _nPubType) throws Exception {
        if (_nPubType == 7) {
            this.delete(_documents, _channel);
            return;
        }
        if (_documents == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label22", "\u6307\u5b9a\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        if (_channel == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (_documents.isEmpty()) {
            return;
        }
        try {
            IPublishElements contents = PublishElementFactory.makeElementsFrom(_documents);
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channel);
            this.m_oPublishServer.publishContents(contents, folder, _nPubType);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to publish the contents collection!", ex);
        }
    }

    @Override
    public void delete(Document _document) throws WCMException {
        if (_document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        this.delete(_document, _document.getChannel());
    }

    @Override
    public void delete(Document _document, Channel _channel) throws WCMException {
        if (_document == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (_channel == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_document, 33)) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label23", "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664") + this.getSiteOrChannelMsg(_channel) + I18NMessage.get(PublishService.class, "PublishService.label24", "\u4e0a\u5df2\u53d1\u5e03\u7684\u6587\u6863\u9875\u9762"));
        }
        try {
            IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(_document);
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channel);
            content.setFolder(folder);
            this.m_oPublishServer.deleteContent(content);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to delete the published content!", ex);
        }
    }

    @Override
    public void delete(Documents _documents) throws WCMException {
        if (_documents == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label22", "\u6307\u5b9a\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        if (_documents.isEmpty()) {
            return;
        }
        Document aDoc = null;
        for (int i = 0; i < _documents.size(); ++i) {
            aDoc = (Document)_documents.getAt(i);
            if (aDoc == null) continue;
            this.delete(aDoc);
        }
    }

    @Override
    public void delete(Documents _documents, Channel _channel) throws WCMException {
        if (_documents == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label22", "\u6307\u5b9a\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        if (_channel == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (_documents.isEmpty()) {
            return;
        }
        Channels linkedChannels = null;
        DocumentMgr documentMgr = null;
        documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        block5: for (int i = 0; i < _documents.size(); ++i) {
            ChnlDoc chnldoc;
            Document document = (Document)_documents.getAt(i);
            if (document == null || (chnldoc = ChnlDoc.findByDocAndChnl(document, _channel)) == null) continue;
            switch (chnldoc.getModal()) {
                case 1: {
                    Channels channels = documentMgr.getQutoedChannels(document, 2, null);
                    if (channels == null) continue block5;
                    if (linkedChannels == null) {
                        linkedChannels = channels;
                        continue block5;
                    }
                    linkedChannels.addElements(channels);
                    continue block5;
                }
            }
        }
        try {
            IPublishElements contents = PublishElementFactory.makeElementsFrom(_documents);
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channel);
            IPublishElements folders = PublishElementFactory.makeElementsFrom(linkedChannels);
            this.m_oPublishServer.deleteContents(contents, folder, folders);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to delete the published contents!", ex);
        }
    }

    @Override
    public PublishTasks getMyTasks(WCMFilter _filter) throws WCMException {
        return this.m_oPublishTaskMgr.getMyTasks(_filter);
    }

    @Override
    public PublishTasks getAllTasks(WCMFilter _filter) throws WCMException {
        return this.m_oPublishTaskMgr.getTasks(_filter);
    }

    @Override
    public void deleteTasks(String _sTaskIds) throws WCMException {
        PublishTasks tasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), _sTaskIds);
        for (int i = 0; i < tasks.size(); ++i) {
            PublishTask aTask = (PublishTask)tasks.getAt(i);
            if (aTask == null) continue;
            this.delete(aTask);
        }
    }

    private void delete(PublishTask _task) throws WCMException {
        if (_task == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label25", "\u6307\u5b9a\u53d1\u5e03\u4efb\u52a1\u4e3anull"));
        }
        User currUser = this.getLoginUser();
        if (!currUser.nameIs(_task.getCrUserName()) && !currUser.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label26", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u53d6\u6d88\u8be5\u53d1\u5e03\u4efb\u52a1\uff01"));
        }
        try {
            this.m_oPublishServer.deleteTask(_task);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to cancel the specified publish task!", ex);
        }
    }

    private void redo(PublishTask _task) throws WCMException {
        if (_task == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label25", "\u6307\u5b9a\u53d1\u5e03\u4efb\u52a1\u4e3anull"));
        }
        User currUser = this.getLoginUser();
        if (!currUser.nameIs(_task.getCrUserName()) && !currUser.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label27", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u91cd\u65b0\u6267\u884c\u8be5\u53d1\u5e03\u4efb\u52a1\uff01"));
        }
        try {
            this.m_oPublishServer.redoTask(_task);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to cancel the specified publish task!", ex);
        }
    }

    @Override
    public void redoTasks(String _sTaskIds) throws WCMException {
        PublishTasks tasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), _sTaskIds);
        for (int i = 0; i < tasks.size(); ++i) {
            PublishTask aTask = (PublishTask)tasks.getAt(i);
            if (aTask == null) continue;
            this.redo(aTask);
        }
    }

    @Override
    public void publish(ChnlDocs _chnlDocs, int _nPubType) throws Exception {
        if (_chnlDocs == null || _chnlDocs.isEmpty()) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishService.class, "PublishService.label28", "\u6307\u5b9a\u9891\u9053\u6587\u6863\u96c6\u5408\u4e3anull"));
        }
        ChnlDoc aChnlDoc = null;
        for (int i = 0; i < _chnlDocs.size(); ++i) {
            aChnlDoc = (ChnlDoc)_chnlDocs.getAt(i);
            if (aChnlDoc == null) continue;
            this.publish(aChnlDoc.getDocument(), aChnlDoc.getChannel(), _nPubType);
        }
    }

    private void assertTaskRight(PublishTask _task) throws WCMException {
        if (_task == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label25", "\u6307\u5b9a\u53d1\u5e03\u4efb\u52a1\u4e3anull"));
        }
        User currUser = this.getLoginUser();
        if (!currUser.nameIs(_task.getCrUserName()) && !currUser.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(PublishService.class, "PublishService.label26", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u53d6\u6d88\u8be5\u53d1\u5e03\u4efb\u52a1\uff01"));
        }
    }

    @Override
    public void cancelTasks(String _sTaskIds) throws WCMException {
        PublishTasks tasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), _sTaskIds);
        for (int i = 0; i < tasks.size(); ++i) {
            PublishTask aTask = (PublishTask)tasks.getAt(i);
            if (aTask == null) continue;
            this.assertTaskRight(aTask);
            this.m_oPublishServer.cancelTask(aTask);
        }
    }

    @Override
    public void pauseTask(String _sTaskIds) throws WCMException {
        PublishTasks tasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), _sTaskIds);
        for (int i = 0; i < tasks.size(); ++i) {
            PublishTask aTask = (PublishTask)tasks.getAt(i);
            if (aTask == null) continue;
            this.assertTaskRight(aTask);
            this.m_oPublishServer.pauseTask(aTask);
        }
    }

    @Override
    public void resumeTask(String _sTaskIds) throws WCMException {
        PublishTasks tasks = PublishTasks.findByIds(ContextHelper.getLoginUser(), _sTaskIds);
        for (int i = 0; i < tasks.size(); ++i) {
            PublishTask aTask = (PublishTask)tasks.getAt(i);
            if (aTask == null) continue;
            this.assertTaskRight(aTask);
            this.m_oPublishServer.resumeTask(aTask);
        }
    }

    @Override
    public PublishTaskRuntime getTaskRuntime(int iTaskID) {
        return this.m_oPublishServer.getTaskRuntime(iTaskID);
    }

    @Override
    public PublishTask getRunningTask(int iTaskID) {
        return this.m_oPublishServer.getRunningTask(iTaskID);
    }

    @Override
    public Iterator getRunningTasks() {
        return this.m_oPublishServer.getRunningTasks();
    }

    @Override
    public void publishForcibly(int _nDocumentId, String _sChannelIds) throws WCMException {
        User loginUser = this.getLoginUser();
        Document document = Document.findById(_nDocumentId);
        Channels channels = null;
        String sChannelIds = _sChannelIds;
        if (sChannelIds == null || (sChannelIds = sChannelIds.trim()).length() <= 0) {
            DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            channels = documentMgr.getChannels(document, 0, null);
        } else {
            int nDocChannelId;
            channels = Channels.findByIds(loginUser, _sChannelIds);
            if (channels.indexOf(nDocChannelId = document.getChannelId()) < 0) {
                channels.addElement(nDocChannelId);
            }
        }
        if (!loginUser.isAdministrator()) {
            int nRightIndex = 39;
            for (int i = channels.size() - 1; i >= 0; --i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null || AuthServer.hasRight(loginUser, (CMSObj)channel, nRightIndex)) continue;
                channels.removeAt(i, false);
            }
        }
        if (channels.isEmpty()) {
            return;
        }
        IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(document);
        content.setFolder(content.getOriginalHome());
        IPublishElements folders = PublishElementFactory.makeElementsFrom(channels);
        this.m_oPublishServer.publishContent(content, folders);
    }

    @Override
    public void publishConfirm(BaseChannel _oSiteOrChnl, String _sSourceFile, String _sTargetFile, String _sBackupFile) throws WCMException {
        boolean zHasRight;
        if (_oSiteOrChnl == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label19", "\u6307\u5b9a\u9891\u9053\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        if (_sSourceFile == null) {
            throw new WCMException(10, I18NMessage.get(PublishService.class, "PublishService.label29", "\u6307\u5b9a\u7684\u6e90\u6587\u4ef6\u4e3a\u7a7a\uff01"));
        }
        User oCurUser = this.getLoginUser();
        if (_oSiteOrChnl.isSite()) {
            zHasRight = AuthServer.hasRight(oCurUser, (CMSObj)_oSiteOrChnl, 4) || AuthServer.hasRight(oCurUser, (CMSObj)_oSiteOrChnl, 5);
        } else {
            boolean bl = zHasRight = AuthServer.hasRight(oCurUser, (CMSObj)_oSiteOrChnl, 16) || AuthServer.hasRight(oCurUser, (CMSObj)_oSiteOrChnl, 17);
        }
        if (!zHasRight) {
            throw new WCMDatainvalidException(1002, I18NMessage.get(PublishService.class, "PublishService.label30", "\u60a8\u6ca1\u6709\u6743\u9650\u786e\u8ba4\u53d1\u5e03\uff1a") + this.getSiteOrChannelMsg(_oSiteOrChnl));
        }
        try {
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_oSiteOrChnl);
            this.m_oPublishServer.publishConfirm(folder, _sSourceFile, _sTargetFile, _sBackupFile);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(PublishService.class, "PublishService.label31", "\u786e\u8ba4\u53d1\u5e03\u5931\u8d25!"), ex);
        }
    }

    public String preview(Document _document, Channel _channel, String[] holder, Template _template) throws WCMException {
        return null;
    }
}

