/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.util;

import com.trs.infra.common.WCMException;
import com.trs.scm.persistent.Account;
import com.trs.scm.sdk.model.Comment;
import com.trs.scm.sdk.model.CommentWrapper;
import com.trs.scm.sdk.util.CMyContentTranslate;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import java.text.SimpleDateFormat;
import java.util.List;
import org.dom4j.CDATA;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ComWrapConvertor
implements IXMLConvertor {
    @Override
    public String toXmlString(MethodContext _methodContext, Object _result) throws ConvertException {
        Element rootElement = null;
        try {
            CommentWrapper oMw = (CommentWrapper)_result;
            String sObjectsTagName = this.makeTagName(_result.getClass());
            rootElement = DocumentHelper.createElement((String)sObjectsTagName);
            if (oMw == null || oMw.getComments() == null || oMw.getComments().size() == 0) {
                return rootElement.asXML();
            }
            List<Comment> pComments = oMw.getComments();
            int nAccountId = _methodContext.getValue("AccountId", 0);
            if (nAccountId == 0) {
                return "\u672a\u4f20\u5165\u6b63\u786e\u7684\u8d26\u53f7\uff01";
            }
            Account oAccount = null;
            try {
                oAccount = Account.findById(nAccountId);
            }
            catch (WCMException e) {
                return "\u67e5\u8be2\u8d26\u53f7\u5931\u8d25\uff01";
            }
            String sPlat = oAccount.getPlatform();
            Element eCommentCount = rootElement.addElement("TotalNumber");
            Long oNum = Long.getLong("" + oMw.getTotalNumber());
            if (oNum != null) {
                eCommentCount.addText(Long.getLong("" + oMw.getTotalNumber()).toString());
            } else {
                eCommentCount.addText("0");
            }
            for (int i = 0; i < pComments.size(); ++i) {
                Comment tempComment = pComments.get(i);
                rootElement = ComWrapConvertor.parseComment(rootElement, tempComment, "comment", sPlat);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rootElement == null) {
            return null;
        }
        return rootElement.asXML();
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{CommentWrapper.class.getName()};
    }

    private String makeTagName(Class _objectClass) {
        String sObjectsTagName = _objectClass.getName();
        int nPos = sObjectsTagName.lastIndexOf(46);
        if (nPos >= 0) {
            sObjectsTagName = sObjectsTagName.substring(nPos + 1);
        }
        return sObjectsTagName;
    }

    public static Element parseComment(Element rootElement, Comment tempComment, String tagName, String _plat) {
        Element microContentElement = rootElement.addElement(tagName);
        Element eId = microContentElement.addElement("CmmentId");
        eId.setText(tempComment.getCommentId());
        Element eCon = microContentElement.addElement("CONTENT");
        CDATA oCdata = null;
        String sContent = "";
        try {
            sContent = CMyContentTranslate.microContentTranslate(tempComment.getContent(), _plat, true);
            oCdata = DocumentHelper.createCDATA((String)sContent);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        eCon.add(oCdata);
        Element eMicroUser = microContentElement.addElement("MicroUser");
        Element eUserName = eMicroUser.addElement("UserName");
        CDATA oUserNameData = DocumentHelper.createCDATA((String)tempComment.getUser().getName());
        eUserName.add(oUserNameData);
        Element eUserHeadPic = eMicroUser.addElement("UserHeadPic");
        CDATA oUserPicData = DocumentHelper.createCDATA((String)tempComment.getUser().getHead());
        eUserHeadPic.add(oUserPicData);
        Element eCreateDate = microContentElement.addElement("IsCreateDate");
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            eCreateDate.setText(df.format(tempComment.getCreateDate()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element eMc = microContentElement.addElement("ReplyMiconContent");
        if (tempComment.getReplyMicroContent() != null) {
            CDATA oMcCdata = DocumentHelper.createCDATA((String)tempComment.getReplyMicroContent().getContent());
            eMc.add(oMcCdata);
        }
        Element eRM = microContentElement.addElement("ReplyMiconContentId");
        if (tempComment.getReplyMicroContent() != null) {
            CDATA oMcCdata = DocumentHelper.createCDATA((String)tempComment.getReplyMicroContent().getId());
            eRM.add(oMcCdata);
        }
        Element eSource = microContentElement.addElement("Source");
        if (tempComment.getReplyMicroContent() != null) {
            CDATA oSourceCdata = DocumentHelper.createCDATA((String)tempComment.getReplyMicroContent().getSource());
            eSource.add(oSourceCdata);
        }
        Element eMicroCrUser = microContentElement.addElement("MicroCrUser");
        Element eUserCrName = eMicroCrUser.addElement("UserName");
        if (tempComment.getReplyMicroContent() != null && tempComment.getReplyMicroContent().getUser() != null) {
            CDATA oCrUserNameData = DocumentHelper.createCDATA((String)tempComment.getReplyMicroContent().getUser().getName());
            eUserCrName.add(oCrUserNameData);
        }
        return rootElement;
    }
}

