/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileWrapper;
import com.trs.scm.sdk.impl.AbstractMicroContentMgr;
import com.trs.scm.sdk.model.Count;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroContentWrapper;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.T163ErrorMessage;
import com.trs.scm.sdk.util.CMyContentTranslate;
import com.trs.scm.sdk.util.T163ObjectUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import t4j.TBlog;
import t4j.TBlogException;
import t4j.data.Paging;
import t4j.data.Status;
import t4j.data.User;

public class T163MicroContentMgr
extends AbstractMicroContentMgr {
    private static Logger logger = Logger.getLogger(T163MicroContentMgr.class);
    private final int HOME_TIMELINE = 1;
    private final int CURRUSER_TIME_LINE = 2;
    private final int METIONS_TIMELINE = 3;
    private static Map<String, MicroContentWrapper> m_OAuthMicroContentMap = null;
    private static Map<String, CMyDateTime> m_oLastRefreshDate = null;
    private final String SINCE_ID = "Since_Id";
    private final String MAX_ID = "Max_Id";
    private String m_sRequestDataType = "";
    private OAuth m_oT163OAuth;
    private TBlog tBlog;

    public T163MicroContentMgr(OAuth auth) {
        super(auth);
        this.m_oT163OAuth = auth;
        this.tBlog = new TBlog();
        this.tBlog.setToken(auth.getOAuth_token(), auth.getOAuth_token_secret());
    }

    @Override
    public MicroContent createMicroContent(String content, ExtraParams extraParams) throws Exception {
        content = CMyContentTranslate.t163TranslateFaceText(content);
        String sTempContent = CMyContentTranslate.microContentUrlShortLength(content);
        this.checkContentLength(sTempContent);
        Status status = null;
        try {
            status = this.tBlog.updateStatus(content);
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroContent result = null;
        try {
            result = T163ObjectUtil.constructMicroContent(status, null);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01");
            throw new Exception("\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01", _oException);
        }
        this.resetRefreshTime();
        return result;
    }

    @Override
    public MicroContent createMicroContent(String content, String picPath, ExtraParams extraParams) throws Exception {
        content = CMyContentTranslate.t163TranslateFaceText(content);
        String sTempContent = CMyContentTranslate.microContentUrlShortLength(content);
        this.checkContentLength(sTempContent);
        this.isPicLegal(picPath);
        Status status = null;
        try {
            status = this.tBlog.updateImage(content, (File)new FileWrapper(new FileService(picPath)));
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroContent result = null;
        try {
            result = T163ObjectUtil.constructMicroContent(status, null);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01");
            throw new Exception("\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01", _oException);
        }
        this.resetRefreshTime();
        return result;
    }

    @Override
    public boolean destroyMicroContent(String id) throws Exception {
        if (id == null || id.trim().length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        boolean bool = false;
        Status status = null;
        try {
            status = this.tBlog.destroy(Long.parseLong(id.trim()));
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        if (status != null) {
            bool = true;
        }
        this.resetRefreshTime();
        return bool;
    }

    @Override
    public MicroContent findById(String id) throws Exception {
        if (id == null || id.trim().length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        Status status = null;
        try {
            status = this.tBlog.showStatus(Long.parseLong(id.trim()));
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroContent result = null;
        try {
            result = T163ObjectUtil.constructMicroContent(status, this.tBlog);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01");
            throw new Exception("\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01", _oException);
        }
        return result;
    }

    @Override
    public Map<String, Count> getCount(String ids) throws Exception {
        int nIDListLen = ids.split(",").length;
        if (ids == null || ids.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535aID\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        if (nIDListLen > 50) {
            throw new ArrayIndexOutOfBoundsException("\u8f93\u5165\u7684\u5fae\u535aID\u5217\u8868\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\uff01");
        }
        String[] idss = ids.split(",");
        HashMap<String, Count> oResultsMap = new HashMap<String, Count>();
        Count oMicroCount = null;
        for (String id : idss) {
            Status status = null;
            if (CMyString.isEmpty(id)) continue;
            try {
                status = this.tBlog.showStatus(Long.parseLong(id));
            }
            catch (NumberFormatException e) {
                logger.error((Object)("\u83b7\u53d6\u7f51\u6613\u5fae\u535a\u65f6\u629b\u9519\uff01\u7f51\u6613\u5fae\u535aID\u4e0d\u5408\u6cd5\uff01\u5fae\u535aID\uff1a[" + id + "]"), (Throwable)e);
                continue;
            }
            catch (TBlogException e) {
                CMyException oCMyException = T163ErrorMessage.getCMyException((Exception)((Object)e));
                logger.error((Object)oCMyException.getMyMessage());
                continue;
            }
            if (status == null) continue;
            try {
                oMicroCount = new Count(String.valueOf(status.getId()), status.getCommentsCount(), status.getRetweetCount());
            }
            catch (Exception e) {
                logger.error((Object)("\u6784\u9020MicroCount\u5bf9\u8c61\u65f6\u51fa\u9519\uff01\u5fae\u535aID:[" + id + "]"), (Throwable)e);
                continue;
            }
            oResultsMap.put(id, oMicroCount);
        }
        return oResultsMap;
    }

    @Override
    public MicroContentWrapper getHomeTimeline(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        if (pageSize < 1 || pageSize > 70) {
            throw new Exception("\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u57281-70\u4e4b\u95f4");
        }
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        int nMicroContentType = 1;
        int nType = 0;
        return this.getMicroContentsByType(nMicroContentType, nType, pageIndex, pageSize, extraParams);
    }

    @Override
    public MicroContentWrapper getMentions(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        if (pageSize < 1 || pageSize > 70) {
            throw new Exception("\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u57281-70\u4e4b\u95f4");
        }
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        int nMicroContentType = 3;
        int nType = 0;
        return this.getMicroContentsByType(nMicroContentType, nType, pageIndex, pageSize, extraParams);
    }

    @Override
    public MicroContentWrapper getUserTimeline(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        if (pageSize < 1 || pageSize > 70) {
            throw new Exception("\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u57281-70\u4e4b\u95f4");
        }
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        int nMicroContentType = 2;
        int nType = 0;
        return this.getMicroContentsByType(nMicroContentType, nType, pageIndex, pageSize, extraParams);
    }

    @Override
    public MicroContentWrapper getUserTimelineByType(int type, int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        if (pageSize < 1 || pageSize > 70) {
            throw new Exception("\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u57281-70\u4e4b\u95f4");
        }
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        int nMicroContentType = 2;
        int nType = type;
        if (nType < 0 || nType > 7) {
            nType = 0;
        }
        return this.getMicroContentsByType(nMicroContentType, nType, pageIndex, pageSize, extraParams);
    }

    @Override
    public MicroContent repostMicroContent(String content, String id, ExtraParams extraParams) throws Exception {
        String sTempContent = CMyContentTranslate.microContentUrlShortLength(content = CMyContentTranslate.t163TranslateFaceText(content));
        if (CMyString.isEmpty(sTempContent)) {
            content = "";
        }
        if (sTempContent.length() > 280) {
            throw new WCMException("\u8f6c\u53d1\u8f93\u5165\u7684\u5185\u5bb9\u5927\u4e8e140\u4e2a\u5b57\uff01");
        }
        if (id == null || id.length() < 1) {
            throw new WCMException("\u8f93\u5165\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        Status status = null;
        try {
            status = this.tBlog.retweet(Long.parseLong(id), content);
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroContent oResult = null;
        try {
            oResult = T163ObjectUtil.constructMicroContent(status, this.tBlog);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01");
            throw new Exception("\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01", _oException);
        }
        this.resetRefreshTime();
        return oResult;
    }

    private MicroContentWrapper getMicroContentsByType(int nMicroContentType, int _nType, int _nPageIndex, int _nPageSize, ExtraParams extraParams) throws Exception {
        boolean bRefreshed = this.refreshIfNeed(nMicroContentType, _nType, _nPageIndex, _nPageSize, extraParams);
        this.m_sRequestDataType = "";
        String sAccessToken = this.m_oT163OAuth.getOAuth_token();
        String sKey = this.makeKey(nMicroContentType, sAccessToken);
        MicroContentWrapper oMicroContentWrapper = m_OAuthMicroContentMap.get(sKey);
        if (bRefreshed) {
            return this.constructResult(_nPageIndex, _nPageSize, oMicroContentWrapper);
        }
        if (oMicroContentWrapper == null || oMicroContentWrapper.getMicroContents().size() == 0) {
            return null;
        }
        List<MicroContent> microContents = oMicroContentWrapper.getMicroContents();
        int nToIndex = _nPageIndex * _nPageSize;
        int nListSize = microContents.size();
        if (nListSize > nToIndex) {
            return this.constructResult(_nPageIndex, _nPageSize, oMicroContentWrapper);
        }
        this.m_sRequestDataType = "Max_Id";
        oMicroContentWrapper = this.loadMicroContents(oMicroContentWrapper, nMicroContentType, _nType, _nPageIndex, _nPageSize, extraParams);
        this.m_sRequestDataType = "";
        return this.constructResult(_nPageIndex, _nPageSize, oMicroContentWrapper);
    }

    private boolean refreshIfNeed(int _nMicroContentType, int _nType, int _nPageIndex, int _nPageSize, ExtraParams _extraParams) throws Exception {
        boolean bIsOutdated;
        String sAccessToken = this.m_oT163OAuth.getOAuth_token();
        String sKey = this.makeKey(_nMicroContentType, sAccessToken);
        boolean bIsSatisfied = false;
        MicroContentWrapper oMicroContentWrapper = null;
        if (m_OAuthMicroContentMap != null) {
            oMicroContentWrapper = m_OAuthMicroContentMap.get(sKey);
        }
        if (oMicroContentWrapper != null) {
            boolean bl = bIsSatisfied = oMicroContentWrapper.getMicroContents().size() >= _nPageIndex * _nPageSize;
            if (!bIsSatisfied) {
                this.m_sRequestDataType = "Since_Id";
            }
        }
        if (!(bIsOutdated = this.needReresh(_nMicroContentType)) && bIsSatisfied) {
            return false;
        }
        oMicroContentWrapper = !bIsOutdated && !bIsSatisfied && oMicroContentWrapper != null ? this.loadMicroContents(oMicroContentWrapper, _nMicroContentType, _nType, _nPageIndex, _nPageSize, _extraParams) : this.loadMicroContents(null, _nMicroContentType, _nType, _nPageIndex, _nPageSize, _extraParams);
        logger.debug((Object)"\u66f4\u65b0\u7f13\u5b58\u6570\u636e\uff01");
        if (m_OAuthMicroContentMap == null) {
            m_OAuthMicroContentMap = new HashMap<String, MicroContentWrapper>();
        }
        if (m_oLastRefreshDate == null) {
            m_oLastRefreshDate = new HashMap<String, CMyDateTime>();
        }
        m_OAuthMicroContentMap.put(sKey, oMicroContentWrapper);
        m_oLastRefreshDate.put(sKey, CMyDateTime.now());
        return true;
    }

    private boolean needReresh(int _nMicroContentType) {
        String sKey = this.makeKey(_nMicroContentType, this.m_oT163OAuth.getOAuth_token());
        if (m_oLastRefreshDate == null) {
            this.m_sRequestDataType = "Max_Id";
            return true;
        }
        CMyDateTime oLastRefreshTime = m_oLastRefreshDate.get(sKey);
        if (oLastRefreshTime == null) {
            this.m_sRequestDataType = "Max_Id";
            return true;
        }
        CMyDateTime now = CMyDateTime.now();
        if (now.getTimeInMillis() - oLastRefreshTime.getTimeInMillis() > 120000L) {
            this.m_sRequestDataType = "Max_Id";
            return true;
        }
        return false;
    }

    private MicroContentWrapper loadMicroContents(MicroContentWrapper _oMicroContentWrapper, int _nMicroContentType, int _nType, int _nPageIndex, int _nPageSize, ExtraParams _extraParams) throws Exception {
        if (_nPageSize < 1 || _nPageSize > 70) {
            throw new Exception("\u8f93\u5165\u7684\u9875\u9762\u5927\u5c0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u9875\u9762\u5927\u5c0f\u8303\u56f4\u4e3a\uff1a1-70\u3002");
        }
        if (_nPageIndex < 1) {
            _nPageIndex = 1;
        }
        MicroContentWrapper oAllCachedWrapper = _oMicroContentWrapper;
        MicroContentWrapper oNewestWrapper = null;
        Paging page = null;
        int nRequestNumber = 0;
        if (oAllCachedWrapper == null) {
            this.m_sRequestDataType = "Max_Id";
            nRequestNumber = _nPageSize;
            page = T163ObjectUtil.constructPaging(nRequestNumber + 1, null);
            oNewestWrapper = this.loadMicroContentsByType(_nMicroContentType, _nType, page);
            if (oNewestWrapper != null && oNewestWrapper.getTotalNumber() >= (long)nRequestNumber) {
                oNewestWrapper.setTotalNumber(100L);
            }
            this.m_sRequestDataType = "";
            return oNewestWrapper;
        }
        if (this.m_sRequestDataType.equals("Max_Id")) {
            _extraParams.setParam("Since_Id", "");
            _extraParams.setParam("Max_Id", oAllCachedWrapper.getExtraAttribute("Max_Id"));
            page = T163ObjectUtil.constructPaging(200, _extraParams);
            oNewestWrapper = this.loadMicroContentsByType(_nMicroContentType, _nType, page);
            if (oNewestWrapper == null || oNewestWrapper.getMicroContents().size() <= 1 && oAllCachedWrapper != null) {
                return oAllCachedWrapper;
            }
            int nSize = (int)(oNewestWrapper = this.mergeWrapper(oNewestWrapper, oAllCachedWrapper)).getTotalNumber();
            if (nSize > 100 || nSize < _nPageSize) {
                oNewestWrapper.setTotalNumber(nSize);
            } else {
                oNewestWrapper.setTotalNumber(100L);
            }
            oNewestWrapper.setExtraAttribute("Since_Id", oAllCachedWrapper.getExtraAttribute("Since_Id"));
            this.m_sRequestDataType = "";
            return oNewestWrapper;
        }
        if (this.m_sRequestDataType.equals("Since_Id")) {
            int nToIndex = _nPageIndex * _nPageSize;
            int nListSize = oAllCachedWrapper.getMicroContents().size();
            nRequestNumber = nToIndex - nListSize;
            _extraParams.setParam("Since_Id", oAllCachedWrapper.getExtraAttribute("Since_Id"));
            _extraParams.setParam("Max_Id", "");
            page = T163ObjectUtil.constructPaging(nRequestNumber + 1, _extraParams);
            oNewestWrapper = this.loadMicroContentsByType(_nMicroContentType, _nType, page);
            if (oNewestWrapper == null || oNewestWrapper.getTotalNumber() == 0L) {
                return oAllCachedWrapper;
            }
            oAllCachedWrapper = this.mergeWrapper(oAllCachedWrapper, oNewestWrapper);
            oAllCachedWrapper.setExtraAttribute("Since_Id", oNewestWrapper.getExtraAttribute("Since_Id"));
            int nSize = oAllCachedWrapper.getMicroContents().size();
            if (nSize > 100 || nSize < nToIndex) {
                oAllCachedWrapper.setTotalNumber(nSize);
            } else {
                oAllCachedWrapper.setTotalNumber(100L);
            }
            this.m_sRequestDataType = "";
            return oAllCachedWrapper;
        }
        logger.debug((Object)"\u52a0\u8f7d\u5fae\u535a\u7684\u8bbe\u5b9a\u903b\u8f91\u672a\u6267\u884c\uff01\u8bf7\u91cd\u65b0\u68c0\u67e5\u903b\u8f91\uff01");
        nRequestNumber = _nPageSize;
        page = T163ObjectUtil.constructPaging(nRequestNumber + 1, _extraParams);
        oNewestWrapper = this.loadMicroContentsByType(_nMicroContentType, _nType, page);
        return oNewestWrapper;
    }

    private MicroContentWrapper loadMicroContentsByType(int _nMicroContentType, int _nType, Paging _oPage) throws Exception {
        List list = null;
        try {
            switch (_nMicroContentType) {
                case 1: {
                    list = this.tBlog.getHomeTimeline(_oPage);
                    break;
                }
                case 3: {
                    list = this.tBlog.getMentions(_oPage);
                    break;
                }
                case 2: {
                    User user = this.tBlog.verifyCredentials();
                    list = this.tBlog.getUserTimeline(user.getId(), _nType, _oPage);
                    break;
                }
            }
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroContentWrapper result = null;
        try {
            result = T163ObjectUtil.constructMicroContentWrapper(list, this.tBlog);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u6784\u9020MicroContentWrapper\u629b\u51fa\u5f02\u5e38\uff01");
            throw new Exception("\u6784\u9020MicroContentWrapper\u629b\u51fa\u5f02\u5e38\uff01", _oException);
        }
        return result;
    }

    private MicroContentWrapper mergeWrapper(MicroContentWrapper _oHeadWrapper, MicroContentWrapper _oTailWrapper) {
        if (_oHeadWrapper == null || _oHeadWrapper.getMicroContents().size() == 0) {
            return _oTailWrapper;
        }
        String sSince_Id = (String)_oHeadWrapper.getExtraAttribute("Since_Id");
        long lTailCursor = Long.valueOf(sSince_Id.split(":")[1]);
        List<MicroContent> oHeadMicroContetns = _oHeadWrapper.getMicroContents();
        List<MicroContent> oTailMicroContetns = null;
        if (_oTailWrapper != null) {
            oTailMicroContetns = _oTailWrapper.getMicroContents();
        }
        if (oTailMicroContetns != null) {
            MicroContent oTempMicroContent = null;
            String sCurrCursor = "";
            long lCurrCursor = 0L;
            for (int i = 0; i < oTailMicroContetns.size(); ++i) {
                oTempMicroContent = oTailMicroContetns.get(i);
                sCurrCursor = oTempMicroContent.getExtraAttributeAsString("Cursor_Id").split(":")[1];
                lCurrCursor = Long.valueOf(sCurrCursor);
                if (lCurrCursor >= lTailCursor) continue;
                oHeadMicroContetns.add(oTempMicroContent);
            }
        }
        _oHeadWrapper.setMicroContents(oHeadMicroContetns);
        return _oHeadWrapper;
    }

    private String makeKey(int _nMicroContentType, String _sAccessToken) {
        return _nMicroContentType + "_" + _sAccessToken;
    }

    private MicroContentWrapper constructResult(int _nPageIndex, int _nPageSize, MicroContentWrapper _oMicroContentWrapper) {
        if (_oMicroContentWrapper == null) {
            return null;
        }
        List<MicroContent> oMicroContents = _oMicroContentWrapper.getMicroContents();
        int nNum = oMicroContents.size();
        if (oMicroContents == null || nNum == 0) {
            return null;
        }
        int nFromIndex = _nPageIndex * _nPageSize - _nPageSize;
        int nToIndex = _nPageIndex * _nPageSize;
        if (nNum <= nFromIndex) {
            nToIndex = nNum;
            nFromIndex = nNum / _nPageSize * _nPageSize;
            _oMicroContentWrapper.setTotalNumber(nNum);
        }
        if (nNum < nToIndex) {
            nToIndex = nNum;
            _oMicroContentWrapper.setTotalNumber(nNum);
        }
        ArrayList<MicroContent> oAllMicroContents = new ArrayList<MicroContent>();
        oAllMicroContents.addAll(oMicroContents);
        List<MicroContent> oResultMCs = oAllMicroContents.subList(nFromIndex, nToIndex);
        MicroContentWrapper oResultMCWrapper = new MicroContentWrapper(oResultMCs, _oMicroContentWrapper.getTotalNumber());
        return oResultMCWrapper;
    }

    private void resetRefreshTime() throws CMyException {
        String sAccessToken = this.m_oT163OAuth.getOAuth_token();
        CMyDateTime oLastRefreshedTime = null;
        oLastRefreshedTime = CMyDateTime.now().dateAdd(5, -2);
        if (m_oLastRefreshDate == null || m_OAuthMicroContentMap == null) {
            return;
        }
        String sKey1 = this.makeKey(2, sAccessToken);
        String sKey2 = this.makeKey(1, sAccessToken);
        String sKey3 = this.makeKey(3, sAccessToken);
        m_oLastRefreshDate.put(sKey1, oLastRefreshedTime);
        m_OAuthMicroContentMap.put(sKey1, null);
        m_oLastRefreshDate.put(sKey2, oLastRefreshedTime);
        m_OAuthMicroContentMap.put(sKey2, null);
        m_oLastRefreshDate.put(sKey3, oLastRefreshedTime);
        m_OAuthMicroContentMap.put(sKey3, null);
    }
}

