/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.scm.sdk.IMicroContentMgr;
import com.trs.scm.sdk.model.OAuth;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class AbstractMicroContentMgr
implements IMicroContentMgr {
    protected OAuth m_oOAuth;

    public AbstractMicroContentMgr(OAuth _oOAuth) {
        if (_oOAuth == null) {
            throw new NullPointerException("OAuth\u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        this.m_oOAuth = _oOAuth;
    }

    protected boolean checkContentLength(String content) throws Exception {
        if (content == null || content.length() < 1) {
            throw new NullPointerException("\u53d1\u5e03\u5fae\u535a\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        if (content.length() > 280) {
            throw new Exception("\u53d1\u5e03\u5fae\u535a\u5185\u5bb9\u957f\u5ea6\u8d85\u8fc7140\u4e2a\u5b57\uff01");
        }
        return true;
    }

    protected boolean isPicLegal(String picPath) throws Exception {
        if (!CMyFile.fileExists(picPath)) {
            throw new FileNotFoundException("\u8f93\u5165\u7684\u56fe\u7247\u6587\u4ef6\u7269\u7406\u5730\u5740\u4e0d\u5b58\u5728\uff01\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u56fe\u7247\u5730\u5740\u662f\u5426\u6b63\u786e\uff01");
        }
        FileService oPicFile = new FileService(picPath);
        if (!oPicFile.canRead()) {
            throw new IOException("\u8f93\u5165\u7684\u56fe\u7247\u6587\u4ef6\u4e0d\u80fd\u8bfb\u53d6\uff01\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u56fe\u7247\u5730\u5740\u662f\u5426\u6b63\u786e\uff01");
        }
        String sFileType = CMyFile.extractFileExt(picPath);
        if (!(sFileType.equalsIgnoreCase("GIF") || sFileType.equalsIgnoreCase("PNG") || sFileType.equalsIgnoreCase("JPG") || sFileType.equalsIgnoreCase("JPEG"))) {
            throw new Exception("\u56fe\u7247\u6587\u4ef6\u4ec5\u652f\u6301jpg\u3001gif\u3001png\u683c\u5f0f\uff01\u8bf7\u68c0\u67e5\u4e0a\u4f20\u56fe\u7247\u7c7b\u578b\uff01");
        }
        long lFileSize = oPicFile.length();
        if (lFileSize / 1024L < 1L || lFileSize / 1024L > 4096L) {
            throw new Exception("\u56fe\u7247\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u8303\u56f4\uff01\u56fe\u7247\u5927\u5c0f\u5fc5\u987b\u57281k ~ 4M\u4e4b\u95f4\uff01");
        }
        return true;
    }
}

