/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.util.html.HtmlDocument;
import com.trs.infra.util.html.HtmlElement;

public class HtmlComment
implements Cloneable {
    public static final String TAG_START = "<!--";
    public static final String TAG_END = "-->";
    protected String text;
    protected Object parent = null;

    protected HtmlComment() {
    }

    public HtmlComment(String _text) {
        this.setText(_text);
    }

    public HtmlDocument getDocument() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof HtmlDocument) {
            return (HtmlDocument)this.parent;
        }
        if (this.parent instanceof HtmlElement) {
            return ((HtmlElement)this.parent).getDocument();
        }
        return null;
    }

    public HtmlComment setDocument(HtmlDocument _document) {
        this.parent = _document;
        return this;
    }

    public HtmlElement getParent() {
        if (this.parent instanceof HtmlElement) {
            return (HtmlElement)this.parent;
        }
        return null;
    }

    public HtmlComment setParent(HtmlElement _parent) {
        this.parent = _parent;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public HtmlComment setText(String _text) {
        this.text = _text;
        return this;
    }

    public boolean isRootComment() {
        return this.parent instanceof HtmlDocument;
    }

    public Object clone() {
        HtmlComment comment = new HtmlComment(this.text);
        comment.setParent(null);
        return comment;
    }

    public String toString() {
        return new StringBuffer().append(TAG_START).append(this.text).append(TAG_END).toString();
    }

    public boolean fromString(String _strSrc) {
        if (!(_strSrc = _strSrc.trim()).startsWith(TAG_START) || !_strSrc.endsWith(TAG_END)) {
            return false;
        }
        this.text = _strSrc.substring(4, _strSrc.length() - 3);
        return true;
    }

    public static void main(String[] args) {
        String strSrc = " <!-- this is a comment -->  ";
        HtmlComment comment = new HtmlComment();
        comment.fromString(strSrc);
        System.out.println(comment.toString());
    }
}

