/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileWrapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class ContentLinkReplacer {
    public static int KEY_LEN_LIMIT;
    private Hashtable hLinkMap = null;
    private Hashtable hTitleMap = null;
    private boolean[] haveKeysStartWith = new boolean[65535];
    private boolean[] haveKeysWithLen = new boolean[KEY_LEN_LIMIT + 1];
    private int nMaxKeyLen = 0;
    private static String[] TAGS_TOSKIP_ARRAY;
    private static Hashtable TAGS_TOSKIP;
    private static String[] TAGS_SINGLE_SKIP_ARRAY;
    private static Hashtable TAGS_SINGLE_SKIP;

    public ContentLinkReplacer() {
        int i;
        this.hLinkMap = new Hashtable();
        this.hTitleMap = new Hashtable();
        for (i = 0; i < this.haveKeysStartWith.length; ++i) {
            this.haveKeysStartWith[i] = false;
        }
        for (i = 0; i < this.haveKeysWithLen.length; ++i) {
            this.haveKeysWithLen[i] = false;
        }
    }

    public static final String[] getTagsToSkip() {
        return TAGS_TOSKIP_ARRAY;
    }

    public void clear() {
        this.hLinkMap.clear();
        this.hTitleMap.clear();
    }

    public boolean putLinkMap(String _sKey, String _sLink) {
        return this.putLinkMap(_sKey, _sLink, "");
    }

    public boolean putLinkMap(String _sKey, String _sLink, String _sTitle) {
        int index;
        if (_sKey == null || _sLink == null) {
            return false;
        }
        int nLen = (_sKey = CMyString.transDisplay(_sKey.trim(), true)).length();
        if (nLen == 0) {
            return false;
        }
        if ((_sLink = _sLink.trim()).length() == 0) {
            return false;
        }
        this.hLinkMap.put(_sKey, _sLink);
        this.hTitleMap.put(_sKey, _sTitle);
        int n = index = nLen > KEY_LEN_LIMIT ? 0 : nLen;
        if (!this.haveKeysWithLen[index]) {
            this.haveKeysWithLen[index] = true;
        }
        if (nLen > this.nMaxKeyLen) {
            this.nMaxKeyLen = nLen;
        }
        if (!this.haveKeysStartWith[index = (int)_sKey.charAt(0)]) {
            this.haveKeysStartWith[index] = true;
        }
        return true;
    }

    public String removeLinkMap(String _sKey) {
        if (_sKey == null) {
            return null;
        }
        this.hTitleMap.remove(_sKey);
        return (String)this.hLinkMap.remove(_sKey);
    }

    public String getMappedLink(String _sKey) {
        if (_sKey == null) {
            return null;
        }
        return (String)this.hLinkMap.get(_sKey);
    }

    public String replaceLink(String _srcContent) throws CMyException {
        return this.replaceLink(_srcContent, null);
    }

    public String replaceLink(String _srcContent, String _extraLinkAttributes) throws CMyException {
        boolean FLAG_NORM = false;
        boolean FLAG_WAIT_TAG_GT = true;
        int FLAG_WAIT_SKIPTAG_STARTGT = 2;
        int FLAG_WAIT_SKIPTAG_ENDTAG = 3;
        if (_srcContent == null) {
            return null;
        }
        if (this.hLinkMap.size() <= 0) {
            return _srcContent;
        }
        char[] srcBuff = _srcContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return "";
        }
        StringBuffer retBuff = null;
        int nextPos = 0;
        int currFlag = 0;
        char[] sQuoteStack = new char[20];
        int nQuoteDeep = -1;
        boolean bToSkip = false;
        try {
            retBuff = new StringBuffer((int)((double)nLen * 1.5));
            String currSkipName = "";
            while (nextPos < nLen) {
                char currChar;
                if ((currChar = srcBuff[nextPos++]) == '\n' || currChar == '\r') {
                    retBuff.append(currChar);
                    continue;
                }
                if (nQuoteDeep >= 0) {
                    if (currChar == sQuoteStack[nQuoteDeep] && srcBuff[nextPos - 1] != '\\') {
                        --nQuoteDeep;
                    }
                    retBuff.append(currChar);
                    continue;
                }
                bToSkip = false;
                switch (currChar) {
                    case '\"': 
                    case '\'': {
                        if (currFlag != 1 && currFlag != 2) break;
                        sQuoteStack[++nQuoteDeep] = currChar;
                        retBuff.append(currChar);
                        bToSkip = true;
                        break;
                    }
                    case '<': {
                        String sTagName = "";
                        retBuff.append('<');
                        bToSkip = true;
                        if (nextPos >= nLen) break;
                        if ((currChar = srcBuff[nextPos++]) == '/') {
                            retBuff.append('/');
                            if (currFlag != 3 || nextPos >= nLen) break;
                            currChar = srcBuff[nextPos++];
                        } else {
                            if (currFlag != 0 && currChar != '!') {
                                retBuff.append(currChar);
                                break;
                            }
                            if (currChar == '!') {
                                retBuff.append(currChar);
                                currChar = srcBuff[nextPos++];
                                retBuff.append(currChar);
                                currChar = srcBuff[nextPos++];
                                retBuff.append(currChar);
                                boolean bEnd = false;
                                while (!bEnd && nextPos < nLen) {
                                    currChar = srcBuff[nextPos++];
                                    retBuff.append(currChar);
                                    if (currChar != '-') continue;
                                    char currChar1 = srcBuff[nextPos];
                                    char currChar2 = srcBuff[nextPos + 1];
                                    if (currChar1 != '-' || currChar2 != '>') continue;
                                    retBuff.append(currChar1);
                                    retBuff.append(currChar2);
                                    bEnd = true;
                                    nextPos += 2;
                                }
                                break;
                            }
                        }
                        while (Character.isWhitespace(currChar)) {
                            retBuff.append(currChar);
                            if (nextPos >= nLen) break;
                            currChar = srcBuff[nextPos++];
                        }
                        while (!Character.isWhitespace(currChar) && currChar != '>') {
                            sTagName = sTagName + currChar;
                            if (nextPos >= nLen) break;
                            currChar = srcBuff[nextPos++];
                        }
                        retBuff.append(sTagName);
                        if (nextPos < nLen) {
                            retBuff.append(currChar);
                        }
                        if (TAGS_TOSKIP.get(sTagName.toUpperCase()) != null) {
                            if (currFlag == 0) {
                                currSkipName = sTagName;
                                currFlag = 2;
                                break;
                            }
                            currFlag = currChar == '>' ? 0 : 1;
                            break;
                        }
                        if (currChar == '>') break;
                        currFlag = 1;
                        break;
                    }
                    case '>': {
                        retBuff.append('>');
                        bToSkip = true;
                        if (currFlag == 1) {
                            currFlag = 0;
                            break;
                        }
                        if (currFlag != 2) break;
                        if (TAGS_SINGLE_SKIP.get(currSkipName.toUpperCase()) != null) {
                            currFlag = 0;
                            break;
                        }
                        currFlag = 3;
                        break;
                    }
                    default: {
                        if (currFlag == 0) break;
                        retBuff.append(currChar);
                        bToSkip = true;
                    }
                }
                if (bToSkip) continue;
                if (!this.haveKeysStartWith[currChar]) {
                    retBuff.append(currChar);
                    continue;
                }
                String sMatch = String.valueOf(currChar);
                boolean bFound = false;
                int nAt = nextPos;
                for (int nKeyLen = 1; nKeyLen <= this.nMaxKeyLen; ++nKeyLen) {
                    char nextChar;
                    if (this.haveKeysWithLen[nKeyLen]) {
                        String sLink = (String)this.hLinkMap.get(sMatch);
                        String sTitle = (String)this.hTitleMap.get(sMatch);
                        if (sLink != null) {
                            retBuff.append("<a href=\"").append(sLink);
                            retBuff.append("\" title=\"").append(CMyString.filterForHTMLValue(sTitle) + "\" ");
                            if (_extraLinkAttributes != null) {
                                retBuff.append(' ').append(_extraLinkAttributes);
                            }
                            retBuff.append('>').append(sMatch).append("</a>");
                            nextPos = nAt;
                            bFound = true;
                            break;
                        }
                    }
                    if (nAt >= nLen || (nextChar = srcBuff[nAt++]) == '\n' || nextChar == '\r') break;
                    sMatch = sMatch + nextChar;
                }
                if (bFound) continue;
                retBuff.append(currChar);
            }
            return retBuff.toString();
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace(System.out);
            return _srcContent;
        }
        catch (Exception ex) {
            throw new CMyException(1, I18NMessage.get(ContentLinkReplacer.class, "ContentLinkReplacer.label1", "\u66ff\u6362\u94fe\u63a5\u5931\u8d25\uff08DocInnerLinkReplacer.replaceLink\uff09"), ex);
        }
    }

    public boolean loadLinkMap(String _linkMapFile) throws CMyException {
        FileService file = null;
        InputStreamReader fileReader = null;
        Hashtable hLinkMap = new Hashtable();
        try {
            String sLine;
            file = new FileService(_linkMapFile);
            fileReader = new FileReader(new FileWrapper(file));
            BufferedReader buffReader = new BufferedReader(fileReader);
            while ((sLine = buffReader.readLine()) != null) {
                int nPos = sLine.indexOf(61);
                if (nPos < 0) continue;
                this.putLinkMap(sLine.substring(0, nPos), sLine.substring(nPos + 1));
            }
            buffReader.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new CMyException(1, I18NMessage.get(ContentLinkReplacer.class, "ContentLinkReplacer.label2", "\u88c5\u8f7d\u94fe\u63a5\u6620\u5c04\u8868\u5931\u8d25(ContentLinkReplacer.loadLinkMap)"), ex);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private int readAttributes(char[] _srcBuffer, StringBuffer _retBuffer, int _nStart) {
        int nPos = _nStart;
        int nLen = _srcBuffer.length;
        Object conBuffer = null;
        int chrQuote = 32;
        boolean bCanEnd = true;
        block0: while (nPos < nLen) {
            while (nPos < nLen && Character.isWhitespace(_srcBuffer[nPos])) {
                _retBuffer.append(' ');
                ++nPos;
            }
            if (nPos >= nLen || _srcBuffer[nPos] == '>' && bCanEnd) break;
            while (nPos < nLen) {
                int aChar = _srcBuffer[nPos];
                if ((aChar == 34 || aChar == 39) && _srcBuffer[nPos - 1] != '\\') {
                    if (chrQuote == 32) {
                        chrQuote = aChar;
                        bCanEnd = false;
                    } else if (aChar == chrQuote) {
                        bCanEnd = !bCanEnd;
                    }
                }
                _retBuffer.append((char)aChar);
                if (bCanEnd && (Character.isWhitespace((char)aChar) || aChar == 62)) continue block0;
                ++nPos;
            }
        }
        return ++nPos;
    }

    public static void main(String[] args) {
        String sLinkMapFile = "d:\\test\\link\\link_table.ini";
        String srcFile = "d:\\src.htm";
        String dstFile = "d:\\dst.htm";
        String sHtmlDst = null;
        try {
            ContentLinkReplacer replacer = new ContentLinkReplacer();
            replacer.putLinkMap(I18NMessage.get(ContentLinkReplacer.class, "ContentLinkReplacer.label3", "\u5b66\u751f"), "www.trs.com.cn", "titefdfdsf");
            replacer.putLinkMap(I18NMessage.get(ContentLinkReplacer.class, "ContentLinkReplacer.label4", "\u6df1\u5733"), "www.trs.com.cn", "titefdfdsf");
            replacer.putLinkMap("0", "www.trs.com.cn", "test0");
            String sHtmlSrc = CMyFile.readFile(srcFile);
            long lStartTime = System.currentTimeMillis();
            sHtmlDst = replacer.replaceLink(sHtmlSrc);
            long lEndTime = System.currentTimeMillis();
            System.out.println("==========result=============");
            System.out.println(sHtmlSrc);
            System.out.println(sHtmlDst);
            CMyFile.writeFile(dstFile, sHtmlDst);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    static {
        int i;
        KEY_LEN_LIMIT = 200;
        TAGS_TOSKIP_ARRAY = new String[]{"A", "APPLET", "MAP", "OBJECT", "SELECT", "TEXTAREA", "SCRIPT", "OPTION", "INPUT", "STYLE"};
        TAGS_TOSKIP = new Hashtable();
        for (i = 0; i < TAGS_TOSKIP_ARRAY.length; ++i) {
            TAGS_TOSKIP.put(TAGS_TOSKIP_ARRAY[i].toUpperCase(), TAGS_TOSKIP_ARRAY[i]);
        }
        TAGS_SINGLE_SKIP_ARRAY = new String[]{"OPTION", "INPUT"};
        TAGS_SINGLE_SKIP = new Hashtable();
        for (i = 0; i < TAGS_SINGLE_SKIP_ARRAY.length; ++i) {
            TAGS_SINGLE_SKIP.put(TAGS_SINGLE_SKIP_ARRAY[i].toUpperCase(), TAGS_SINGLE_SKIP_ARRAY[i]);
        }
    }
}

