/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.CLOB;

public class COracleCLOB {
    private static String getStringFromClob(CLOB p_clob) throws Exception {
        if (p_clob == null) {
            return null;
        }
        Reader clobIn = p_clob.getCharacterStream();
        char[] clobCharBuff = new char[8192];
        int cloLength = -1;
        StringBuffer clobStrBuff = new StringBuffer();
        while ((cloLength = clobIn.read(clobCharBuff)) != -1) {
            clobStrBuff.append(clobCharBuff, 0, cloLength);
        }
        clobIn.close();
        return clobStrBuff.toString();
    }

    public static String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        try {
            CLOB clob = null;
            clob = p_bJdbcIs2 ? (CLOB)((OracleResultSet)p_rsData).getClob(p_sFieldName) : ((OracleResultSet)p_rsData).getCLOB(p_sFieldName);
            return COracleCLOB.getStringFromClob(clob);
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.getClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.getClob)"), ex);
        }
    }

    public static String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        try {
            CLOB clob = null;
            clob = p_bJdbcIs2 ? (CLOB)((OracleResultSet)p_rsData).getClob(p_nFieldIndex) : ((OracleResultSet)p_rsData).getCLOB(p_nFieldIndex);
            return COracleCLOB.getStringFromClob(clob);
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.getClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.getClob)"), ex);
        }
    }

    public static boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sClobFieldName.length() < 1 || p_sTableName.length() < 1 || p_sWhere.length() < 1 || p_sIdFieldName.length() < 1) {
            throw new CMyException(10, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label2", "\u53c2\u6570\u65e0\u6548(COracleCLOB.setClob)"));
        }
        String strSQL = " select " + p_sIdFieldName + "," + p_sClobFieldName + " from " + p_sTableName + " where " + p_sWhere + " for update ";
        return COracleCLOB.setClob(p_oConn, p_sValue, strSQL, p_sClobFieldName);
    }

    public static boolean setClob(Connection p_oConn, String p_sValue, String p_sUpdateSQL, String p_sFieldName) throws CMyException {
        boolean bl;
        if (p_sValue == null) {
            return true;
        }
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            p_oConn.setAutoCommit(false);
            pstmt = p_oConn.prepareStatement(p_sUpdateSQL);
            rsData = pstmt.executeQuery();
            if (!rsData.next()) {
                boolean bl2 = false;
                return bl2;
            }
            CLOB clob = ((OracleResultSet)rsData).getCLOB(p_sFieldName);
            if (clob == null) {
                throw new CMyException(40, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label4", "clob\u5bf9\u8c61\u4e3a\u7a7a\uff1a\u5b57\u6bb5\u9700\u8981\u521d\u59cb\u5316\u4e3aempty_clob()\uff08COracleCLOB.setClob\uff09"));
            }
            Writer outx = clob.getCharacterOutputStream();
            outx.write(p_sValue);
            outx.close();
            rsData.close();
            rsData = null;
            pstmt.close();
            pstmt = null;
            p_oConn.commit();
            bl = true;
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label5", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label5", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            try {
                p_oConn.setAutoCommit(true);
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        int i;
        int nClobCount = p_asFieldsAndValues.length / 2;
        boolean blFound = false;
        if (nClobCount <= 0 || nClobCount * 2 != p_asFieldsAndValues.length) {
            throw new CMyException(10, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label6", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(COracleCLOB.setClob)"));
        }
        String strSQL = "select " + p_asFieldsAndValues[0];
        for (i = 1; i < nClobCount; ++i) {
            strSQL = strSQL + "," + p_asFieldsAndValues[i * 2];
        }
        strSQL = strSQL + "," + p_sIdFieldName + " from " + p_sTableName + " where " + p_sWhere + " for update ";
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            p_oConn.setAutoCommit(false);
            pstmt = p_oConn.prepareStatement(strSQL);
            rsData = pstmt.executeQuery();
            blFound = rsData.next();
            if (blFound) {
                for (i = 0; i < nClobCount; ++i) {
                    String sValue = p_asFieldsAndValues[i * 2 + 1];
                    if (sValue == null) continue;
                    CLOB clob = ((OracleResultSet)rsData).getCLOB(i + 1);
                    Writer outx = clob.getCharacterOutputStream();
                    outx.write(sValue);
                    outx.close();
                }
            }
            rsData.close();
            rsData = null;
            pstmt.close();
            pstmt = null;
            p_oConn.commit();
            boolean sValue = blFound;
            return sValue;
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label5", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label5", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            try {
                p_oConn.setAutoCommit(true);
            }
            catch (Exception exception) {}
        }
    }
}

