/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.CMyString;
import java.math.BigInteger;

public class CMyBitsValue
implements Cloneable {
    protected long value = 0L;

    public CMyBitsValue() {
        this.value = 0L;
    }

    public CMyBitsValue(long _lValue) {
        this.setValue(_lValue);
    }

    public CMyBitsValue(String _sValue) {
        this.setValue(_sValue);
    }

    public CMyBitsValue(CMyBitsValue _myBitsValue) {
        this.copy(_myBitsValue);
    }

    public void copy(CMyBitsValue _myBitsValue) {
        this.setValue(_myBitsValue.getValue());
    }

    public Object clone() {
        return new CMyBitsValue(this);
    }

    public static boolean getBitOfInt(int _value, int _index) {
        if (_index < 0 || _index > 31) {
            return false;
        }
        return BigInteger.valueOf(_value).testBit(_index);
    }

    public static boolean getBit(long _value, int _index) {
        if (_index < 0 || _index > 63) {
            return false;
        }
        return BigInteger.valueOf(_value).testBit(_index);
    }

    public static long setBit(long _value, int _index, boolean _bValue) {
        if (_index < 0 || _index > 63) {
            return _value;
        }
        BigInteger bigInt = BigInteger.valueOf(_value);
        bigInt = _bValue ? bigInt.setBit(_index) : bigInt.clearBit(_index);
        return bigInt.longValue();
    }

    protected static int setBitOfInt(int _value, int _index, boolean _bValue) {
        if (_index < 0 || _index > 31) {
            return _value;
        }
        return (int)CMyBitsValue.setBit(_value, _index, _bValue);
    }

    public long getValue() {
        return this.value;
    }

    public int getValueAsInt() {
        return (int)this.value;
    }

    public void setValue(long _nValue) {
        this.value = _nValue;
    }

    public void setValue(String _sValue) {
        if (_sValue == null) {
            return;
        }
        BigInteger bigInt = BigInteger.valueOf(0L);
        int nLen = _sValue.length();
        int nBitPos = nLen - 1;
        for (int i = 0; i < nLen; ++i) {
            if (_sValue.charAt(i) == '1') {
                bigInt = bigInt.setBit(nBitPos);
            }
            --nBitPos;
        }
        this.value = bigInt.longValue();
    }

    public boolean getBit(int _index) {
        return CMyBitsValue.getBit(this.value, _index);
    }

    public CMyBitsValue setBit(int _index, boolean _bValue) {
        this.value = CMyBitsValue.setBit(this.value, _index, _bValue);
        return this;
    }

    public void and(CMyBitsValue _myBitsValue) {
        if (_myBitsValue == null) {
            return;
        }
        this.and(_myBitsValue.getValue());
    }

    public void and(long _value) {
        BigInteger bigInt = BigInteger.valueOf(this.value);
        bigInt = bigInt.and(BigInteger.valueOf(_value));
        this.value = bigInt.longValue();
    }

    public void or(CMyBitsValue _myBitsValue) {
        if (_myBitsValue == null) {
            return;
        }
        this.or(_myBitsValue.getValue());
    }

    public void or(long _value) {
        BigInteger bigInt = BigInteger.valueOf(this.value);
        bigInt = bigInt.or(BigInteger.valueOf(_value));
        this.value = bigInt.longValue();
    }

    public int getRealLength() {
        return BigInteger.valueOf(this.value).bitLength();
    }

    public String toString() {
        return this.toString(this.getRealLength());
    }

    public String toString(int _nLength) {
        String sValue = Long.toBinaryString(this.value);
        if (_nLength > this.getRealLength()) {
            sValue = CMyString.expandStr(sValue, _nLength, '0', false);
        }
        return sValue;
    }

    public static void main(String[] args) {
        int i;
        CMyBitsValue myBitsValue = new CMyBitsValue(0L);
        System.out.println(myBitsValue.toString(10));
        myBitsValue.setBit(31, true);
        System.out.println(myBitsValue.toString());
        myBitsValue.setBit(1, true);
        myBitsValue.setBit(2, false);
        myBitsValue.setBit(3, true);
        myBitsValue.setBit(10, true);
        myBitsValue.setBit(9, false);
        myBitsValue.setBit(8, true);
        myBitsValue.setBit(7, true);
        System.out.println(myBitsValue.toString());
        System.out.println("10=" + myBitsValue.getBit(10));
        System.out.println("1=" + myBitsValue.getBit(1));
        System.out.println("2=" + myBitsValue.getBit(2));
        int nLen = 64;
        myBitsValue.setValue(0L);
        for (i = 0; i < nLen; ++i) {
            myBitsValue.setBit(i, true);
        }
        for (i = nLen - 1; i >= 0; --i) {
            System.out.print(i % 10 == 0 && i > 0 ? " " : String.valueOf(i % 10));
        }
        System.out.print("\n");
        System.out.println(myBitsValue.toString(nLen));
        for (i = nLen - 1; i >= 0; --i) {
            System.out.print(myBitsValue.getBit(i) ? "1" : "0");
        }
        System.out.println("\n");
        System.out.println(CMyString.expandStr(Long.toBinaryString(Long.MAX_VALUE), 64, '0', true) + " : MAX=" + Long.MAX_VALUE);
        System.out.println(Long.toBinaryString(Long.MIN_VALUE) + " : MIN=" + Long.MIN_VALUE);
        System.out.println("\n========= Test for BigInteger ==========");
        BigInteger bigInt = BigInteger.valueOf(0L);
        bigInt = bigInt.setBit(31).setBit(63);
        System.out.println(bigInt.toString(2));
        long lValue = bigInt.longValue();
        System.out.println(Long.toBinaryString(lValue));
        bigInt = BigInteger.valueOf(lValue);
        System.out.println("\n");
        for (i = 63; i >= 0; --i) {
            System.out.print(bigInt.testBit(i) ? "1" : "0");
        }
        int nValue = 0;
        nValue = CMyBitsValue.setBitOfInt(nValue, 31, true);
        System.out.println("\n int = " + nValue);
        for (i = 0; i < 32; ++i) {
            nValue = CMyBitsValue.setBitOfInt(nValue, i, i % 2 == 1);
        }
        nValue = CMyBitsValue.setBitOfInt(nValue, 31, false);
        for (i = 31; i >= 0; --i) {
            System.out.print(CMyBitsValue.getBitOfInt(nValue, i) ? "1" : "0");
        }
        System.out.println("\n");
        System.out.println(Long.toBinaryString(nValue));
        String sValue = "10101";
        myBitsValue.setValue(sValue);
        System.out.println("src = " + sValue);
        System.out.println("dst = " + myBitsValue.toString(10));
        myBitsValue.or(2L);
        System.out.println("or  = " + myBitsValue.toString());
        myBitsValue.and(5L);
        System.out.println("and = " + myBitsValue.toString());
    }
}

