/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.file;

import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;

public class FileUploadHelper {
    public static boolean isForbidFileName(String fileName) throws WCMException {
        String strExt = CMyFile.extractFileExt(fileName);
        return FileUploadHelper.isForbidFileExt(strExt);
    }

    public static boolean isForbidFileExt(String fileExt) throws WCMException {
        String strSuffixConfig;
        if (CMyString.isEmpty(fileExt)) {
            return false;
        }
        String strExt = fileExt.toUpperCase();
        if (strExt.length() > 1 && strExt.charAt(0) == '.') {
            strExt = strExt.substring(1);
        }
        if (CMyString.isEmpty(strSuffixConfig = ConfigServer.getServer().getInitProperty("FILE_UPLOAD_SUFFIX_CONFIG"))) {
            return true;
        }
        if ("FILE_UPLOAD_ALLOW_SUFFIX".equals(strSuffixConfig)) {
            String strAllowExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            String sDefaultSuffix = "doc,docx,xsl,xls,xlsx,xsn,ppt,pptx,pdf,log,txt,html,htm,js,css,xml,zip,rar,gz,bz2,tar,tbz,tgz,jpg,jpeg,gif,png,bmp,wav,mid,midi,mp3,mpa,mp2,ra,ram,rm,wma,asf,avi,mpg,mpeg,mpe,mov,rm,rmvb,wmv,swf,flv";
            if (CMyString.isEmpty(strAllowExt = CMyString.showEmpty(strAllowExt, sDefaultSuffix))) {
                return true;
            }
            strAllowExt = strAllowExt.toUpperCase().trim();
            return ("," + strAllowExt + ",").indexOf("," + strExt + ",") < 0;
        }
        if ("FILE_UPLOAD_FORBIDEN_SUFFIX".equals(strSuffixConfig)) {
            String strForbidExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strForbidExt)) {
                return false;
            }
            strForbidExt = strForbidExt.toUpperCase().trim();
            return ("," + strForbidExt + ",").indexOf("," + strExt + ",") > 0;
        }
        return true;
    }
}

