/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra;

import com.trs.cms.ContextHelper;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.common.ParameterError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.ImgFileHelperForReadImg;
import com.trs.infra.util.Loader;
import com.trs.webframework.config.TRSPageParameter;
import com.trs.webframework.context.MethodContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class WCMServiceHelper {
    private static Logger logger = Logger.getLogger(WCMServiceHelper.class);
    public static final int CONTEXT_INDEX_MLFAPP_SESSION_ID = BaseContextHelper.getNextIndex();

    public static String getDomainHost() throws WCMException {
        String sWCMURL = WCMServiceHelper.getWCMURL();
        int nPos = sWCMURL.lastIndexOf(47, sWCMURL.length() - 2);
        if (nPos <= 0) {
            throw new WCMException("Who set WCM_URL config!!!");
        }
        return sWCMURL.substring(0, nPos);
    }

    public static String getWCMURL() throws WCMException {
        String sWCMURL = WCMServiceHelper.getOriginalWCMURL();
        sWCMURL = CMyString.setStrEndWith(sWCMURL, '/');
        return sWCMURL;
    }

    public static String getOriginalWCMURL() throws WCMException {
        String sWCMURL = WCMServiceHelper.getPropertyValue("application.properties", "host.path");
        if (sWCMURL == null || sWCMURL.trim().length() == 0) {
            sWCMURL = ConfigServer.getServer().getSysConfigValue("WCM_URL", "http://localhost:8080/wcm/");
        }
        return sWCMURL;
    }

    private static String getPropertyValue(String _sPropertyFile, String _sKey) throws WCMException {
        InputStream is = null;
        try {
            Properties m_oConfigProperties = new Properties();
            is = Loader.getResource(_sPropertyFile).openStream();
            m_oConfigProperties.load(is);
            String string = m_oConfigProperties.getProperty(_sKey);
            return string;
        }
        catch (IOException e) {
            throw new WCMException("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String mapWebURLOfFile(String _sFileName) throws WCMException {
        FilesMan oFilesMan = FilesMan.getFilesMan();
        String sHttpPath = oFilesMan.mapFilePath(_sFileName, 1);
        return WCMServiceHelper.getDomainHost() + sHttpPath + _sFileName;
    }

    public static String mapAbsolutFilePath(String _sFileName) throws WCMException {
        FilesMan oFilesMan = FilesMan.getFilesMan();
        String sLocalPath = oFilesMan.mapFilePath(_sFileName, 0);
        return sLocalPath + _sFileName;
    }

    public static String getReadImgURL(String _sImgName, int _nWidth) throws WCMException {
        FilesMan oFilesMan = FilesMan.getFilesMan();
        String sAbsolutPath = oFilesMan.mapFilePath(_sImgName, 0);
        String sNewAbsoluteFileName = ImgFileHelperForReadImg.makeNewAbsolutFileName(sAbsolutPath + _sImgName, _nWidth);
        File file = ImgFileHelperForReadImg.makeValidFile(sNewAbsoluteFileName);
        if (file != null) {
            String sSrcFileName;
            String sNewFileName = CMyFile.extractFileName(file.getPath());
            if (!sNewFileName.equals(sSrcFileName = CMyFile.extractFileName(sNewAbsoluteFileName))) {
                _sImgName = CMyFile.excludeFileExt(_sImgName) + "." + CMyFile.extractFileExt(sNewFileName);
            }
            String sHttpPath = oFilesMan.mapFilePath(_sImgName, 1);
            return WCMServiceHelper.getDomainHost() + sHttpPath + ImgFileHelperForReadImg.makeNewFileName(_sImgName, _nWidth);
        }
        String sJsessionId = "";
        Object jsessionId = ContextHelper.getArg(CONTEXT_INDEX_MLFAPP_SESSION_ID);
        if (jsessionId != null && !CMyString.isEmpty(jsessionId.toString())) {
            sJsessionId = ";JSESSIONID=" + jsessionId.toString();
        }
        return WCMServiceHelper.getWCMURL() + "openapi/readimg" + sJsessionId + "?ScaleWidth=" + _nWidth + "&FileName=" + _sImgName;
    }

    public static WCMFilter makeExtraWCMFilter(MethodContext _methodContext, String _sTableName) throws Exception {
        WCMFilter oExtraFilter = _methodContext.getExtraWCMFilter();
        oExtraFilter.setExtSelect(_methodContext.getValue("ExtSelectFields"));
        String sSearchValue = _methodContext.getValue("SearchValue");
        if (!CMyString.isEmpty(sSearchValue)) {
            String sSearchFields = _methodContext.getValue("SearchFields");
            if ("WCMDOCUMENT".equals(_sTableName)) {
                String sDocIdReg = "(?i)(^|[^a-zA-Z]+)(MetaDataId)([^a-zA-Z]+|$)";
                sSearchFields = sSearchFields.replaceAll("(?i)(^|[^a-zA-Z]+)(MetaDataId)([^a-zA-Z]+|$)", "$1docid$3");
                String sOriginMetaDataIdReg = "(?i)(^|[^a-zA-Z]+)(OriginMetaDataId)([^a-zA-Z]+|$)";
                sSearchFields = sSearchFields.replaceAll("(?i)(^|[^a-zA-Z]+)(OriginMetaDataId)([^a-zA-Z]+|$)", "$1docid$3");
            }
            String[] pSearchFields = CMyString.split(sSearchFields, ",");
            WCMFilter filter = new WCMFilter(_sTableName, null, null);
            StringBuffer sbWhere = new StringBuffer(pSearchFields.length * 15);
            DBManager dbMgr = DBManager.getDBManager();
            for (String sSearchField : pSearchFields) {
                String searchField;
                String[] tableNField = WCMServiceHelper.correctTableNField(_sTableName, sSearchField = sSearchField.trim(), _methodContext, "SearchFields");
                String tableName = tableNField[0];
                if (dbMgr.getFieldInfo(tableName, searchField = tableNField[1]) == null) {
                    logger.error((Object)("SQL Inject by SearchFields? [TableName=" + tableName + "][SearchFields=" + sSearchFields + "]"));
                    throw new ParameterError("\u53c2\u6570\u9519\u8bef[Field=" + searchField + "][SearchFields=" + sSearchFields + "]");
                }
                sbWhere.append(tableName + "." + searchField);
                sbWhere.append(" like ? ");
                sbWhere.append(" or ");
                filter.addSearchValues("%" + sSearchValue.replace("%", "\\%") + "%");
            }
            sbWhere.setLength(sbWhere.length() - 4);
            filter.setWhere(sbWhere.toString());
            oExtraFilter.mergeWith(filter);
        }
        oExtraFilter.setCurrPage(_methodContext.getPageIndex());
        oExtraFilter.setPageSize(_methodContext.getPageSize());
        return oExtraFilter;
    }

    private static String[] correctTableNField(String tableName, String searchField, MethodContext methodContext, String targetParameterName) {
        for (TRSPageParameter pageParameter : methodContext.getMethodConfig().getPageParameter()) {
            String parameterName = pageParameter.getName().trim();
            if (!parameterName.equalsIgnoreCase(targetParameterName) || !pageParameter.getDefault().toUpperCase().contains("." + searchField.toUpperCase())) continue;
            String defaultSearchFields = pageParameter.getDefault();
            return WCMServiceHelper.getTableNField(defaultSearchFields, tableName, searchField);
        }
        return new String[]{tableName, searchField};
    }

    private static String[] getTableNField(String defaultSearchFields, String tableName, String searchField) {
        String[] searchFieldsArr;
        for (String sf : searchFieldsArr = CMyString.split(defaultSearchFields, ",")) {
            String[] tableNField;
            if (!sf.contains(".") || !(tableNField = CMyString.split(sf, "."))[1].equalsIgnoreCase(searchField)) continue;
            return tableNField;
        }
        return new String[]{tableName, searchField};
    }
}

