/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.epress.EPressChannelWrapper;
import com.trs.components.wcm.epress.EPressConf;
import com.trs.components.wcm.epress.EPressHistoryGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class EPressServiceProvider
implements ISelfDefinedServiceProvider {
    public boolean existsSimilarName(MethodContext context) throws Throwable {
        String sChnlName;
        int nSiteId = context.getValue("siteid", 0);
        return Channel.findByName(nSiteId, sChnlName = context.getValue("ChannelName")) != null;
    }

    public boolean checkUUID(MethodContext context) throws Throwable {
        String uuid = context.getValue("UUID");
        if (!CMyString.isEmpty(uuid)) {
            return EPressConf.instance().existsEPress(uuid);
        }
        return true;
    }

    public int createEPress(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        int nSiteId = context.getValue("SiteId", 0);
        int nParentId = context.getValue("ParentId", 0);
        String sCoverPageName = context.getValue("CoverPageName");
        if (nSiteId == 0 && nParentId == 0) {
            throw new WCMException(10, "\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9,\u4e5f\u6ca1\u6709\u6307\u5b9a\u7236\u680f\u76ee;\u56e0\u6b64\u65e0\u6cd5\u521b\u5efa\u680f\u76ee!");
        }
        WebSite site = null;
        if (nSiteId > 0) {
            site = WebSite.findById(nSiteId);
            if (site == null) {
                throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230[Id=" + nSiteId + "]\u7684\u7ad9\u70b9!");
            }
            if (site.isDeleted()) {
                throw new WCMException(200006, site + "\u5df2\u5220\u9664!");
            }
        }
        Channel parent = null;
        if (nParentId > 0) {
            parent = Channel.findById(nParentId);
            this.assertValid(nParentId, parent);
            nSiteId = parent.getSiteId();
        }
        boolean zAuthed = false;
        zAuthed = parent == null ? AuthServer.hasRight(loginUser, (CMSObj)site, 11) : AuthServer.hasRight(loginUser, (CMSObj)parent, 11);
        if (!zAuthed) {
            throw new WCMException(1002, "\u5bf9\u4e0d\u8d77,\u60a8\u6ca1\u6709\u65b0\u5efa\u680f\u76ee\u7684\u6743\u9650!\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb");
        }
        Channel channel = new Channel();
        channel.setName(context.getValue("ChnlName"));
        channel.setDesc(context.getValue("ChnlDesc"));
        channel.setParent(nParentId);
        channel.setSite(nSiteId);
        channel.setType(0);
        channel.setOrder(context.getValue("ChnlOrder", 0));
        int nPageCount = context.getValue("PageCount", 0);
        String sUuid = context.getValue("EPressUUID");
        EPressChannelWrapper channelWrapper = new EPressChannelWrapper(nPageCount, sUuid);
        channelWrapper.setCoverPageName(sCoverPageName);
        channel = channelWrapper.save(loginUser, channel);
        return channel.getId();
    }

    public boolean publishHistoryIndex(MethodContext context) throws Throwable {
        int nChnlId = context.getValue("ChannelId", 0);
        if (!EPressConf.instance().existsEPress(nChnlId)) {
            return true;
        }
        Channel channel = Channel.findById(nChnlId);
        this.assertValid(nChnlId, channel);
        String publishDate = context.getValue("PublishDate");
        CMyDateTime dtPubDate = CMyDateTime.now();
        if (!CMyString.isEmpty(publishDate)) {
            dtPubDate.setDateTimeWithString(publishDate);
        }
        EPressHistoryGenerator generator = new EPressHistoryGenerator(channel);
        generator.generate(dtPubDate);
        return true;
    }

    private void assertValid(int nChnlId, Channel channel) throws WCMException {
        if (channel == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230[Id=" + nChnlId + "]\u7684\u680f\u76ee!");
        }
        if (channel.isDeleted()) {
            throw new WCMException(200006, channel + "\u5df2\u88ab\u5220\u9664!");
        }
    }
}

