/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.index.util.IndexUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class ChannelLCListenerForDocument
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(ChannelLCListenerForDocument.class);
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof Channel)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChannelLCListenerForDocument.class, "ChannelLCListenerForDocument.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(ChannelLCListenerForDocument.class, "ChannelLCListenerForDocument.label2", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        Channel delChannel = (Channel)_oObjDeleted;
        WCMFilter filter = new WCMFilter("WCMChnlDoc, WCMDocument", "(WCMChnlDoc.ChnlId=" + delChannel.getId() + " OR WCMChnlDoc.ChnlId=-" + delChannel.getId() + ") AND WCMDocument.DocId=WCMChnlDoc.DocId", "");
        Documents delDocuments = Documents.openWCMObjs(ContextHelper.getLoginUser(), filter);
        for (int i = 0; i < delDocuments.size(); ++i) {
            Document delDocument = (Document)delDocuments.getAt(i);
            if (delDocument == null) continue;
            this.m_oDocumentMgr.delete(delDocument, delChannel, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof Channel)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChannelLCListenerForDocument.class, "ChannelLCListenerForDocument.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(ChannelLCListenerForDocument.class, "ChannelLCListenerForDocument.label3", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        final Channel newChannel = (Channel)_oObjModified;
        if (newChannel.isChangeProperty("Status")) {
            int nNewStatus = newChannel.getNewPropertyAsInt("Status", 0);
            String[] sqls = null;
            Object[] params = null;
            DBManager dbman = DBManager.getDBManager();
            String isearcherSericeClass = "";
            try {
                isearcherSericeClass = ConfigServer.getServer().getSysConfigValue("TRS_SEARCHER", "SearchBySqlService");
            }
            catch (WCMException e) {
                logger.error((Object)"\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u9879TRS_SEARCHER\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            switch (nNewStatus) {
                case -2: 
                case -1: {
                    sqls = new String[2];
                    sqls[0] = "update WCMChnlDoc set ChnlId=? where ChnlId=?";
                    dbman.sqlExecuteUpdate(sqls, new int[]{-newChannel.getId(), newChannel.getId()});
                    sqls[0] = "update WCMChnlDoc set DocChannel=?,OperTime=?,OperUser=? where DocChannel=?";
                    sqls[1] = "update WCMDocument set DocChannel=?,OperTime=?,OperUser=? where DocChannel=?";
                    params = new Object[]{new Integer(-newChannel.getId()), CMyDateTime.now().toTimestamp(), ContextHelper.getLoginUser().getName(), newChannel.getKey()};
                    dbman.sqlExecuteUpdate(sqls, params);
                    if (!"SearchByLuceneService".equalsIgnoreCase(isearcherSericeClass.trim())) break;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String where = "WCMCHNLDOC.ChnlId=" + -newChannel.getId();
                            try {
                                String relation = "WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID AND WCMCHNLDOC.CHNLID=-WCMCHANNEL.CHANNELID";
                                IndexUtil.makeIndexForListener(where, relation, IndexUtil.INDEX_UPD);
                            }
                            catch (WCMException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                    break;
                }
                case 0: {
                    sqls = new String[]{"update WCMChnlDoc set DocStatus=16 where DocChannel=? and DocStatus=10", "update WCMDocument set DocStatus=16 where DocChannel=? and DocStatus=10", "update WCMChnlDoc set ChnlId=-ChnlId where ChnlId=?"};
                    dbman.sqlExecuteUpdate(sqls, new int[]{-newChannel.getId()});
                    sqls[0] = "update WCMChnlDoc set DocChannel=?,OperTime=?,OperUser=? where DocChannel=?";
                    sqls[1] = "update WCMDocument set DocChannel=?,OperTime=?,OperUser=? where DocChannel=?";
                    sqls[2] = null;
                    params = new Object[]{newChannel.getKey(), CMyDateTime.now().toTimestamp(), ContextHelper.getLoginUser().getName(), new Integer(-newChannel.getId())};
                    dbman.sqlExecuteUpdate(sqls, params);
                    if (!"SearchByLuceneService".equalsIgnoreCase(isearcherSericeClass.trim())) break;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String where = "WCMCHNLDOC.ChnlId=" + newChannel.getId();
                            try {
                                IndexUtil.makeIndexForListener(where, null, IndexUtil.INDEX_UPD);
                            }
                            catch (WCMException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                    break;
                }
            }
            if (!newChannel.isLink()) {
                String sql = "select distinct CHNLID from WCMCHNLDOC where DOCCHANNEL=?";
                Connection conn = null;
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                Channels channels = new Channels(ContextHelper.getLoginUser());
                try {
                    conn = dbman.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, -newChannel.getId());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        channels.addElement(rs.getInt(1));
                    }
                }
                catch (Exception ex) {
                    logger.warn((Object)"failed to refresh outline pages.", (Throwable)ex);
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex) {}
                    }
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Exception ex) {}
                    }
                    if (conn != null) {
                        try {
                            dbman.freeConnection(conn);
                        }
                        catch (Exception ex) {}
                    }
                }
                if (!channels.isEmpty()) {
                    PublishServer pubserver = PublishServer.getInstance();
                    int nPubType = 5;
                    int size = channels.size();
                    for (int i = 0; i < size; ++i) {
                        Channel temp = (Channel)channels.getAt(i);
                        if (temp == null) continue;
                        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(temp);
                        try {
                            pubserver.publishFolder(folder, nPubType);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

