/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.DocBak;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.update.IUpdateCommander;
import com.trs.infra.util.CMyString;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.apache.log4j.Logger;

public class ContentUpdateCommanderImpl
implements IUpdateCommander {
    private static Logger s_logger = Logger.getLogger(ContentUpdateCommanderImpl.class);
    private AppendixMgr m_oAppendixMgr = null;
    public static boolean UPDATE_FROM_DB = true;

    @Override
    public void doUpdate() {
        this.updateFileDocuments();
        this.updateFileDocBaks();
        if (!UPDATE_FROM_DB) {
            this.updateLinkDocuments();
            this.updateLinkDocBaks();
        }
    }

    private void updateLinkDocuments() {
        try {
            User admin = User.findByName("admin");
            String sWhere = "DocType=30";
            WCMFilter filter = new WCMFilter("", sWhere, "");
            Documents documents = Documents.openWCMObjs(admin, filter);
            int nSize = documents.size();
            for (int i = 0; i < nSize; ++i) {
                Document document = (Document)documents.getAt(i);
                if (document == null) continue;
                String sLinkURL = null;
                try {
                    int nEndPos;
                    sLinkURL = document.getPlace();
                    if (sLinkURL == null || sLinkURL.length() == 0) {
                        sLinkURL = document.getContent();
                    }
                    if (sLinkURL == null || sLinkURL.length() == 0) continue;
                    int nPos = sLinkURL.indexOf("/t200");
                    if (nPos > 0 && (nEndPos = sLinkURL.indexOf("_", nPos)) > 0) {
                        sLinkURL = sLinkURL.substring(0, nPos + 2) + sLinkURL.substring(nEndPos + 1);
                    }
                    document.setProperty("DOCLINK", sLinkURL);
                    document.update();
                }
                catch (Exception ex) {
                    s_logger.error((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label1", "\u66f4\u65b0 ") + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label2", " \u94fe\u63a5\u53d1\u751f\u5f02\u5e38")), (Throwable)ex);
                    continue;
                }
                s_logger.info((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label3", "\u6210\u529f\u66f4\u65b0[") + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label4", "]\u7684\u94fe\u63a5\u5730\u5740[") + sLinkURL + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label5", "]\u5b58\u50a8\uff01")));
            }
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label6", "[updateFileDocuments]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkDocBaks() {
        WCMFilter filter = new WCMFilter("", "DocType=30", "");
        DocBaks docbaks = null;
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        String sql = "UPDATE WcmDocBak SET DocLink=? WHERE DocBakId=?";
        try {
            docbaks = DocBaks.openWCMObjs(null, filter);
            conn = DBManager.getDBManager().getConnection();
            preparedStatement = conn.prepareStatement(sql);
            for (int i = 0; i < docbaks.size(); ++i) {
                int nEndPos;
                DocBak docbak = (DocBak)docbaks.getAt(i);
                if (docbak == null) continue;
                String sLinkURL = null;
                sLinkURL = docbak.getPlace();
                if (CMyString.isEmpty(sLinkURL)) {
                    sLinkURL = docbak.getContent();
                }
                if (CMyString.isEmpty(sLinkURL)) continue;
                int nPos = sLinkURL.indexOf("/t200");
                if (nPos > 0 && (nEndPos = sLinkURL.indexOf("_", nPos)) > 0) {
                    sLinkURL = sLinkURL.substring(0, nPos + 2) + sLinkURL.substring(nEndPos + 1);
                }
                preparedStatement.setString(1, sLinkURL);
                preparedStatement.setInt(2, docbak.getId());
                preparedStatement.execute();
            }
            this.freeResource(conn, preparedStatement, docbaks);
        }
        catch (Exception e) {
            try {
                s_logger.error((Object)I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label7", "[updateLinkDocBaks]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
                this.freeResource(conn, preparedStatement, docbaks);
            }
            catch (Throwable throwable) {
                this.freeResource(conn, preparedStatement, docbaks);
                throw throwable;
            }
        }
    }

    private void freeResource(Connection conn, PreparedStatement preparedStatement, DocBaks _docbaks) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (conn != null) {
            DBManager.getDBManager().freeConnection(conn);
        }
        if (_docbaks != null) {
            _docbaks.clear();
        }
    }

    private void updateFileDocuments() {
        try {
            User admin = User.findByName("admin");
            String sWhere = "DocType=40";
            WCMFilter filter = new WCMFilter("", sWhere, "");
            Documents documents = Documents.openWCMObjs(admin, filter);
            int nSize = documents.size();
            for (int i = 0; i < nSize; ++i) {
                Document document = (Document)documents.getAt(i);
                if (document == null) continue;
                Appendix appendix = this.getAppendix(document, 0);
                if (appendix == null) {
                    s_logger.error((Object)("[" + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label8", "]\u7684\u5916\u90e8\u6587\u4ef6\u4e0d\u5b58\u5728!")));
                    SimpleLogServer.warn(LogConstant.Module.EDITORCENTER.desc, LogUserUtil.getLogUser(), "\u4fee\u6539\u6587\u6863", "\u6587\u6863\u9644\u4ef6\u4e0d\u5b58\u5728", String.format("\u6587\u6863[ID=%d]\u5916\u90e8\u6587\u4ef6\u4e0d\u5b58\u5728", document.getId()));
                    continue;
                }
                try {
                    document.setProperty("DOCFILENAME", appendix.getFile());
                    document.update();
                }
                catch (Exception ex) {
                    s_logger.error((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label1", "\u66f4\u65b0 ") + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label9", " \u5916\u90e8\u6587\u4ef6\u53d1\u751f\u5f02\u5e38")), (Throwable)ex);
                    continue;
                }
                s_logger.info((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label3", "\u6210\u529f\u66f4\u65b0[") + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label10", "]\u7684\u5916\u90e8\u6587\u4ef6[") + appendix.getFile() + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label5", "]\u5b58\u50a8\uff01")));
            }
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label6", "[updateFileDocuments]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFileDocBaks() {
        String sWhere = "DocType=40";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        DocBaks docbaks = null;
        Connection conn = null;
        PreparedStatement preParedStatement = null;
        String sql = "UPDATE WcmDocBak SET DocFileName=? WHERE DocBakId=?";
        try {
            conn = DBManager.getDBManager().getConnection();
            preParedStatement = conn.prepareStatement(sql);
            docbaks = DocBaks.openWCMObjs(null, filter);
            for (int i = 0; i < docbaks.size(); ++i) {
                DocBak docbak = (DocBak)docbaks.getAt(i);
                if (docbak == null) continue;
                Appendix appendix = this.getAppendix(docbak, 0);
                if (appendix == null) {
                    s_logger.error((Object)("[" + docbak + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label8", "]\u7684\u5916\u90e8\u6587\u4ef6\u4e0d\u5b58\u5728!")));
                    continue;
                }
                try {
                    preParedStatement.setString(1, appendix.getFile());
                    preParedStatement.setInt(2, docbak.getId());
                    preParedStatement.execute();
                }
                catch (Exception ex) {
                    s_logger.error((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label1", "\u66f4\u65b0 ") + docbak + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label9", " \u5916\u90e8\u6587\u4ef6\u53d1\u751f\u5f02\u5e38")), (Throwable)ex);
                    continue;
                }
                s_logger.info((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label3", "\u6210\u529f\u66f4\u65b0[") + docbak + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label10", "]\u7684\u5916\u90e8\u6587\u4ef6[") + appendix.getFile() + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label5", "]\u5b58\u50a8\uff01")));
            }
            this.freeResource(conn, preParedStatement, docbaks);
        }
        catch (Exception e) {
            try {
                s_logger.error((Object)I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label11", "[updateFileDocBaks]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
                this.freeResource(conn, preParedStatement, docbaks);
            }
            catch (Throwable throwable) {
                this.freeResource(conn, preParedStatement, docbaks);
                throw throwable;
            }
        }
    }

    private Appendix getAppendix(Document _doc, int _nApdType) throws WCMException {
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Appendixes appendixes = this.m_oAppendixMgr.getAppendixes(_doc, _nApdType);
        if (appendixes.isEmpty()) {
            return null;
        }
        return (Appendix)appendixes.getAt(0);
    }
}

