/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DefaultStatHandler;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DocStatHandler4UserChannel
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DefaultStatHandler.class);
    private ChannelMgr m_oChannelMgr = null;
    private int m_ChannelId = 0;
    private Channels channels;

    public DocStatHandler4UserChannel(int _nChannelId) {
        this.m_ChannelId = _nChannelId;
        this.m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
    }

    @Override
    public void visitStart(ResultSet resultSet, int nSQLIndex) throws WCMException {
        super.visitStart(resultSet, nSQLIndex);
        Channel currChannel = Channel.findById(this.m_ChannelId);
        this.channels = (Channels)this.m_oChannelMgr.getChildren(currChannel, -1, false, new WCMFilter());
        this.channels.addElement(currChannel);
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            int nColumnCount = resultSet.getMetaData().getColumnCount();
            int nChannelId = resultSet.getInt(nColumnCount);
            if (this.channels.indexOf(nChannelId) < 0) {
                return;
            }
            String sKey = this.makePrivateKey(this.m_ChannelId + "", resultSet);
            int nDataCount = resultSet.getInt(1);
            int iExistsDataCount = this.getValue(nSQLIndex, sKey);
            int nDataCountOfCurrGroup = nDataCount;
            this.setValue(nSQLIndex, sKey, nDataCountOfCurrGroup += iExistsDataCount);
            String sUserName = resultSet.getString(2);
            this.addMajorObject(sUserName);
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private String makePrivateKey(String sParentId, ResultSet resultSet) throws SQLException {
        int nColumnCount = resultSet.getMetaData().getColumnCount();
        String[] sParam = new String[nColumnCount - 1];
        sParam[0] = sParentId;
        for (int i = 2; i < nColumnCount; ++i) {
            sParam[i - 1] = resultSet.getString(i);
        }
        return this.makeKey(sParam);
    }
}

