/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service.xmlconvertors;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.HTMLContent;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.database.CDBText;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ViewDataToXML
implements IXMLConvertor {
    private static Logger logger = Logger.getLogger(ViewDataToXML.class);
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    protected boolean m_bToXMLDependsOnSelectFields = true;

    @Override
    public String[] registerTargetClassName() {
        return new String[]{MetaViewData.class.getName(), MetaViewDatas.class.getName()};
    }

    @Override
    public String toXmlString(MethodContext _methodContext, Object _result) throws ConvertException {
        if (_result instanceof BaseObjs) {
            return this.toXMLString(_methodContext, (BaseObjs)_result);
        }
        if (_result instanceof BaseObj) {
            return this.toXMLString(_methodContext, (BaseObj)_result);
        }
        throw new ConvertException(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label1", "\u7c7b\u578b[") + _result.getClass().getName() + I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label2", "]\u4e0d\u5339\u914d\uff01"));
    }

    private String toXMLString(MethodContext _methodContext, BaseObjs _baseObjects) throws ConvertException {
        if (_methodContext != null && _methodContext.getValue("OnlyReturnIds", false)) {
            String sValue;
            int nValueType = _methodContext.getValue("IdsValueType", 0);
            switch (nValueType) {
                case 0: {
                    sValue = _baseObjects.getIdListAsString(',');
                    _methodContext.setReturnHTML(true);
                    break;
                }
                case 1: {
                    sValue = "{Ids:\"" + _baseObjects.getIdListAsString(',') + "\"}";
                    _methodContext.setReturnJSON(true);
                    break;
                }
                default: {
                    sValue = "<Ids>" + _baseObjects.getIdListAsString(',') + "</Ids>";
                }
            }
            return sValue;
        }
        String sObjectsTagName = this.makeTagName(_baseObjects.getClass());
        String sObjectTagName = this.makeTagName(_baseObjects.getElementClass());
        int nPageSize = -1;
        int nPageIndex = 1;
        if (_methodContext != null) {
            nPageSize = _methodContext.getPageSize();
            nPageIndex = _methodContext.getPageIndex();
        }
        CPager currPager = new CPager(nPageSize);
        currPager.setCurrentPageIndex(nPageIndex);
        currPager.setItemCount(_baseObjects.size());
        Element rootElement = DocumentHelper.createElement((String)sObjectsTagName);
        this.setPageAttributes(currPager, rootElement);
        String[] pSelectFields = this.makeSelectFields(_methodContext);
        if (pSelectFields != null && pSelectFields.length == 1 && pSelectFields[0].equalsIgnoreCase(_baseObjects.getIdFieldName())) {
            String sIdFieldName = _baseObjects.getIdFieldName();
            for (int i = currPager.getFirstItemIndex(); i <= currPager.getLastItemIndex(); ++i) {
                Element element = rootElement.addElement(sObjectTagName);
                element.addElement(sIdFieldName).addText(String.valueOf(_baseObjects.getIdAt(i - 1)));
            }
        } else {
            for (int i = currPager.getFirstItemIndex(); i <= currPager.getLastItemIndex(); ++i) {
                BaseObj object = _baseObjects.getAt(i - 1);
                if (object == null) continue;
                Element elChild = this.makeElementFromBaseObj(_methodContext, sObjectTagName, object, false, pSelectFields);
                rootElement.add(elChild);
            }
        }
        return rootElement.asXML();
    }

    private String[] makeSelectFields(MethodContext _methodContext) {
        if (_methodContext == null) {
            return null;
        }
        String[] pSelectFields = null;
        String sSelectFields = _methodContext.getValue("SelectFields");
        if (sSelectFields != null && sSelectFields.length() > 0 && !sSelectFields.equals("*")) {
            pSelectFields = CMyString.split(sSelectFields, ",");
        }
        return pSelectFields;
    }

    private void setElementAttributes(Element _rootElement, String[][] _pAttributes) throws ConvertException {
        if (_pAttributes == null) {
            return;
        }
        for (int i = 0; i < _pAttributes.length; ++i) {
            if (_pAttributes[i] == null) continue;
            if (_pAttributes[i].length < 2) {
                throw new ConvertException(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label3", "getSpecialRootAttributes\u7684\u8fd4\u56de\u503c\u4e0d\u7b26\u5408\u89c4\u8303\uff01"));
            }
            _rootElement.addAttribute(_pAttributes[i][0], _pAttributes[i][1]);
        }
    }

    private String toXMLString(MethodContext _methodContext, BaseObj _baseObject) throws ConvertException {
        String[] pSelectFields = this.makeSelectFields(_methodContext);
        String sObjectTagName = this.makeTagName(_baseObject.getClass());
        Element root = this.makeElementFromBaseObj(_methodContext, sObjectTagName, _baseObject, true, pSelectFields);
        return root.asXML();
    }

    private String[][] getSpecialElementAttributes(MethodContext context, BaseObj object) throws ConvertException {
        MetaViewData oMetaViewData = (MetaViewData)object;
        if (context.getValue("ContainsRight", false)) {
            try {
                User loginUser = ContextHelper.getLoginUser();
                if (loginUser.isAdministrator()) {
                    return new String[][]{{"Right", RightValue.getAdministratorValues()}};
                }
                Channel oChannel = oMetaViewData.getChannel();
                ViewDocument viewDocument = ViewDocument.findById(oChannel, oMetaViewData.getChnlDocId(), null, "cruser");
                return new String[][]{{"Right", viewDocument.getRightValue(loginUser).toString()}};
            }
            catch (Exception e) {
                throw new ConvertException(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label4", "\u6784\u9020[") + oMetaViewData + I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label5", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), e);
            }
        }
        return null;
    }

    private void setPageAttributes(CPager _pager, Element _element) {
        _element.addAttribute("Num", String.valueOf(_pager.getItemCount()));
        if (_pager.getPageSize() <= 0) {
            return;
        }
        _element.addAttribute("PageSize", String.valueOf(_pager.getPageSize()));
        _element.addAttribute("PageCount", String.valueOf(_pager.getPageCount()));
        _element.addAttribute("CurrPageIndex", String.valueOf(_pager.getCurrentPageIndex()));
    }

    protected boolean isToHTML(MethodContext _methodContext, String _sFieldName) {
        if (_methodContext == null) {
            return false;
        }
        String sFieldsToHTML = _methodContext.getValue("FieldsToHTML");
        if (sFieldsToHTML == null || sFieldsToHTML.length() == 0) {
            return false;
        }
        return ("," + sFieldsToHTML + ",").toUpperCase().indexOf("," + _sFieldName.toUpperCase() + ",") >= 0;
    }

    protected Element makeElementFromBaseObj(MethodContext _methodContext, String _sTagName, BaseObj _baseObj, boolean _bLoadText, String[] _pSelectFields) throws ConvertException {
        try {
            MetaViewData viewData = (MetaViewData)_baseObj;
            int nViewId = viewData.getMetaView().getId();
            Hashtable[] pProperties = this.getPropertiesArray(_baseObj, _bLoadText);
            Element element = DocumentHelper.createElement((String)_sTagName);
            for (Hashtable properties : pProperties) {
                if (properties == null) continue;
                Object[] pKeys = null;
                pKeys = this.m_bToXMLDependsOnSelectFields && _pSelectFields != null && _pSelectFields.length > 0 ? _pSelectFields : properties.keySet().toArray();
                for (int i = 0; i < pKeys.length; ++i) {
                    MetaViewField oViewField;
                    CMyDateTime dtValue;
                    String sName = ((String)pKeys[i]).toUpperCase();
                    if (!properties.containsKey(sName)) continue;
                    Element field = element.addElement(sName);
                    Object oValue = properties.get(sName);
                    if (sName.equals("ATTRIBUTE") && oValue != null) {
                        AttributesString attrs = new AttributesString(oValue.toString());
                        List listNames = attrs.getNameList();
                        int nSize = listNames.size();
                        for (int j = 0; j < nSize; ++j) {
                            String sAttrName = (String)listNames.get(j);
                            field.addAttribute(sAttrName, attrs.getAttributeValue(sAttrName));
                        }
                        continue;
                    }
                    if (oValue instanceof CMyDateTime && !(dtValue = (CMyDateTime)oValue).isNull()) {
                        oValue = this.convertDateTimeValueToString(_methodContext, dtValue);
                    }
                    if ((oViewField = this.m_oDataDefCacheMgr.getMetaViewField(nViewId, sName)) != null && this.isTransHTML(oViewField, _methodContext.getValue("isAddEdit", false))) {
                        oValue = CMyString.filterForHTMLValue(oValue.toString());
                    }
                    String sValue = null;
                    if (this.m_oDataDefCacheMgr.isFieldWithType(nViewId, sName, 10)) {
                        this.makeClassInfoField(field, oValue);
                    }
                    if (this.m_oDataDefCacheMgr.isFieldWithType(nViewId, sName, 14)) {
                        this.makeRelDocField(field, oValue);
                    }
                    if (oValue != null && this.m_oDataDefCacheMgr.isEditorField(nViewId, sName)) {
                        HTMLContent oHContent = new HTMLContent(oValue.toString());
                        oValue = oHContent.parseHTMLContent(null);
                    }
                    if (sName.equals("DOCSTATUS")) {
                        this.makeStatus(field, viewData.getStatus());
                        continue;
                    }
                    if (this.isCData(oValue)) {
                        if (sValue == null) {
                            sValue = oValue == null || oValue instanceof NullValue ? "" : oValue.toString();
                        }
                        if (sValue == null || sValue.length() <= 0) continue;
                        if (this.isToHTML(_methodContext, sName)) {
                            sValue = CMyString.transDisplay(sValue, false);
                        }
                        if (sValue.matches("(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*")) {
                            field.setText(sValue);
                            continue;
                        }
                        field.addCDATA(sValue);
                        continue;
                    }
                    if (sValue != null) {
                        field.setText(sValue);
                        continue;
                    }
                    if (oValue instanceof CMyDateTime) {
                        CMyDateTime dtValue2 = (CMyDateTime)oValue;
                        if (dtValue2.isNull()) continue;
                        field.setText(this.convertDateTimeValueToString(_methodContext, dtValue2));
                        continue;
                    }
                    if (sValue == null) {
                        sValue = oValue == null || oValue instanceof NullValue ? "" : oValue.toString();
                    }
                    if (sValue == null || sValue.length() <= 0) continue;
                    field.setText(sValue);
                }
                String[][] pSpecialProperty = this.getSpecialElementAttributes(_methodContext, _baseObj);
                this.setElementAttributes(element, pSpecialProperty);
            }
            return element;
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label6", "\u5904\u7406\u5355\u4e2a\u5143\u7d20\u5931\u8d25\uff01"), e);
        }
    }

    private void makeClassInfoField(Element _currFieldElement, Object _currValue) {
        String sClsssName = null;
        String sClassId = "0";
        String sClassCode = null;
        if (_currValue == null || _currValue.toString().length() == 0) {
            sClsssName = "";
        } else {
            StringBuffer sbClassIds = new StringBuffer();
            StringBuffer sbClassName = new StringBuffer();
            StringBuffer sbClassCode = new StringBuffer();
            ClassInfos oClassInfos = null;
            try {
                oClassInfos = ClassInfos.findByIds(null, _currValue.toString());
            }
            catch (Exception e) {
                logger.fatal((Object)(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label7", "\u83b7\u53d6\u8bb0\u5f55\u7684\u5206\u7c7b\u6cd5\u5b57\u6bb5\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u5206\u7c7b\u6cd5\u7684ids:[") + sClassId + I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label8", "]\u4e0d\u5408\u6cd5")));
                _currFieldElement.addAttribute("Name", "<font color='red'>ERROR-IDS</font>");
                _currFieldElement.addAttribute("Id", "0");
                return;
            }
            int nSize = oClassInfos.size();
            for (int j = 0; j < nSize; ++j) {
                ClassInfo oClassInfo = (ClassInfo)oClassInfos.getAt(j);
                if (oClassInfo == null) continue;
                if (oClassInfo.containsProperty("CCODE")) {
                    sbClassCode.append(oClassInfo.getPropertyAsString("CCODE")).append(",");
                }
                sbClassIds.append(oClassInfo.getId()).append(",");
                sbClassName.append(oClassInfo.getName()).append(",");
            }
            if (sbClassIds.length() > 0) {
                sbClassIds.setLength(sbClassIds.length() - 1);
                sbClassName.setLength(sbClassName.length() - 1);
            }
            if (sbClassCode.length() > 0) {
                sbClassCode.setLength(sbClassCode.length() - 1);
                sClassCode = sbClassCode.toString();
            }
            sClassId = sbClassIds.toString();
            sClsssName = CMyString.filterForHTMLValue(sbClassName.toString());
        }
        _currFieldElement.addAttribute("Name", sClsssName);
        _currFieldElement.addAttribute("Id", sClassId);
        if (sClassCode != null) {
            _currFieldElement.addAttribute("Code", sClassCode);
        }
    }

    private void makeRelDocField(Element _currFieldElement, Object _currValue) {
        String sRelDocTitles = null;
        String sRelDocIds = "0";
        if (_currValue == null || _currValue.toString().length() == 0) {
            sRelDocTitles = "";
        } else {
            sRelDocIds = _currValue.toString();
            StringBuffer sb = new StringBuffer();
            Documents oDocuments = null;
            try {
                oDocuments = Documents.findByIds(null, sRelDocIds);
            }
            catch (Exception e) {
                logger.fatal((Object)(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label9", "\u83b7\u53d6\u8bb0\u5f55\u7684\u76f8\u5173\u6587\u6863\u5b57\u6bb5\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u76f8\u5173\u6587\u6863\u5b57\u6bb5\u503c:[") + sRelDocIds + I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label8", "]\u4e0d\u5408\u6cd5")));
                _currFieldElement.addAttribute("Name", "");
                _currFieldElement.addAttribute("Id", "-1");
                return;
            }
            int nSize = oDocuments.size();
            for (int j = 0; j < nSize; ++j) {
                Document oDocument = (Document)oDocuments.getAt(j);
                if (oDocument == null || oDocument.isDeleted()) continue;
                sb.append(oDocument.getTitle()).append("`");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            sRelDocTitles = sb.toString();
        }
        _currFieldElement.addAttribute("Name", sRelDocTitles);
        _currFieldElement.addAttribute("Id", sRelDocIds);
    }

    protected Hashtable[] getPropertiesArray(BaseObj _baseObj, boolean _bLoadText) {
        Hashtable<String, Object> properties = _bLoadText ? _baseObj.getAllProperty() : _baseObj.getProperties();
        if (_baseObj instanceof MetaViewData) {
            MetaViewData viewData = (MetaViewData)_baseObj;
            return new Hashtable[]{properties, viewData.getChnlDocProperties()};
        }
        return new Hashtable[]{properties};
    }

    protected String convertDateTimeValueToString(MethodContext _methodContext, CMyDateTime _dtValue) {
        String sDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        if (_methodContext != null && (sDateTimeFormat = _methodContext.getValue("DateTimeFormat")) == null) {
            sDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        }
        String sDtValue = _dtValue.toString(sDateTimeFormat);
        return sDtValue;
    }

    private boolean isCData(Object _value) {
        if (_value instanceof CDBText) {
            return true;
        }
        return _value instanceof String && ((String)_value).length() > 0;
    }

    private String makeTagName(Class _objectClass) {
        String sObjectsTagName = _objectClass.getName();
        int nPos = sObjectsTagName.lastIndexOf(46);
        if (nPos >= 0) {
            sObjectsTagName = sObjectsTagName.substring(nPos + 1);
        }
        return sObjectsTagName;
    }

    private void makeStatus(Element _currElement, Status status) {
        if (status == null) {
            _currElement.addAttribute("ID", "0");
            _currElement.addAttribute("NAME", I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label10", "\u672a\u77e5"));
            return;
        }
        _currElement.addAttribute("ID", status.getKey().toString());
        _currElement.addAttribute("NAME", status.getDisp());
    }

    private boolean isTransHTML(MetaViewField oViewField, boolean _isAddEdit) throws WCMException {
        if (this.m_oDataDefCacheMgr.isEditorField(oViewField)) {
            return false;
        }
        if (!_isAddEdit) {
            return true;
        }
        int _iFieldType = oViewField.getType();
        switch (_iFieldType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 17: {
                return true;
            }
        }
        return false;
    }
}

