/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDataType;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import java.util.HashMap;

public class MetaDBField
extends CMSObj {
    public static final int OBJ_TYPE = 1269981572;
    public static final String DB_TABLE_NAME = "XWCMDBFIELDINFO";
    public static final String DB_ID_NAME = "DBFIELDINFOID";
    public static final String DB_FIELD_DBNAME_NAME = "FIELDNAME";
    public static final String DB_FIELD_DBTYPE_NAME = "DBTYPE";
    private MetaDataType m_oMetaDataType = null;
    private MetaDataType m_oMetaDBDataType = null;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1269981572;
    }

    public String getTableName() {
        return this.getPropertyAsString("TABLENAME");
    }

    public boolean setTableName(String _sTableName) throws WCMException {
        return this.setProperty("TABLENAME", _sTableName);
    }

    public int getTableId() {
        return this.getPropertyAsInt("TABLEID", 0);
    }

    public boolean setTableId(int _nTableId) throws WCMException {
        return this.setProperty("TABLEID", _nTableId);
    }

    public String getName() {
        return this.getPropertyAsString(DB_FIELD_DBNAME_NAME);
    }

    public boolean setName(String _sName) throws WCMException {
        return this.setProperty(DB_FIELD_DBNAME_NAME, _sName);
    }

    public String getAnotherName() {
        return this.getPropertyAsString("ANOTHERNAME");
    }

    public boolean setAnotherName(String _sAnotherName) throws WCMException {
        return this.setProperty("ANOTHERNAME", _sAnotherName);
    }

    public int getType() {
        return this.getPropertyAsInt("FIELDTYPE", 0);
    }

    public boolean setType(int _nType) throws WCMException {
        return this.setProperty("FIELDTYPE", _nType);
    }

    public int getDBType() {
        return this.getPropertyAsInt(DB_FIELD_DBTYPE_NAME, 0);
    }

    public boolean setDBType(int _nDBType) throws WCMException {
        return this.setProperty(DB_FIELD_DBTYPE_NAME, _nDBType);
    }

    public int getLength() {
        return this.getPropertyAsInt("DBLENGTH", 0);
    }

    public boolean setLength(int _nLength) throws WCMException {
        return this.setProperty("DBLENGTH", _nLength);
    }

    public int getScale() {
        return this.getPropertyAsInt("DBSCALE", 3);
    }

    public boolean setScale(int _nScale) throws WCMException {
        return this.setProperty("DBSCALE", _nScale);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString("DEFAULTVALUE");
    }

    public boolean setDefaultValue(String _sDefaultValue) throws WCMException {
        return this.setProperty("DEFAULTVALUE", _sDefaultValue);
    }

    public String getValidator() {
        return this.getPropertyAsString("Validator");
    }

    public boolean setValidator(String _sValidatorExpress) throws WCMException {
        return this.setProperty("Validator", _sValidatorExpress);
    }

    public String getEnmValue() {
        return this.getPropertyAsString("ENMVALUE");
    }

    public boolean setEnmValue(String _sEnmValue) throws WCMException {
        return this.setProperty("ENMVALUE", _sEnmValue);
    }

    public boolean isNotNull() {
        return this.getPropertyAsBoolean("NOTNULL", false);
    }

    public boolean setNotNull(boolean _bNotNull) throws WCMException {
        return this.setProperty("NOTNULL", _bNotNull);
    }

    public boolean isRadioOrCheck() {
        return this.getPropertyAsBoolean("Radorchk", false);
    }

    public boolean setRadioOrCheck(boolean bRadioOrCheck) throws WCMException {
        return this.setProperty("Radorchk", bRadioOrCheck);
    }

    public int getClassId() {
        return this.getPropertyAsInt("CLASSID", 0);
    }

    public boolean setClassId(int _nClassId) throws WCMException {
        return this.setProperty("CLASSID", _nClassId);
    }

    @Override
    public boolean isValid() throws WCMException {
        int fieldType = 0;
        if (this.isAddMode()) {
            if (this.getProperty("TABLENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label1", "\u5c5e\u6027TableName\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty("TABLEID") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label2", "\u5c5e\u6027TableId\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty(DB_FIELD_DBNAME_NAME) == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label3", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty("ANOTHERNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label4", "\u5c5e\u6027AnotherName\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty("FIELDTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label5", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty(DB_FIELD_DBTYPE_NAME) == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label6", "\u5c5e\u6027DBType\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty("DBSCALE") == null) {
                this.setScale(0);
            }
            if (this.getProperty("CLASSID") == null) {
                this.setClassId(0);
            }
            if (this.getProperty("NotNull") == null) {
                this.setNotNull(false);
            }
            fieldType = this.getType();
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(MetaDBField.class, "MetaDBField.label7", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(DBFieldInfo.isValid)"));
            }
            fieldType = this.getNewPropertyAsInt("FIELDTYPE", 0);
        }
        if (fieldType != 0) {
            MetaDataType oCurrMetaDataType = null;
            oCurrMetaDataType = fieldType == 1 ? MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType()) : MetaDataConstants.DATA_TYPES.getDataTypeById(fieldType);
            if (this.isAddMode() && this.getProperty("DBLENGTH") == null) {
                this.setLength(oCurrMetaDataType.getMaxLength());
            } else if (!this.isAddMode() && this.getType() != fieldType && this.getNewProperty("DBLENGTH") == null) {
                this.setLength(oCurrMetaDataType.getMaxLength());
            }
            if (this.getDBType() == 2005 || this.getDBType() == 93 || this.getDBType() == 4) {
                this.setLength(0);
            }
        }
        return true;
    }

    public String getClassName() {
        int nClassId = this.getClassId();
        if (nClassId == 0) {
            return "";
        }
        try {
            ClassInfo oClassInfo = ClassInfo.findById(this.getClassId());
            if (oClassInfo != null) {
                return oClassInfo.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getTypeDesc() {
        if (this.m_oMetaDataType == null) {
            this.m_oMetaDataType = MetaDataConstants.DATA_TYPES.getDataTypeById(this.getType());
        }
        return this.m_oMetaDataType.getDataTypeDesc();
    }

    public String getDBTypeDesc() {
        if (this.m_oMetaDBDataType == null) {
            this.m_oMetaDBDataType = MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType());
        }
        return this.m_oMetaDBDataType.getDataTypeDesc();
    }

    public int getSqlType() {
        if (this.m_oMetaDBDataType == null) {
            this.m_oMetaDBDataType = MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType());
        }
        return this.m_oMetaDBDataType.getSqlDataType();
    }

    public boolean isStringField() {
        if (this.m_oMetaDBDataType == null) {
            this.m_oMetaDBDataType = MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType());
        }
        return this.m_oMetaDBDataType.isString();
    }

    public boolean isModifyColumnProperties(boolean _bContainNull) {
        if (!this.isModified()) {
            return false;
        }
        String[] pFieldNames = new String[]{"DBLength", "DBSCALE"};
        if (_bContainNull) {
            pFieldNames = new String[]{"NotNull", "DBLength", "DBSCALE"};
        }
        for (int i = 0; i < pFieldNames.length; ++i) {
            if (!this.isChangeProperty(pFieldNames[i])) continue;
            return true;
        }
        if (!this.isAddMode()) {
            if (this.getType() == 12) {
                return false;
            }
            if (this.getType() == 1 && this.getDBType() == 2005) {
                return false;
            }
            if (this.getType() != this.getNewPropertyAsInt("fieldType", 0) && this.getNewProperty("DBLENGTH") == null) {
                return true;
            }
        }
        return false;
    }

    public HashMap getEnmValueMap(boolean valueAsKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        String enmValue = this.getEnmValue();
        String[] items = enmValue.split("~");
        for (int i = 0; i < items.length; ++i) {
            String[] item = items[i].split("`");
            if (valueAsKey) {
                map.put(item.length > 1 ? item[1] : item[0], item[0]);
                continue;
            }
            map.put(item[0], item.length > 1 ? item[1] : item[0]);
        }
        return map;
    }

    public MetaDBTable getMetaDBTable() throws WCMException {
        return MetaDBTable.findById(this.getTableId());
    }

    public static final MetaDBField findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (MetaDBField)BaseObj.findById(MetaDBField.class, _nId);
    }

    public static final MetaDBField createNewInstance() throws WCMException {
        return (MetaDBField)BaseObj.createNewInstance(MetaDBField.class);
    }

    public static final MetaDBField findByKey(Object _oKey) throws WCMException {
        return (MetaDBField)BaseObj.findByKey(MetaDBField.class, _oKey);
    }
}

