/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.publish.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.components.infoview.persistent.InfoViewDocument;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewFields;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class TagParserInfoViewData
implements ITagParser {
    private static final Logger s_logger = Logger.getLogger(TagParserInfoViewData.class);
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_INFOVIEWDATA");
            tbi.setDesc("TRS_INFOVIEWDATA");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setDesc("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(true);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMAT");
            tbai.setDesc("AUTOFORMAT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DATEFORMAT");
            tbai.setDesc("DATEFORMAT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMATTYPE");
            tbai.setDesc("AUTOFORMATTYPE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("HTML");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TRUNCATEDFLAG");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("...");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sFieldName = _context.getAttribute("FIELD");
        if (sFieldName == null || sFieldName.length() <= 0) {
            return null;
        }
        IPublishElement content = _context.getUpperHost();
        if (content == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        CMSObj upperHost = content.getSubstance();
        String sFieldValue = null;
        if (upperHost instanceof Document) {
            Document document = (Document)upperHost;
            if (document.getChannel().getType() != 13) {
                return null;
            }
            InfoViewDocument oInfoViewDoc = this.getInfoViewDocumentUseCache(_context, document);
            sFieldValue = this.getFieldValue(sFieldName, oInfoViewDoc, _context);
        } else if (upperHost instanceof InfoViewData) {
            InfoViewData infoviewData = (InfoViewData)upperHost;
            sFieldValue = this.getFieldValue(sFieldName, infoviewData, _context);
        } else {
            StringBuffer sb = new StringBuffer(256);
            sb.append(_context.getTagItem().getDescWithPos());
            sb.append(I18NMessage.get(TagParserInfoViewData.class, "TagParserInfoViewData.label1", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,\u53ef\u80fd\u76f4\u63a5\u7528\u5728\u4e86\u6982\u89c8\u9875\u9762\u4e2d\u6216\u8005\u5176\u5b83\u975e"));
            sb.append(I18NMessage.get(TagParserInfoViewData.class, "TagParserInfoViewData.label2", "TRS_DOCUMENTS\u6982\u89c8\u7f6e\u6807\u4e2d\uff01[tag-host="));
            sb.append(upperHost).append(']');
            _context.addWarning(sb.toString());
        }
        if (sFieldValue == null) {
            return null;
        }
        String sImagePath = this.calImagePath(_context);
        HTMLContent oHTMLContent = new HTMLContent(sFieldValue);
        sFieldValue = oHTMLContent.parseHTMLContent(sImagePath);
        this.distributionHTMLContentFiles(oHTMLContent, _context, (IPublishContent)content);
        sFieldValue = TagParseHelper.truncateTextIfNeeded(_context, sFieldValue);
        sFieldValue = TagParseHelper.formatTextIfNeeded(_context, sFieldValue);
        return new String[]{sFieldValue};
    }

    private InfoViewDocument getInfoViewDocumentUseCache(PublishTagContext _context, Document document) throws WCMException {
        Object objExtra;
        InfoViewDocument oInfoViewDoc = null;
        HashMap<String, InfoViewDocument> upperHostExtra = _context.getExtraAttributes();
        if (upperHostExtra == null) {
            upperHostExtra = new HashMap<String, InfoViewDocument>(1);
            _context.setExtraAttributes(upperHostExtra);
        }
        if ((objExtra = upperHostExtra.get("INFOVIEW_DOCUMENT")) instanceof InfoViewDocument) {
            oInfoViewDoc = (InfoViewDocument)objExtra;
        }
        if (oInfoViewDoc == null || oInfoViewDoc.getDocId() != document.getId()) {
            oInfoViewDoc = InfoViewDocument.findSelfByDocument(document);
            upperHostExtra.put("INFOVIEW_DOCUMENT", oInfoViewDoc);
        }
        return oInfoViewDoc;
    }

    private String getFieldValue(String fieldName, InfoViewDocument infoViewDoc, PublishTagContext _context) {
        String fieldOriName = fieldName.replaceAll("/[^:]*:", "/").replaceAll("^[^:*]:", "/");
        int nInfoViewId = infoViewDoc.getInfoViewId();
        fieldName = InfoViewHelper.getDBFieldByField(nInfoViewId, fieldOriName, false);
        Object objValue = infoViewDoc.getProperty(fieldName);
        String sResult = null;
        if (objValue instanceof CMyDateTime) {
            sResult = ((CMyDateTime)objValue).toString(this.getDateFormat(_context));
        } else if (objValue instanceof String) {
            sResult = (String)objValue;
            sResult = this.specialDoWithValue(nInfoViewId, fieldOriName, sResult);
        } else if (objValue != null) {
            sResult = objValue.toString();
        }
        return sResult;
    }

    private String getFieldValue(String fieldName, InfoViewData infoViewData, PublishTagContext _context) {
        String fieldOriName = fieldName.replaceAll("/[^:]*:", "/").replaceAll("^[^:*]:", "/");
        int nInfoviewId = infoViewData.getInfoViewId();
        fieldName = InfoViewHelper.getDBFieldByField(nInfoviewId, fieldOriName, false);
        Object objValue = infoViewData.getProperty(fieldName);
        String sResult = null;
        if (objValue instanceof CMyDateTime) {
            sResult = ((CMyDateTime)objValue).toString(this.getDateFormat(_context));
        } else if (objValue instanceof String) {
            sResult = (String)objValue;
            sResult = this.specialDoWithValue(nInfoviewId, fieldOriName, sResult);
        } else if (objValue != null) {
            sResult = objValue.toString();
        }
        return sResult;
    }

    private String specialDoWithValue(int _nInfoviewId, String _fieldOriName, String _sFieldValue) {
        InfoViewFields fields = null;
        try {
            fields = InfoViewFields.findByName(_fieldOriName, _nInfoviewId);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        if (fields == null || fields.size() == 0) {
            return _sFieldValue;
        }
        InfoViewField field = (InfoViewField)fields.getAt(0);
        String sType = field.getFieldType();
        if (!"CheckBox".equalsIgnoreCase(sType)) {
            return _sFieldValue;
        }
        Object[] sFieldValue = CMyString.split(_sFieldValue, ",");
        _sFieldValue = CMyString.join(sFieldValue, ",");
        return _sFieldValue;
    }

    protected String getDateFormat(PublishTagContext _context) {
        String sDateFormat = _context.getAttribute("DATEFORMAT");
        if (sDateFormat == null || (sDateFormat = sDateFormat.trim()).length() == 0) {
            sDateFormat = "yyyy-MM-dd HH:mm:ss";
        }
        return TagParseHelper.parseDateFormat(sDateFormat);
    }

    private void distributionHTMLContentFiles(HTMLContent oHTMLContent, PublishTagContext _context, IPublishContent publishContent) {
        try {
            List<String> listFiles = oHTMLContent.getWCMFiles();
            int nSize = listFiles.size();
            if (nSize <= 0) {
                return;
            }
            boolean bPreview = _context.isPreview();
            PublishPathCompass compass = _context.getPathCompass();
            publishContent.setFolder(publishContent.getOriginalHome());
            for (int i = 0; i < nSize; ++i) {
                String sSrcFilePathName;
                String sFileName = listFiles.get(i);
                if (sFileName == null || !CMyFile.fileExists(sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName)) continue;
                String sLocalPath = compass.getLocalPath(publishContent, bPreview);
                PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
                CMyFile.copyFile(sSrcFilePathName, sLocalPath + sFileName);
                if (bPreview) continue;
                _context.getFileDistributeShip().distributeFile(sSrcFilePathName, publishContent, null, true);
            }
        }
        catch (Exception ex) {
            s_logger.error((Object)(I18NMessage.get(TagParserInfoViewData.class, "TagParserInfoViewData.label3", "\u53d1\u5e03") + publishContent + I18NMessage.get(TagParserInfoViewData.class, "TagParserInfoViewData.label4", "\u7684HTML\u6b63\u6587\u56fe\u7247\u5931\u8d25\uff01")), (Throwable)ex);
        }
    }

    private String calImagePath(PublishTagContext _context) throws WCMException {
        String attrName = "InfoViewImagePath";
        PublishPageContext pageContext = _context.getPageContext();
        String sImagePath = pageContext.getExtraAttribute(attrName);
        if (sImagePath != null) {
            return sImagePath;
        }
        IPublishContent content2 = (IPublishContent)_context.getUpperHost();
        String sImagePath1 = _context.getPathCompass().getAbsoluteHttpPath(content2.getOriginalHome());
        String sImagePath2 = PublishPathCompass.calSubDirectory(content2, false);
        sImagePath = sImagePath1 + sImagePath2;
        if (!_context.getAttribute("UrlIsABS", false)) {
            sImagePath = HtmlUtil.calRelativePath(sImagePath, _context.getPageHttpPath());
        }
        pageContext.setExtraAttribute(attrName, sImagePath);
        return sImagePath;
    }

    public void clear() {
    }
}

