/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.components.common.publish.widget.StyleRepeatNameHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResourceStyleImporter {
    private static Logger s_logger = Logger.getLogger(ResourceStyleImporter.class);
    private XmlToObjConverter m_converter = null;
    private final Map m_ResourceStyleIds = new HashMap();
    private static final String PROPERTY_CRUSER = "CRUSER";
    private static final String PROPERTY_CRTIME = "CRTIME";
    private static final char CHAR_S = 'S';
    private static final String TAG_STYLE_ITEMS = "XWCMSTYLEITEMS";
    private IStyleItemMgr m_oStyleItemMgr = null;
    private IResourceStyleMgr m_oResourceStyleMgr = null;
    private Reports m_reports;
    private ArrayList m_successIdList;

    public ResourceStyleImporter() {
        this.m_converter = new XmlToObjConverter(1);
        this.registerConverter();
        this.m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");
        this.m_oResourceStyleMgr = (IResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
    }

    public Reports importFromFile(String _sFile, int _nImportMode, int _nImportToPageStyleId) throws Exception {
        this.checkFile(_sFile);
        String sFullFile = this.getFullName(_sFile);
        this.m_reports = new Reports("");
        this.m_successIdList = new ArrayList();
        return this.importFromZip(sFullFile, _nImportMode, _nImportToPageStyleId);
    }

    private Reports importFromZip(String _sFullZipPath, int _nImportMode, int _nImportToPageStyleId) throws Exception {
        String sUnZipPath = CMyFile.extractFilePath(_sFullZipPath) + "unzip" + System.currentTimeMillis();
        sUnZipPath = CMyString.setStrEndWith(sUnZipPath, File.separatorChar);
        CMyUnZipFile uzf = new CMyUnZipFile(_sFullZipPath, sUnZipPath);
        try {
            uzf.doUnZipAnd();
        }
        catch (CMyException e) {
            this.m_reports.setTitle("\u89e3\u538b\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01");
            this.m_reports.addFailedReport("\u89e3\u538b\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", e);
            return this.m_reports;
        }
        FileStore[] listFile = CMyFile.listSubDirectories(sUnZipPath);
        if (listFile == null || listFile.length == 0) {
            this.m_reports.setTitle("\u5f85\u5bfc\u5165\u7684zip\u6587\u4ef6\u4e2d\u6ca1\u6709\u5305\u542b\u4efb\u4f55\u9875\u9762\u98ce\u683c\u4e0b\u7684\u8d44\u6e90\u98ce\u683c\uff01");
            return this.m_reports;
        }
        for (int i = 0; i < listFile.length; ++i) {
            FileStore[] xmlFiles;
            FileStore oFile = listFile[i];
            if (!oFile.exists()) continue;
            String sFilePath = oFile.getAbsolutePath();
            String sPageStyleName = CMyFile.extractFileName(sFilePath);
            PageStyle currPageStyle = PageStyle.findByName(sPageStyleName);
            if (currPageStyle == null) {
                this.copyImportResourceStylesImgs(sPageStyleName, sFilePath);
                continue;
            }
            int nPageStyleId = currPageStyle.getId();
            if (_nImportToPageStyleId > 0 && nPageStyleId != _nImportToPageStyleId || (xmlFiles = CMyFile.listFiles(sFilePath, ".xml")) == null || xmlFiles.length == 0) continue;
            FileStore oXMLFile = xmlFiles[0];
            String sXMLFile = oXMLFile.getAbsolutePath();
            XmlObject[] xmlObjects = this.convertXmlFile(sXMLFile, null);
            sFilePath = CMyString.setStrEndWith(sFilePath, File.separatorChar);
            this.importResourceStyles(xmlObjects, sFilePath, _nImportMode, nPageStyleId);
            this.copyImportResourceStylesImgs(sPageStyleName, sFilePath);
            IStyleCenterMgr styleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
            styleCenterMgr.createStyleFile(this.getLoginUser(), currPageStyle);
        }
        CMyFile.deleteDir(sUnZipPath);
        this.m_reports.setTitle("\u4eceZip\u6587\u4ef6\u4e2d\u5bfc\u5165\u8d44\u6e90\u98ce\u683c");
        Object[] successIds = this.m_successIdList.toArray();
        if (successIds.length == 0 && _nImportToPageStyleId > 0) {
            this.m_reports.setTitle("\u6ca1\u6709\u627e\u5230\u5f53\u524d\u9875\u9762\u98ce\u683c\u5bf9\u5e94\u7684\u8d44\u6e90\u98ce\u683c\uff01");
            return this.m_reports;
        }
        int[] nSuccessIds = new int[successIds.length];
        for (int i = 0; i < successIds.length; ++i) {
            nSuccessIds[i] = Integer.parseInt(successIds[i].toString());
        }
        this.m_reports.setResultIds(nSuccessIds);
        return this.m_reports;
    }

    private void copyImportResourceStylesImgs(String sFileName, String sResourceFilePath) throws CMyException {
        String sStylePath = StylePathHelper.getStyleCommonDir(sFileName);
        if (!CMyFile.fileExists(sStylePath)) {
            CMyFile.makeDir(sStylePath, true);
        }
        sStylePath = CMyString.setStrEndWith(sStylePath, File.separatorChar);
        FileService oResourceFilePath = new FileService(sResourceFilePath = CMyString.setStrEndWith(sResourceFilePath, File.separatorChar) + "resource");
        if (!oResourceFilePath.exists()) {
            return;
        }
        FileStore[] oImgFiles = oResourceFilePath.listFiles();
        if (oImgFiles == null) {
            return;
        }
        for (int j = 0; j < oImgFiles.length; ++j) {
            FileStore oImgFile = oImgFiles[j];
            if (!oImgFile.exists()) continue;
            CMyFile.copyFile(oImgFile.getAbsolutePath(), sStylePath + oImgFile.getName());
        }
    }

    private void importResourceStyles(XmlObject[] _xmlObjects, String _sUnZipPageStylePath, int _nImportMode, int _nPageStyleId) throws Exception {
        int[] resultIds = new int[_xmlObjects.length];
        for (int i = 0; i < _xmlObjects.length; ++i) {
            ResourceStyle result = this.importOneResourceStyle(_xmlObjects[i], _sUnZipPageStylePath, _nImportMode, _nPageStyleId);
            if (result == null) continue;
            resultIds[i] = result.getId();
        }
        this.m_reports.setResultIds(resultIds);
    }

    private ResourceStyle importOneResourceStyle(XmlObject _xmlObject, String _sUnZipPageStylePath, int _nImportMode, int _PageStyleId) throws Exception {
        if (_xmlObject == null) {
            return null;
        }
        this.validateXmlObject(_xmlObject);
        ResourceStyle currResourceStyle = (ResourceStyle)_xmlObject.getCurrentObj();
        if (currResourceStyle == null) {
            return null;
        }
        String sResourceStyleName = currResourceStyle.getStyleName();
        currResourceStyle = this.importResourceStyleToPageStyle(currResourceStyle, _xmlObject.getChild(TAG_STYLE_ITEMS), _nImportMode, _sUnZipPageStylePath, _PageStyleId);
        String sPageStyleName = PageStyle.findById(_PageStyleId).getStyleDesc();
        if (currResourceStyle == null) {
            if (_nImportMode == 2) {
                this.m_reports.addWarnedReport("\u5bfc\u5165\u9875\u9762\u98ce\u683c(" + sPageStyleName + ")\u4e0b\u7684\u8d44\u6e90\u98ce\u683c\u3010" + sResourceStyleName + "\u3011\u5931\u8d25\uff0c\u56e0\u4e3a\u5df2\u7ecf\u5b58\u5728\u4e86\u540c\u540d\u7684\u98ce\u683c", null);
                return null;
            }
            this.m_reports.addFailedReport("\u5bfc\u5165\u3010" + sResourceStyleName + "\u3011\u5931\u8d25", new WCMException("\u5bfc\u5165\u98ce\u683c\u5bf9\u8c61\u5931\u8d25\uff01"));
            throw new WCMException("\u5bfc\u5165\u98ce\u683c\u5bf9\u8c61\u5931\u8d25\uff01");
        }
        this.m_reports.addSucessedReport("\u5bfc\u5165\u9875\u9762\u98ce\u683c(" + sPageStyleName + ")\u4e0b\u7684\u8d44\u6e90\u98ce\u683c\u3010" + currResourceStyle.getStyleName() + "\u3011\u6210\u529f\uff01");
        this.m_successIdList.add(currResourceStyle.getId() + "");
        return currResourceStyle;
    }

    private void validateXmlObject(XmlObject _xmlObject) throws WCMException {
        BaseObj currObj = _xmlObject.getCurrentObj();
        if (currObj == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684\u8d44\u6e90\u98ce\u683c\u63cf\u8ff0xml\u6587\u4ef6.");
        }
        if (!(currObj instanceof ResourceStyle)) {
            throw new WCMException("\u5bf9\u8c61\u4e0d\u662f[currObj" + currObj.getClass().getName() + "]\u4e0d\u662fResourceStyle\u5bf9\u8c61\u7c7b\u578b\uff01");
        }
    }

    public ResourceStyle importResourceStyleToPageStyle(ResourceStyle currResourceStyle, XmlObject[] _oStyleItems, int _nImportMode, String _sImportFilePath, int _nImportPageStyleId) throws WCMException {
        String sSourceThumbPath;
        FileService sourceThumbFile;
        if (currResourceStyle == null || _oStyleItems == null) {
            return null;
        }
        int nOldResourceStyleId = currResourceStyle.getPropertyAsInt("RESOURCESTYLEID", 0);
        ResourceStyle oSysResourceStyle = ResourceStyles.findByCssFlagAndPageStyle(this.getLoginUser(), currResourceStyle.getCssFlag(), 0);
        int nSysResourceStyleId = -1;
        if (oSysResourceStyle != null) {
            nSysResourceStyleId = oSysResourceStyle.getId();
        }
        ResourceStyle oSameNameResourceStyle = ResourceStyles.findByCssFlagAndPageStyle(this.getLoginUser(), currResourceStyle.getCssFlag(), _nImportPageStyleId);
        boolean bExistSameNameResourceStyle = false;
        String sThumbName = currResourceStyle.getStyleThumb();
        if (oSameNameResourceStyle != null) {
            bExistSameNameResourceStyle = true;
            switch (_nImportMode) {
                case 2: {
                    return null;
                }
                case 1: {
                    this.m_oStyleItemMgr.delete(this.getLoginUser(), oSameNameResourceStyle);
                    Hashtable<String, Object> properties = currResourceStyle.getAllProperty();
                    properties.remove("RESOURCESTYLEID");
                    properties.remove("SrcResourceStyleId");
                    properties.remove("STYLETHUMB");
                    currResourceStyle = oSameNameResourceStyle;
                    currResourceStyle.setNewProperties(properties);
                    break;
                }
                case 3: {
                    String sCssFlag = StyleRepeatNameHelper.getNewCssFlag(currResourceStyle.getCssFlag(), 2, _nImportPageStyleId);
                    String sStyleName = StyleRepeatNameHelper.getNewName(currResourceStyle.getStyleName(), 2, _nImportPageStyleId);
                    currResourceStyle.setCssFlag(sCssFlag);
                    currResourceStyle.setStyleName(sStyleName);
                    currResourceStyle.setStyleDesc(sStyleName);
                    currResourceStyle.setNextId();
                }
            }
        } else {
            currResourceStyle.setNextId();
            currResourceStyle.setSrcResourceStyleId(nSysResourceStyleId);
        }
        currResourceStyle.setStyleThumb(sThumbName);
        if (!CMyString.isEmpty(sThumbName) && (sourceThumbFile = new FileService(sSourceThumbPath = _sImportFilePath + "thumb" + File.separator + sThumbName)).exists()) {
            String sNewStyleThumbName = this.copyFileIfNeed(sSourceThumbPath, true);
            currResourceStyle.setStyleThumb(sNewStyleThumbName);
        }
        currResourceStyle.setPageStyleId(_nImportPageStyleId);
        User loginUser = this.getLoginUser();
        currResourceStyle.setProperty(PROPERTY_CRUSER, loginUser.getName());
        currResourceStyle.setProperty(PROPERTY_CRTIME, CMyDateTime.now());
        currResourceStyle.save(loginUser);
        this.m_ResourceStyleIds.put(this.makeResourceStyleIdMapKey(1004807208, String.valueOf(nOldResourceStyleId)), new Integer(currResourceStyle.getId()));
        this.importStyleItems(_oStyleItems, this.m_ResourceStyleIds, _nImportMode, bExistSameNameResourceStyle, _nImportPageStyleId);
        oSysResourceStyle = ResourceStyles.findByCssFlagAndPageStyle(this.getLoginUser(), currResourceStyle.getCssFlag(), 0);
        if (oSysResourceStyle == null) {
            this.m_oResourceStyleMgr.copy(ContextHelper.getLoginUser(), null, currResourceStyle);
        } else {
            String sStyleThumb = currResourceStyle.getStyleThumb();
            if (!CMyString.isEmpty(sStyleThumb)) {
                oSysResourceStyle.setStyleThumb(sStyleThumb);
                oSysResourceStyle.save(loginUser);
            }
        }
        return currResourceStyle;
    }

    private void importStyleItems(XmlObject[] _styleItems, Map _IdsMap, int _nImportMode, boolean _bExistSameNameStyle, int _nPageStyleId) throws WCMException {
        for (int i = 0; i < _styleItems.length; ++i) {
            this.importOneStyleItem(_styleItems[i], _IdsMap, _nImportMode, _bExistSameNameStyle, _nPageStyleId);
        }
    }

    private void importOneStyleItem(XmlObject _pageStyleItem, Map _IdsMap, int _nImportMode, boolean _bExistSameNameStyle, int _nPageStyleId) throws WCMException {
        if (_pageStyleItem == null) {
            return;
        }
        if (_IdsMap == null) {
            throw new WCMException("\u4f20\u5165\u7684ids\u6620\u5c04\u5173\u7cfbmap\u4e3anull\uff01");
        }
        if (_bExistSameNameStyle && _nImportMode == 2) {
            return;
        }
        StyleItem aStyleItem = null;
        int nOldStyleItemId = 0;
        try {
            aStyleItem = (StyleItem)_pageStyleItem.getCurrentObj();
            nOldStyleItemId = aStyleItem.getPropertyAsInt("STYLEITEMID", 0);
            int nOldStyleObjType = aStyleItem.getStyleObjType();
            int nOldStyleObjId = aStyleItem.getStyleObjId();
            String sMapKey = this.makeResourceStyleIdMapKey(nOldStyleObjType, String.valueOf(nOldStyleObjId));
            Integer iNewObjId = (Integer)_IdsMap.get(sMapKey);
            if (iNewObjId == null) {
                throw new WCMException("Map\u4e2d[key=" + sMapKey + "]\u5bf9\u5e94\u7684\u98ce\u683cid\u4e0d\u5b58\u5728\uff01");
            }
            aStyleItem.setStyleObjId(iNewObjId);
            aStyleItem.setNextId();
            aStyleItem.removeProperty(PROPERTY_CRTIME);
            aStyleItem.removeProperty(PROPERTY_CRUSER);
            aStyleItem.save(this.getLoginUser());
        }
        catch (Throwable t) {
            String sErrorDesc = "\u5bfc\u5165StyleItem\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25";
            if (aStyleItem != null) {
                sErrorDesc = sErrorDesc + "[\u6e90Id=" + nOldStyleItemId + "]\uff01";
            }
            s_logger.debug((Object)sErrorDesc, t);
            this.m_reports.addWarnedReport(sErrorDesc, t);
        }
    }

    private String getFullName(String _sFile) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(_sFile)) {
            String sPath = filesMan.mapFilePath(_sFile, 0);
            _sFile = sPath + _sFile;
        }
        return _sFile;
    }

    private XmlObject[] convertXmlFile(String _sXmlFile, String _sXslFile) throws WCMException {
        try {
            XmlObject[] xmlObjects = this.m_converter.convertXml(_sXmlFile, _sXslFile, null);
            return xmlObjects;
        }
        catch (Throwable ex) {
            s_logger.debug((Object)"failed to convert xml to object!", ex);
            throw new WCMException("\u8f6c\u6362XML\u6587\u4ef6\u5931\u8d25!\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u9875\u9762\u98ce\u683c\u63cf\u8ff0xml\u6587\u4ef6", ex);
        }
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("XWCMPAGESTYLE", PageStyle.class);
        this.m_converter.registPersistentObj("XWCMRESOURCESTYLE", ResourceStyle.class);
        this.m_converter.registPersistentObj("XWCMCONTENTSTYLE", ContentStyle.class);
        this.m_converter.registPersistentObj("XWCMSTYLEITEM", StyleItem.class);
    }

    private String makeResourceStyleIdMapKey(int _nObjType, String _sObjId) {
        return _nObjType + ":" + _sObjId;
    }

    private void checkFile(String _sFile) throws WCMException {
        if (_sFile == null || _sFile.length() == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u6587\u4ef6\u540d\u65e0\u6548\uff01");
        }
        String sExt = CMyFile.extractFileExt(_sFile);
        if (!"zip".equalsIgnoreCase(sExt)) {
            throw new WCMException("\u53ea\u652f\u6301\u4eceZIP\u6587\u4ef6\u4e2d\u5bfc\u5165!");
        }
    }

    private String copyFileIfNeed(String _sFile, boolean _isPath) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!_isPath) {
            String sFileFlag = filesMan.getFileFlag(_sFile);
            String sNewFileName = _sFile;
            if (sFileFlag != "W0") {
                sNewFileName = filesMan.copyWCMFile(_sFile, "W0");
            }
            return sNewFileName;
        }
        return CMyFile.extractFileName(filesMan.copyFile(_sFile, "W0", true));
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public static void main(String[] args) throws Exception {
        ContextHelper.initContext(User.findByName("admin"));
        String sPath = "D:\\TRS\\TRSWCMV61\\WCMData\\upload\\U0201103\\U020110318\\U020110318473705563421.zip";
        ResourceStyleImporter importer = new ResourceStyleImporter();
        importer.importFromFile("U020110322488147345883.zip", 3, 0);
    }
}

