/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleMgr;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleMgr;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleHelper;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItemMgr;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class PageStyleMgr
implements IPageStyleMgr {
    private static Logger s_logger = Logger.getLogger(PageStyleMgr.class);
    private IStyleItemMgr m_oStyleItemMgr = (StyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");
    private IResourceStyleMgr m_oResourceStyleMgr = (ResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
    private IContentStyleMgr m_oContentStyleMgr = (ContentStyleMgr)DreamFactory.createObjectById("IContentStyleMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public PageStyle copy(User _currUser, PageStyle _sourcePageStyle, PageStyle _targetPageSytle) throws WCMException {
        _targetPageSytle.setSrcPageStyleId(_sourcePageStyle.getId());
        _targetPageSytle.setCustomStyle(_sourcePageStyle.getCustomStyle());
        this.save(_currUser, _targetPageSytle);
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(_sourcePageStyle, null);
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            StyleItem copyStyleItem = (StyleItem)styleItem.cloneToNewObj();
            this.m_oStyleItemMgr.save(_currUser, _targetPageSytle, copyStyleItem);
        }
        ResourceStyles resourceStyles = this.m_oResourceStyleMgr.query(_sourcePageStyle, null);
        for (int i = 0; i < resourceStyles.size(); ++i) {
            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle == null) continue;
            this.m_oResourceStyleMgr.copy(_currUser, _targetPageSytle, resourceStyle);
        }
        ContentStyles contentStyles = this.m_oContentStyleMgr.query(_sourcePageStyle, null);
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null) continue;
            this.m_oContentStyleMgr.copy(_currUser, _targetPageSytle, contentStyle);
        }
        String sStyleName = _sourcePageStyle.getStyleName();
        String sCssPathDir = StylePathHelper.getStyleCssDir();
        if (!CMyFile.fileExists(sCssPathDir)) {
            CMyFile.makeDir(sCssPathDir, true);
        }
        String sSourceCssFile = sCssPathDir + sStyleName + ".css";
        String sDstCssFile = sCssPathDir + _targetPageSytle.getStyleName() + ".css";
        try {
            CMyFile.copyFile(sSourceCssFile, sDstCssFile);
        }
        catch (CMyException e) {
            s_logger.error((Object)e);
            e.printStackTrace();
        }
        return _targetPageSytle;
    }

    @Override
    public void delete(User _currUser, PageStyle pageStyle) throws WCMException {
        if (pageStyle == null) {
            return;
        }
        this.deleteResourceStyleOfPageStyle(pageStyle, _currUser);
        this.deleteContentStyleOfPageStyle(pageStyle, _currUser);
        this.m_oStyleItemMgr.delete(_currUser, pageStyle);
        pageStyle.delete(_currUser);
        this.deletePageStyleCssFile(pageStyle);
    }

    @Override
    public void deletePageStyleInfos(User _currUser, PageStyle pageStyle) throws WCMException {
        if (pageStyle == null) {
            return;
        }
        this.deleteResourceStyleOfPageStyle(pageStyle, _currUser);
        this.deleteContentStyleOfPageStyle(pageStyle, _currUser);
        this.m_oStyleItemMgr.delete(_currUser, pageStyle);
        this.deletePageStyleCssFile(pageStyle);
    }

    @Override
    public PageStyles query(WCMFilter _filter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "PageStyleId!=?", "");
        filter.addSearchValues(0);
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        return PageStyles.openWCMObjs(this.getLoginUser(), filter);
    }

    @Override
    public PageStyle save(User user, PageStyle pageStyle) throws WCMException {
        String sStyleDesc;
        if (pageStyle == null) {
            throw new WCMException("\u8981\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a!PageStyle=[" + pageStyle + "]");
        }
        String sStyleName = pageStyle.isAddMode() ? pageStyle.getPropertyAsString("StyleName") : pageStyle.getNewPropertyAsString("StyleName");
        String string = sStyleDesc = pageStyle.isAddMode() ? pageStyle.getPropertyAsString("StyleDesc") : pageStyle.getNewPropertyAsString("StyleDesc");
        if (this.checkStyleName(pageStyle)) {
            throw new WCMException(1008, "\u5df2\u7ecf\u5b58\u5728\u82f1\u6587\u540d\u79f0\u4e3a[" + sStyleName + "]\u7684\u9875\u9762\u98ce\u683c.");
        }
        if (this.checkStyleDesc(pageStyle)) {
            throw new WCMException(1008, "\u5df2\u7ecf\u5b58\u5728\u663e\u793a\u540d\u79f0\u4e3a[" + sStyleDesc + "]\u7684\u9875\u9762\u98ce\u683c.");
        }
        if (pageStyle.isAddMode()) {
            pageStyle.insert(user);
        } else {
            pageStyle.update(user);
        }
        return pageStyle;
    }

    @Override
    public String makeBaseStyleContent(PageStyle _pageStyle) throws WCMException {
        String sTemplateName;
        String string = sTemplateName = _pageStyle == null ? "body_template_1.css" : _pageStyle.getTemplate();
        if (sTemplateName == null || sTemplateName.equals("")) {
            sTemplateName = "body_template_1.css";
        }
        String sCSSTemplateFile = StyleHelper.getCssTemplateFilePath() + sTemplateName;
        String sCSSTemplateContent = "";
        try {
            sCSSTemplateContent = CMyFile.readFile(sCSSTemplateFile, "utf-8");
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        if (sCSSTemplateContent == null) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + sTemplateName);
        }
        if (sCSSTemplateContent.trim().equals("")) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01" + sTemplateName);
        }
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(_pageStyle, null);
        return StyleHelper.makeCSSContent("", sCSSTemplateContent, styleItems);
    }

    @Override
    public String makePageOtherStyleContent(PageStyle _pageStyle) throws WCMException {
        String sTemplateName = "other_template_1.css";
        String sCSSTemplateFile = StyleHelper.getCssTemplateFilePath() + sTemplateName;
        String sCSSTemplateContent = "";
        try {
            sCSSTemplateContent = CMyFile.readFile(sCSSTemplateFile, "utf-8");
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        if (sCSSTemplateContent == null) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + sTemplateName);
        }
        if (sCSSTemplateContent.trim().equals("")) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01" + sTemplateName);
        }
        StyleItems styleItems = this.m_oStyleItemMgr.queryPageOtherStyleItems(_pageStyle, null);
        return StyleHelper.makeCSSContent("", sCSSTemplateContent, styleItems);
    }

    @Override
    public String previewStyle(PageStyle _pageStyle, StyleItems _styleItems) throws WCMException {
        String sTemplateName;
        String string = sTemplateName = _pageStyle == null ? "body_template_1.css" : _pageStyle.getTemplate();
        if (sTemplateName == null || sTemplateName.equals("")) {
            sTemplateName = "body_template_1.css";
        }
        String sCSSTemplateFile = StyleHelper.getCssTemplateFilePath() + sTemplateName;
        String sCSSTemplateContent = "";
        try {
            sCSSTemplateContent = CMyFile.readFile(sCSSTemplateFile, "utf-8");
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        if (sCSSTemplateContent == null) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + sTemplateName);
        }
        if (sCSSTemplateContent.trim().equals("")) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01" + sTemplateName);
        }
        return StyleHelper.makeCSSContent("", sCSSTemplateContent, _styleItems);
    }

    private void deleteResourceStyleOfPageStyle(PageStyle _pageStyle, User _currUser) throws WCMException {
        if (_pageStyle == null) {
            return;
        }
        ResourceStyles resourceStyles = this.m_oResourceStyleMgr.getResourceStyles(_pageStyle);
        for (int i = 0; i < resourceStyles.size(); ++i) {
            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle == null) continue;
            this.m_oResourceStyleMgr.delete(_currUser, resourceStyle);
        }
    }

    private void deleteContentStyleOfPageStyle(PageStyle _pageStyle, User _currUser) throws WCMException {
        ContentStyles contentStyles = this.m_oContentStyleMgr.queryContenetStyles(_pageStyle);
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null) continue;
            this.m_oContentStyleMgr.delete(_currUser, contentStyle);
        }
    }

    private void deletePageStyleCssFile(PageStyle _pageStyle) throws WCMException {
        String sCssPath = StylePathHelper.getStyleCssDir();
        String sStyleName = _pageStyle.getStyleName();
        String sFilePath = sCssPath + sStyleName + ".css";
        if (CMyFile.fileExists(sFilePath)) {
            CMyFile.deleteFile(sFilePath);
        }
    }

    public boolean checkStyleName(PageStyle _oCurrPageStyle) throws WCMException {
        PageStyles oPageStyles;
        boolean bAddMode = _oCurrPageStyle.isAddMode();
        String sStyleName = null;
        sStyleName = bAddMode ? _oCurrPageStyle.getPropertyAsString("StyleName") : _oCurrPageStyle.getNewPropertyAsString("StyleName");
        if (CMyString.isEmpty(sStyleName)) {
            return false;
        }
        String sWhere = "StyleName=?";
        if (!bAddMode) {
            sWhere = sWhere + " AND PageStyleId<>?";
        }
        WCMFilter oFilter = new WCMFilter("XWCMPAGESTYLE", sWhere, "", "PAGESTYLEID");
        int nStyleId = _oCurrPageStyle.getId();
        oFilter.addSearchValues(sStyleName);
        if (!bAddMode) {
            oFilter.addSearchValues(nStyleId);
        }
        return (oPageStyles = PageStyles.openWCMObjs(ContextHelper.getLoginUser(), oFilter)).size() > 0;
    }

    public boolean checkStyleDesc(PageStyle _oCurrPageStyle) throws WCMException {
        PageStyles oPageStyles;
        boolean bAddMode = _oCurrPageStyle.isAddMode();
        String sStyleDesc = null;
        sStyleDesc = bAddMode ? _oCurrPageStyle.getPropertyAsString("StyleDesc") : _oCurrPageStyle.getNewPropertyAsString("StyleName");
        if (CMyString.isEmpty(sStyleDesc)) {
            return false;
        }
        String sWhere = "StyleDesc=?";
        if (!bAddMode) {
            sWhere = sWhere + " AND PageStyleId<>?";
        }
        WCMFilter oFilter = new WCMFilter("XWCMPAGESTYLE", sWhere, "", "PAGESTYLEID");
        int nStyleId = _oCurrPageStyle.getId();
        oFilter.addSearchValues(sStyleDesc);
        if (!bAddMode) {
            oFilter.addSearchValues(nStyleId);
        }
        return (oPageStyles = PageStyles.openWCMObjs(ContextHelper.getLoginUser(), oFilter)).size() > 0;
    }
}

