/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.template;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;

public class Templates
extends CMSBaseObjs {
    private static final long serialVersionUID = 1L;
    public static final int INPUT_TEMPLATE = 0;
    public static final int DETAIL_TEMPLATE = 1;
    public static final int OUTLINE_TEMPLATE = 2;
    public static final int DEAL_MODE_UPDATE = 1;
    public static final int DEAL_MODE_IGNORE = 2;
    public static final int DEAL_MODE_CHGNAME = 3;
    public static final int DEAL_MODE_QUIT = 4;

    public Templates(User _currUser) {
        super(_currUser);
    }

    public Templates(User _currUser, int initialCapacity, int capacityIncrement) {
        super(_currUser, initialCapacity, capacityIncrement);
    }

    @Override
    protected String getDbTableName() {
        return "WCMTEMPLATE";
    }

    @Override
    public String getIdFieldName() {
        return "TEMPID";
    }

    @Override
    public Class getElementClass() {
        return Template.class;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new Templates(this.currUser);
    }

    public Template findByName(String _sTempName) throws WCMException {
        try {
            if (_sTempName.length() > 0) {
                Template aTemplate = null;
                for (int i = 0; i < this.size(); ++i) {
                    aTemplate = (Template)this.getAt(i);
                    if (aTemplate.getName().compareTo(_sTempName) != 0) continue;
                    return aTemplate;
                }
            }
            return null;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Templates.class, "Templates.label1", "\u901a\u8fc7\u540d\u79f0\u83b7\u5f97\u6a21\u677f\u5bf9\u8c61(Templates.findByName)"), ex);
        }
    }

    public Template getTemplateByName(String _name) {
        if (this.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            Template aTemplate = (Template)this.getAt(i);
            if (aTemplate.getName().compareToIgnoreCase(_name) != 0) continue;
            return aTemplate;
        }
        return null;
    }

    public static final Templates findByIds(User _currUser, String _sIds) throws WCMException {
        if (_sIds.length() <= 0) {
            throw new WCMException(10, I18NMessage.get(Templates.class, "Templates.label2", "\u6307\u5b9a\u5bf9\u8c61ID\u5e8f\u5217\u65e0\u6548\uff01"));
        }
        return (Templates)CMSBaseObjs.findWCMObjsByIds(_currUser, Templates.class, _sIds);
    }

    public static final Templates openWCMObjs(User _currUser, WCMFilter _filter) throws WCMException {
        return (Templates)CMSBaseObjs.openWCMObjs(_currUser, Templates.class, _filter);
    }

    public static Templates createNewInstance(User _currUser) throws WCMException {
        return (Templates)CMSBaseObjs.createInstance(_currUser, Templates.class);
    }
}

