/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import org.apache.log4j.Logger;

public class ThreadPool {
    protected static Logger logger = Logger.getLogger(ThreadPool.class);
    private int m_iSequence = 0;
    private int m_iCurIndex = 0;
    private int m_iMaxLimit = 0;
    private int m_iCurCount = 0;
    private Worker[] m_allWorker = null;

    public int getTotalCount() {
        return this.m_iCurCount;
    }

    public int getIdleCount() {
        return this.m_iCurIndex;
    }

    public int getMaxLimit() {
        return this.m_iMaxLimit;
    }

    protected synchronized int getSequence() {
        return ++this.m_iSequence;
    }

    protected synchronized void workerDestroy(Worker _worker) {
        Worker[] workers = this.m_allWorker;
        if (workers != null) {
            boolean zFound = false;
            for (int i = 0; i < this.m_iCurIndex; ++i) {
                Worker aWorker = workers[i];
                if (zFound) {
                    workers[i - 1] = aWorker;
                    continue;
                }
                if (aWorker != _worker) continue;
                zFound = true;
            }
            if (zFound) {
                --this.m_iCurIndex;
            }
            --this.m_iCurCount;
        }
    }

    private void createWorker(int iToCreate) {
        if (iToCreate > this.m_iMaxLimit) {
            iToCreate = this.m_iMaxLimit;
        }
        for (int i = 0; i < iToCreate; ++i) {
            Worker worker = new Worker();
            worker.start();
            this.m_allWorker[this.m_iCurIndex] = worker;
            ++this.m_iCurIndex;
            ++this.m_iCurCount;
        }
    }

    private synchronized Worker assignWorker() {
        if (this.m_allWorker == null) {
            throw new IllegalStateException("ThreadPool stop");
        }
        while (this.m_iCurIndex == 0 && this.m_iCurCount < this.m_iMaxLimit) {
            this.createWorker(this.m_iMaxLimit - this.m_iCurCount);
        }
        if (this.m_iCurIndex > 0) {
            return this.m_allWorker[--this.m_iCurIndex];
        }
        return null;
    }

    protected synchronized void returnWorker(Worker worker) {
        this.m_allWorker[this.m_iCurIndex] = worker;
        ++this.m_iCurIndex;
        this.notify();
    }

    public synchronized void waitForWorker() {
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void startup(int iMaxLimit) {
        if (this.m_allWorker != null) {
            throw new IllegalStateException("ThreadPool init");
        }
        if (iMaxLimit <= 0) {
            iMaxLimit = 30;
        }
        this.m_iCurIndex = 0;
        this.m_iCurCount = 0;
        this.m_iMaxLimit = iMaxLimit;
        this.m_allWorker = new Worker[iMaxLimit];
        this.createWorker(iMaxLimit);
    }

    public synchronized void cleanup() {
        Worker[] workers = this.m_allWorker;
        if (workers != null) {
            this.m_allWorker = null;
            for (int i = 0; i < this.m_iCurIndex; ++i) {
                workers[i].terminate();
            }
            this.m_iCurIndex = 0;
            this.m_iCurCount = 0;
            this.m_iMaxLimit = 0;
        }
    }

    public boolean runIt(Runnable aRunnable) {
        if (aRunnable == null) {
            throw new NullPointerException("ThreadPool.runit(),aRunnable is null.");
        }
        Worker worker = this.assignWorker();
        if (worker != null) {
            worker.runIt(aRunnable);
            return true;
        }
        return false;
    }

    private class Worker
    extends Thread {
        private Runnable m_oRunnable = null;
        private boolean m_zTerminate = false;
        private boolean m_zHasNewTask = false;

        private Worker() {
            this.setDaemon(true);
            this.setName("ThreadPool$Worker$" + ThreadPool.this.getSequence());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        Worker worker = this;
                        synchronized (worker) {
                            while (!this.m_zTerminate && !this.m_zHasNewTask) {
                                this.wait(1000L);
                            }
                        }
                        if (!this.m_zTerminate) {
                            if (this.m_oRunnable != null) {
                                this.m_oRunnable.run();
                            }
                            if (!this.m_zTerminate) continue;
                        }
                    }
                    catch (Throwable t) {
                        logger.error((Object)"ThreadPool$Worker error", t);
                        continue;
                    }
                    finally {
                        if (!this.m_zHasNewTask) continue;
                        this.m_oRunnable = null;
                        this.m_zHasNewTask = false;
                        ThreadPool.this.returnWorker(this);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                logger.error((Object)"ThreadPool$Worker failed", t);
            }
            finally {
                if (!this.m_zTerminate) {
                    ThreadPool.this.workerDestroy(this);
                }
            }
        }

        protected synchronized void runIt(Runnable aRunnable) {
            this.m_oRunnable = aRunnable;
            this.m_zHasNewTask = true;
            this.notify();
        }

        protected synchronized void terminate() {
            this.m_zTerminate = true;
            this.notify();
        }
    }
}

