/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.OrignHomePublishException;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.domain.publisher.PageGenerator;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.taskdispatch.IPageTask;
import com.trs.components.common.publish.domain.taskdispatch.IPageTaskDispatcher;
import com.trs.components.common.publish.domain.taskdispatch.IPublishProgressMonitor;
import com.trs.components.common.publish.domain.taskdispatch.PageDestoryTask;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.DebugTimer;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class PageTaskWorker
implements Runnable,
IClearable {
    private static final Logger logger = Logger.getLogger(PageTaskWorker.class);
    private static int RUN_INTERVAL = 100;
    private static int SLEEP_EVERY_TASKS = 5;
    private static int threadInitNumber = 1;
    private IPageTaskDispatcher m_dispatcher;
    private boolean m_bCanceled = false;
    private int m_nFinishedTaskCount;
    private boolean m_bHasWarnings = false;
    private PublishTaskContext m_publishTaskContext = null;
    private IPublishProgressMonitor m_oProgressMonitor = null;
    private String m_sWorkerName = "PageTaskWorker-" + PageTaskWorker.nextThreadNum();
    private boolean m_zStarted;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public PageTaskWorker(IPageTaskDispatcher _dispatcher, PublishTaskContext _publishTaskContext) {
        this(_dispatcher, _publishTaskContext, null);
    }

    public PageTaskWorker(IPageTaskDispatcher _dispatcher, PublishTaskContext _publishTaskContext, IPublishProgressMonitor _monitor) {
        this.m_dispatcher = _dispatcher;
        this.m_publishTaskContext = _publishTaskContext;
        this.m_oProgressMonitor = _monitor;
    }

    public void clear() {
        if (this.m_oProgressMonitor != null) {
            this.m_oProgressMonitor.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        PageTaskWorker pageTaskWorker = this;
        synchronized (pageTaskWorker) {
            this.m_bCanceled = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log2Monitor(I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label1", "\u7ebf\u7a0b\u542f\u52a8"));
        DebugTimer aTimer = new DebugTimer();
        IPageTask task = null;
        int nResult = 10;
        try {
            ContextHelper.setLoginUser(User.getSystem());
            this.m_nFinishedTaskCount = 0;
            this.m_bHasWarnings = false;
            while (!this.m_bCanceled) {
                task = this.m_dispatcher.getNextPageTask();
                if (task == null) {
                    logger.debug((Object)"no page task found");
                    break;
                }
                if (this.m_bCanceled) {
                    return;
                }
                this.log2Monitor(I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label2", "\u83b7\u53d6\u65b0\u7684\u9875\u9762\u4efb\u52a1\uff0c\u51c6\u5907\u6267\u884c"));
                aTimer.start();
                nResult = this.executeTask(task);
                aTimer.stop();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("publish the page[" + task.getInfo() + "] use [" + aTimer.getTime() + "]ms"));
                }
                if (PublishConstants.isTaskFailed(nResult)) {
                    return;
                }
                ++this.m_nFinishedTaskCount;
                this.m_dispatcher.notifyPageTaskFinished(task);
                if (this.m_bCanceled) {
                    return;
                }
                if (SLEEP_EVERY_TASKS <= 0 || this.m_nFinishedTaskCount % SLEEP_EVERY_TASKS != 0 || RUN_INTERVAL <= 0) continue;
                try {
                    Thread.sleep(RUN_INTERVAL);
                }
                catch (Exception exception) {}
            }
            nResult = this.m_bHasWarnings ? 6 : 7;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[" + this.getName() + "] Result=" + nResult));
            }
            this.log2Monitor(I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label3", "\u7ebf\u7a0b\u7ed3\u675f"));
            this.m_dispatcher.notifyPageTaskWorkerFinished(nResult);
            ContextHelper.clear();
            ContextHelper.setLoginUser(User.getSystem());
        }
    }

    private void addLog(IPageTask _task, int _nResult, String _sErrorDetail) {
        try {
            User currUser = ContextHelper.getLoginUser();
            PublishTask publishTask = this.m_publishTaskContext.getTask();
            publishTask.addErrorLog(currUser, _task.getPublishElement(), _task.getInfo(), _nResult, _sErrorDetail);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to add error log for page publish task!", (Throwable)ex);
        }
    }

    private int executeTask(IPageTask _pageTask) {
        int nResult;
        String sErrorLog;
        block15: {
            sErrorLog = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[" + this.getName() + "] to execute " + _pageTask.getInfo()));
                }
                if (_pageTask instanceof PageDestoryTask) {
                    this.log2Monitor(I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label4", "\u64a4\u9500\u53d1\u5e03:") + _pageTask.getPublishElement().getInfo());
                    if (!_pageTask.getPublishElement().isFolder()) {
                        IPublishContent content = (IPublishContent)_pageTask.getPublishElement();
                        PageDestroyer.withdraw(content, this.m_publishTaskContext);
                        content.setPublishStatus(10);
                        content.setPublishTimeAndURL(null, null);
                    }
                    nResult = 7;
                    break block15;
                }
                PublishPageContext pageContext = new PublishPageContext(_pageTask.getPublishElement(), this.m_publishTaskContext, this.m_oProgressMonitor);
                if (!_pageTask.getPublishElement().isFolder()) {
                    String msg = I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label5", "\u5728[") + _pageTask.getPublishElement().getFolder().getInfo() + I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label6", "]\u4e2d\u4ea7\u751f[") + _pageTask.getPublishElement().getInfo() + I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label7", "]\u7ec6\u89c8\u9875\u9762....");
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)msg);
                    }
                    this.log2Monitor(msg);
                    try {
                        PageGenerator.generateDetail(pageContext);
                    }
                    catch (OrignHomePublishException e) {
                        logger.error((Object)I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label8", "\u5f15\u7528\u89e6\u53d1\u539f\u59cb\u53d1\u5e03\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
                        pageContext.addErrorLog(9, e.getMessage(), e);
                    }
                    catch (Exception ex) {
                        logger.error((Object)(I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label5", "\u5728[") + _pageTask.getPublishElement().getFolder().getInfo() + I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label6", "]\u4e2d\u4ea7\u751f[") + _pageTask.getPublishElement().getInfo() + I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label9", "]\u7ec6\u89c8\u9875\u9762\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)ex);
                        throw ex;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label5", "\u5728[") + _pageTask.getPublishElement().getFolder().getInfo() + I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label6", "]\u4e2d\u4ea7\u751f[") + _pageTask.getPublishElement().getInfo() + I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label10", "]\u7ec6\u89c8\u9875\u9762\u7ed3\u675f\uff01")));
                    }
                    this.log2Monitor(I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label5", "\u5728[") + _pageTask.getPublishElement().getFolder().getInfo() + I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label6", "]\u4e2d\u4ea7\u751f[") + _pageTask.getPublishElement().getInfo() + I18NMessage.get(PageTaskWorker.class, "PageTaskWorker.label10", "]\u7ec6\u89c8\u9875\u9762\u7ed3\u675f\uff01"));
                } else {
                    PageGenerator.generateOutlines(pageContext);
                }
                if (pageContext.hasWarnings()) {
                    nResult = 6;
                    sErrorLog = pageContext.getWarnings();
                    this.m_bHasWarnings = true;
                } else {
                    nResult = 7;
                }
            }
            catch (Throwable ex) {
                nResult = 9;
                sErrorLog = CMyException.getStackTraceText(ex);
                logger.error((Object)sErrorLog, ex);
            }
        }
        if (sErrorLog != null) {
            logger.error((Object)sErrorLog);
            this.addLog(_pageTask, nResult, sErrorLog);
        }
        return nResult;
    }

    private void log2Monitor(String msg) {
        if (this.m_oProgressMonitor != null) {
            this.m_oProgressMonitor.info(msg);
        }
    }

    public IPublishProgressMonitor getProgressMonitor() {
        return this.m_oProgressMonitor;
    }

    public String getName() {
        return this.m_sWorkerName;
    }

    public void start() {
        if (!this.m_zStarted) {
            new Thread(this).start();
            this.m_zStarted = true;
        }
    }
}

