/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.util.CMyDateTime;

public class TagParserDateTime
implements ITagParser {
    private TagItem m_tagItem = null;
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_DATETIME");
            tbi.setDesc("TRS_DATETIME");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DATEFORMAT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("yyyy-MM-dd");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) {
        boolean isInMillis = _context.getAttribute("InMillis", false);
        if (isInMillis) {
            return new String[]{String.valueOf(System.currentTimeMillis())};
        }
        String sDateFormat = TagParseHelper.parseDateFormat(_context.getAttribute("DATEFORMAT"));
        String sLocaleId = _context.getAttribute("LOCALE");
        String sTimeZoneId = _context.getAttribute("TIMEZONE");
        String sResult = CMyDateTime.now().toString(sDateFormat, sLocaleId, sTimeZoneId);
        return new String[]{sResult};
    }
}

