/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.calendar;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.calendar.EventMgr;
import com.trs.components.common.calendar.EventShare;
import com.trs.components.common.calendar.EventShares;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseIdsMan;
import com.trs.infra.common.WCMException;

public class EventShareIdsMan
extends BaseIdsMan {
    private EventShares m_existsShares;
    private EventMgr m_eventMgr;
    private int m_nSharerType;
    private Event m_event;

    protected EventShareIdsMan() {
    }

    public EventShareIdsMan(int _nEventId, int _nSharerType) throws WCMException {
        this.assertValidSharerType(_nSharerType);
        this.m_nSharerType = _nSharerType;
        this.m_event = Event.findById(_nEventId);
        this.m_eventMgr = (EventMgr)DreamFactory.createObjectById("EventMgr");
        this.m_existsShares = this.m_eventMgr.getEventShares(_nEventId, _nSharerType);
    }

    private void assertValidSharerType(int _nSharerType) throws WCMException {
        if (204 != _nSharerType && 201 != _nSharerType) {
            throw new WCMException(10, I18NMessage.get(EventShareIdsMan.class, "EventShareIdsMan.label1", "\u65e0\u6548\u7684\u65e5\u7a0b\u5171\u4eab\u8005\u7c7b\u578b!"));
        }
    }

    @Override
    protected int getExistsSize() {
        return this.m_existsShares.size();
    }

    @Override
    protected int getExistsIdAt(int _nExistsIndex) {
        return ((EventShare)this.m_existsShares.getAt(_nExistsIndex)).getId();
    }

    @Override
    protected void deleteExists(int _nExistsIndex) throws WCMException {
        this.m_existsShares.removeAt(_nExistsIndex);
    }

    @Override
    protected void addRelation(int _nNewId) throws WCMException {
        CMSObj sharer = null;
        sharer = 204 == this.m_nSharerType ? User.findById(_nNewId) : Group.findById(_nNewId);
        if (sharer == null) {
            return;
        }
        this.m_eventMgr.shareTo(this.m_event, sharer);
    }
}

