/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.address;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.address.Contact;
import com.trs.components.common.address.ContactGrps;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ContactGrp
extends CMSObj {
    public static final int OBJ_TYPE = 305;
    public static final String DB_TABLE_NAME = "WCMCONTGROUP";
    public static final String DB_ID_NAME = "GROUPID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 305;
    }

    public String getName() {
        return (String)this.getProperty("GNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("GNAME", _name);
    }

    public String getDesc() {
        return (String)this.getProperty("GDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("GDESC", _desc);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public boolean setEmail(String _email) throws WCMException {
        return this.setProperty("EMAIL", _email);
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public ContactGrp getParent() throws WCMException {
        WCMFilter filter = new WCMFilter("", "GroupId=" + this.getParentId(), "");
        ContactGrps contactGrps = new ContactGrps(User.getSystem(), 1, 1);
        ContactGrp contactGrpParent = null;
        try {
            contactGrps.open(filter);
            contactGrpParent = contactGrps.isEmpty() ? null : (ContactGrp)contactGrps.getAt(0);
            contactGrps.clear();
            return contactGrpParent;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(ContactGrp.class, "ContactGrp.label1", "\u83b7\u53d6\u7236\u5bf9\u8c61\u65f6\u5931\u8d25\uff08ContactGrp.getParent\uff09"), ex);
        }
    }

    public boolean setParent(int _parentId) throws WCMException {
        if (_parentId < 0) {
            throw new WCMException(1104, I18NMessage.get(ContactGrp.class, "ContactGrp.label2", "ParentId\u503c\u65e0\u6548(ContactGrp.setParentId)"));
        }
        return this.setProperty("PARENTID", _parentId);
    }

    public boolean setParent(ContactGrp _parent) throws WCMException {
        if (_parent == null) {
            return this.setParent(0);
        }
        if (!_parent.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(ContactGrp.class, "ContactGrp.label3", "\u65e0\u6548\u7684\u7236\u5bf9\u8c61\uff08ContactGrp.setParent\uff09"));
        }
        return this.setParent(_parent.getId());
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        Number iParentId = null;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("GNAME");
            iParentId = (Number)this.getAllProperty().get("PARENTID");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(ContactGrp.class, "ContactGrp.label4", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(ContactGrp.isValid)"));
            }
            if (iParentId == null) {
                throw new WCMException(1106, I18NMessage.get(ContactGrp.class, "ContactGrp.label5", "\u5c5e\u6027ParentId\u6ca1\u6709\u8bbe\u7f6e(ContactGrp.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(ContactGrp.class, "ContactGrp.label6", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ContactGrp.isValid)"));
            }
            sName = (String)this.getNewProperty("GNAME");
            iParentId = (Number)this.getNewProperty("PARENTID");
            if (sName != null && iParentId == null) {
                iParentId = (Number)this.getAllProperty().get("PARENTID");
            }
            if (iParentId != null && sName == null) {
                sName = (String)this.getAllProperty().get("GNAME");
            }
        }
        if (sName != null || iParentId != null) {
            String strCondition = "ParentId=" + iParentId + " and GName='" + CMyString.filterForSQL(sName) + "'";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(strCondition = strCondition + " and CrUser='" + this.getCrUserName() + "'")) {
                throw new WCMException(1108, I18NMessage.get(ContactGrp.class, "ContactGrp.label7", "\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff08ContactGrp.isValid\uff09"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public ContactGrps getChildren() throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=" + this.getId(), "");
        ContactGrps contactGrps = new ContactGrps(User.getSystem());
        try {
            contactGrps.open(filter);
            return contactGrps;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(ContactGrp.class, "ContactGrp.label8", "\u83b7\u53d6\u5b50\u5bf9\u8c61\u65f6\u5931\u8d25\uff08ContactGrp.getChildren\uff09"), ex);
        }
    }

    public boolean addContact(Contact _Contact2, User _opUser) throws WCMException {
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsCount = null;
        Statement oPreStmt = null;
        if (_Contact2 == null || !_Contact2.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(ContactGrp.class, "ContactGrp.label9", "\u8981\u52a0\u5165\u7684\u975e\u7cfb\u7edf\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08ContactGrp.addContact\uff09"));
        }
        if (_opUser == null || !_opUser.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(ContactGrp.class, "ContactGrp.label10", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08ContactGrp.addContact\uff09"));
        }
        int contactId = _Contact2.getId();
        boolean blExists = false;
        try {
            oConn = this.getDBManager().getConnection();
            String strSQL = "select count(*) from wcmContGrpMap where ContGrpId=" + this.getId() + " and ContactId=" + contactId;
            oStmt = oConn.createStatement();
            rsCount = oStmt.executeQuery(strSQL);
            rsCount.next();
            blExists = rsCount.getInt(1) > 0;
            rsCount.close();
            if (blExists) {
                boolean bl = false;
                return bl;
            }
            strSQL = "insert into wcmContGrpMap(ContGrpId,ContactId,CrUser,CrTime) values(?,?,?,?)";
            CMyDateTime crTime = new CMyDateTime();
            crTime.setDateTimeWithCurrentTime();
            oPreStmt = oConn.prepareStatement(strSQL);
            oPreStmt.setInt(1, this.getId());
            oPreStmt.setInt(2, contactId);
            oPreStmt.setString(3, _opUser.getName());
            oPreStmt.setTimestamp(4, crTime.toTimestamp());
            oPreStmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(ContactGrp.class, "ContactGrp.label11", "\u6dfb\u52a0\u6307\u5b9a\u975e\u7cfb\u7edf\u7528\u6237\u5230\u975e\u7cfb\u7edf\u7528\u6237\u7ec4\u65f6\u51fa\u9519\uff08ContactGrp.addContact\uff09"), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(ContactGrp.class, "ContactGrp.label11", "\u6dfb\u52a0\u6307\u5b9a\u975e\u7cfb\u7edf\u7528\u6237\u5230\u975e\u7cfb\u7edf\u7528\u6237\u7ec4\u65f6\u51fa\u9519\uff08ContactGrp.addContact\uff09"), ex);
        }
        finally {
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeContact(Contact _Contact2, User _opUser) throws WCMException {
        Statement oStmt;
        Connection oConn;
        block15: {
            boolean bl;
            block16: {
                oConn = null;
                oStmt = null;
                if (_Contact2 == null) throw new WCMException(1100, I18NMessage.get(ContactGrp.class, "ContactGrp.label12", "\u8981\u4ece\u975e\u7cfb\u7edf\u7528\u6237\u7ec4\u4e2d\u5220\u9664\u7684\u975e\u7cfb\u7edf\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08ContactGrp.removeContact\uff09"));
                if (!_Contact2.isValidInstance()) {
                    throw new WCMException(1100, I18NMessage.get(ContactGrp.class, "ContactGrp.label12", "\u8981\u4ece\u975e\u7cfb\u7edf\u7528\u6237\u7ec4\u4e2d\u5220\u9664\u7684\u975e\u7cfb\u7edf\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08ContactGrp.removeContact\uff09"));
                }
                if (_opUser == null) throw new WCMException(1100, I18NMessage.get(ContactGrp.class, "ContactGrp.label13", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08ContactGrp.removeContact\uff09"));
                if (!_opUser.isValidInstance()) {
                    throw new WCMException(1100, I18NMessage.get(ContactGrp.class, "ContactGrp.label13", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08ContactGrp.removeContact\uff09"));
                }
                try {
                    String strSQL = "delete from wcmContGrpMap where ContGrpId=" + this.getId() + " and ContactId=" + _Contact2.getId();
                    oConn = this.getDBManager().getConnection();
                    oStmt = oConn.createStatement();
                    int nDelCount = oStmt.executeUpdate(strSQL);
                    if (nDelCount != 0) break block15;
                    bl = false;
                    if (oStmt == null) break block16;
                }
                catch (SQLException ex) {
                    try {
                        throw new WCMException(40, I18NMessage.get(ContactGrp.class, "ContactGrp.label14", "\u4ece\u975e\u7cfb\u7edf\u7528\u6237\u7ec4\u4e2d\u5220\u9664\u975e\u7cfb\u7edf\u7528\u6237\u5bf9\u8c61\u65f6\u5931\u8d25\uff08ContactGrp.removeContact\uff09"), ex);
                        catch (Exception ex2) {
                            throw new WCMException(0, I18NMessage.get(ContactGrp.class, "ContactGrp.label14", "\u4ece\u975e\u7cfb\u7edf\u7528\u6237\u7ec4\u4e2d\u5220\u9664\u975e\u7cfb\u7edf\u7528\u6237\u5bf9\u8c61\u65f6\u5931\u8d25\uff08ContactGrp.removeContact\uff09"), ex2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (oStmt != null) {
                            try {
                                oStmt.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (oConn == null) throw throwable;
                        this.getDBManager().freeConnection(oConn);
                        throw throwable;
                    }
                }
                try {
                    oStmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (oConn == null) return bl;
            this.getDBManager().freeConnection(oConn);
            return bl;
        }
        if (oStmt != null) {
            try {
                oStmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (oConn == null) return true;
        this.getDBManager().freeConnection(oConn);
        return true;
    }

    public static final ContactGrp findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (ContactGrp)BaseObj.findById(ContactGrp.class, _nId);
    }

    public static final ContactGrp createNewInstance() throws WCMException {
        return (ContactGrp)BaseObj.createNewInstance(ContactGrp.class);
    }

    public static final ContactGrp findByKey(Object _oKey) throws WCMException {
        return (ContactGrp)BaseObj.findByKey(ContactGrp.class, _oKey);
    }
}

