/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.definition.OptMarkParseException;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FlowOptMarkEnumParser {
    private static Logger logger = Logger.getLogger(FlowOptMarkEnumParser.class);

    private FlowOptMarkEnumParser() {
    }

    public static String getFlowOptMarkEnum(Flow _flow) throws WCMException {
        if (_flow == null) {
            return null;
        }
        FlowNode startNode = _flow.getStartNode();
        FlowNode EndNode = _flow.getEndNode();
        StringBuffer sb = new StringBuffer("{");
        sb.append(startNode.getName()).append(",");
        try {
            ArrayList arrangedNodes = new ArrayList(4);
            sb.append(FlowOptMarkEnumParser.arrangeOptMarkEnum(startNode, arrangedNodes)).append(",");
            arrangedNodes.clear();
            arrangedNodes = null;
        }
        catch (OptMarkParseException ex) {
            logger.warn((Object)(I18NMessage.get(FlowOptMarkEnumParser.class, "FlowOptMarkEnumParser.label1", "\u89e3\u6790\u5de5\u4f5c\u6d41\u7684\u64cd\u4f5c\u6807\u7b7e\u65f6[ID=") + _flow.getId() + " " + _flow.getName() + I18NMessage.get(FlowOptMarkEnumParser.class, "FlowOptMarkEnumParser.label2", "]\u51fa\u73b0\u95ee\u9898\u3002") + ex.getMessage()));
            return null;
        }
        sb.append(EndNode.getName());
        sb.append("}");
        String result = sb.toString();
        sb.setLength(0);
        return result;
    }

    private static String arrangeOptMarkEnum(FlowNode _node, List arrangedNodes) throws WCMException {
        if (_node == null || _node.isEndNode()) {
            return null;
        }
        if (arrangedNodes.contains(_node.getName())) {
            return null;
        }
        arrangedNodes.add(_node.getName());
        FlowNodeBranchs branches = _node.getBranchs(FlowOptMarkEnumParser.getLoginUser());
        int nBranchsCount = branches.size();
        if (nBranchsCount == 0) {
            throw new OptMarkParseException(I18NMessage.get(FlowOptMarkEnumParser.class, "FlowOptMarkEnumParser.label3", "\u8282\u70b9[") + _node.getName() + I18NMessage.get(FlowOptMarkEnumParser.class, "FlowOptMarkEnumParser.label4", "]\u6ca1\u6709\u5b9a\u4e49\u4efb\u4f55\u652f\u8def\uff01"));
        }
        String result = "";
        ArrayList<String> arrOptMarks = new ArrayList<String>();
        for (int i = 0; i < nBranchsCount; ++i) {
            FlowNodeBranch branch = (FlowNodeBranch)branches.getAt(i);
            FlowNode currNode = branch.getNode();
            String sTemp = "";
            if (!branch.isOperationMarkEnable()) {
                sTemp = FlowOptMarkEnumParser.arrangeOptMarkEnum(branch.getNextNode(FlowOptMarkEnumParser.getLoginUser()), arrangedNodes);
            } else {
                sTemp = branch.getOperationMark();
                if (currNode != null) {
                    FlowNode nextNode = branch.getNextNode(FlowOptMarkEnumParser.getLoginUser());
                    String sNextNodeStr = null;
                    if (nextNode != null && (sNextNodeStr = FlowOptMarkEnumParser.arrangeOptMarkEnum(nextNode, arrangedNodes)) != null) {
                        sTemp = sTemp + (sTemp == null ? sNextNodeStr : "," + sNextNodeStr);
                    }
                }
            }
            if (CMyString.isEmpty(sTemp)) continue;
            if (nBranchsCount > 1) {
                sTemp = "{" + sTemp + "}";
            }
            arrOptMarks.add(sTemp);
        }
        result = nBranchsCount == 1 ? CMyString.join(arrOptMarks, ",") : "[" + CMyString.join(arrOptMarks, ",") + "]";
        return result;
    }

    private static User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

