/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.GroupRoleMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.service.IUserService;

public class RoleAuthServer {
    public static boolean hasRight(User _loginUser, Role _role, int _nRightIndex) throws WCMException {
        if (_loginUser == null) {
            return false;
        }
        IUserService aUserService = (IUserService)DreamFactory.createObjectById("IUserService");
        GroupRoleMgr groupRoleMgr = new GroupRoleMgr();
        boolean isAdmin = _loginUser.isSecurityAdmin();
        if (isAdmin) {
            return true;
        }
        boolean isRoleMgr = aUserService.isManagerOfRole(_loginUser);
        boolean isGroupMgr = true;
        boolean bCrByAdmin = _role.getCrUser().isSecurityAdmin();
        Groups groupsOfRole = groupRoleMgr.getGroups(Role.findById(_role.getId()), null);
        Group currGroup = new Group();
        if (groupsOfRole == null) {
            return false;
        }
        Group tmpGroup = null;
        for (int i = 0; i < groupsOfRole.size(); ++i) {
            currGroup = (Group)groupsOfRole.getAt(i);
            if (currGroup.isAdministrator(_loginUser)) continue;
            tmpGroup = currGroup.getParent();
            if (tmpGroup == null) {
                isGroupMgr = false;
                break;
            }
            if (tmpGroup.isAdministrator(_loginUser)) continue;
            isGroupMgr = false;
            break;
        }
        boolean bCanEdit = isAdmin || isRoleMgr && isGroupMgr && !bCrByAdmin;
        boolean bCanDelete = isAdmin || isRoleMgr && isGroupMgr && !bCrByAdmin;
        boolean bCanManageUser = isAdmin || isRoleMgr;
        int nRightIndex = _nRightIndex;
        switch (nRightIndex) {
            case 11: {
                if (!bCanEdit) break;
                return true;
            }
            case 12: {
                if (!bCanDelete) break;
                return true;
            }
            case 13: 
            case 14: {
                if (!bCanManageUser) break;
                return true;
            }
        }
        return false;
    }
}

