/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.infra.util.CMyMemory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class RightCacheMgr
implements ICacheMgr {
    private static Logger logger = Logger.getLogger(RightCacheMgr.class);
    public static int MAX_RIGHT_CACHE_SIZE = 3000;
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");
    private final String kEY_RIGHT_CACHE = "m_hRightCache";
    private final String KEY_EXISTS_CACHE = "m_listRightObjExistsCache";
    private static final String HAS_OTHER_RIGHT_SQL = "select RightId from WCMRight where RightId<>? and ObjType=? and ObjId=?";
    private int m_nRightCount = 0;

    private String getKey() {
        return RightCacheMgr.class.getName();
    }

    private String getKey(String name) {
        return RightCacheMgr.class.getName() + "." + name;
    }

    public RightValue getRightValue(int _objType, int _objId, int _oprType, int _oprId) throws WCMException {
        if (_objId <= 0 || _oprId <= 0) {
            return null;
        }
        Long lRightValue = (Long)cache.get(this.getRightCacheKey(_objType, _objId, _oprType, _oprId));
        if (lRightValue == null) {
            return null;
        }
        return new RightValue(lRightValue);
    }

    public long getRightValue(int _objType, int _objId, int _oprType, int _oprId, long _lDefaultValue) throws WCMException {
        if (_objId <= 0 || _oprId <= 0) {
            return _lDefaultValue;
        }
        Long lRightValue = (Long)cache.get(this.getRightCacheKey(_objType, _objId, _oprType, _oprId));
        if (lRightValue == null) {
            return _lDefaultValue;
        }
        return lRightValue;
    }

    public boolean isExistsRight(int _nObjType, int _nObjId) throws WCMException {
        if (!"true".equals((String)cache.get(this.getKey()))) {
            this.init();
        }
        return cache.exists(this.getExitsRightKey(_nObjType, _nObjId));
    }

    private String getExitsRightKey(int _nObjType, int _nObjId) {
        String key1 = this.getKey("m_listRightObjExistsCache");
        String key2 = this.makeRightExistsCacheKey(_nObjType, _nObjId);
        return key1 + key2;
    }

    private String getRightCacheKey(int _nObjType, int _nObjId, int _nOperType, int _nOperId) {
        String key1 = this.getKey("m_hRightCache");
        String key2 = this.makeKey(_nObjType, _nObjId, _nOperType, _nOperId);
        return key1 + key2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        RightCacheMgr rightCacheMgr = this;
        synchronized (rightCacheMgr) {
            if (cache.exists(this.getKey()).booleanValue()) {
                return true;
            }
            cache.set(this.getKey(), "true");
            logger.info((Object)(I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label1", "\u542f\u52a8[\u6743\u9650\u7f13\u51b2]\u524d\u7cfb\u7edf\u5185\u5b58\u72b6\u51b5\uff1a") + CMyMemory.toMemoryInfo()));
            logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label2", "\u6b63\u5728\u542f\u52a8\u6743\u9650\u7f13\u51b2\u670d\u52a1\u5668..."));
            this.m_nRightCount = DBManager.getDBManager().sqlExecuteIntQuery("select count(*) from WCMRight");
            this.initRightObjExistCache();
            logger.info((Object)(I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label3", "\u542f\u52a8[\u6743\u9650\u662f\u5426\u8bbe\u7f6e]\u540e\u7cfb\u7edf\u5185\u5b58\u72b6\u51b5\uff1a") + CMyMemory.toMemoryInfo()));
            this.initRightCache();
            logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label4", "\u542f\u52a8\u6743\u9650\u7f13\u51b2\u670d\u52a1\u5668\u6210\u529f\uff01"));
            logger.info((Object)(I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label5", "\u542f\u52a8[\u6743\u9650\u7f13\u51b2]\u540e\u7cfb\u7edf\u5185\u5b58\u72b6\u51b5\uff1a") + CMyMemory.toMemoryInfo()));
        }
        return true;
    }

    private void initRightObjExistCache() throws WCMException {
        String SQL = "select distinct OBJTYPE, OBJID from WCMRight";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("select distinct OBJTYPE, OBJID from WCMRight");
            oPreStmt.setFetchSize(1000);
            result = oPreStmt.executeQuery();
            while (result.next()) {
                int i1 = result.getInt(1);
                int i2 = result.getInt(2);
                cache.set(this.getExitsRightKey(i1, i2), "1");
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to Desc!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
            logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label7", "\u521d\u59cb\u5316[RightObjExistCache]\u5b8c\u6210\uff01"));
        }
    }

    private void initRightCache() throws WCMException {
        String SQL = "select ObjType, ObjId, OprType, OprId, RightValue from WCMRight";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("select ObjType, ObjId, OprType, OprId, RightValue from WCMRight");
            oPreStmt.setFetchSize(1000);
            result = oPreStmt.executeQuery();
            while (result.next()) {
                int objType = result.getInt("ObjType");
                int objId = result.getInt("ObjId");
                int oprType = result.getInt("OprType");
                int oprId = result.getInt("OprId");
                cache.set(this.getRightCacheKey(objType, objId, oprType, oprId), new Long(result.getLong("RightValue")));
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to Desc!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
            logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label8", "\u521d\u59cb\u5316[RightCache]\u5b8c\u6210\uff01"));
        }
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        this.init();
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        int nObjId;
        Right newRight = (Right)_oObjAdded;
        if (newRight == null) {
            return;
        }
        int nObjType = newRight.getObjType();
        if (!this.isExistsRight(nObjType, nObjId = newRight.getObjId())) {
            cache.set(this.getExitsRightKey(nObjType, nObjId), "1");
        }
        this.putRightInCache(newRight);
    }

    private String makeRightExistsCacheKey(int _nObjType, int _nObjId) {
        StringBuffer sbKey = new StringBuffer(18);
        sbKey.append(_nObjType);
        sbKey.append("_");
        sbKey.append(_nObjId);
        return sbKey.toString();
    }

    private void putRightInCache(Right _aRight) throws WCMException {
        String sKey = this.getRightCacheKey(_aRight.getObjType(), _aRight.getObjId(), _aRight.getOperatorType(), _aRight.getOperatorId());
        Object objValue = _aRight.getNewProperty("RIGHTVALUE");
        Long longRightValue = null;
        if (objValue == null) {
            longRightValue = new Long(_aRight.getValueAsLong());
        } else {
            long newRightValue = ((Number)objValue).longValue();
            longRightValue = new Long(newRightValue);
        }
        cache.set(sKey, longRightValue);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        Right delRight = (Right)_oObjDeleted;
        if (delRight == null) {
            return;
        }
        if (this.isExistsRight(delRight.getObjType(), delRight.getObjId())) {
            int[] pSQLArgs = new int[]{delRight.getId(), delRight.getObjType(), delRight.getObjId()};
            DBManager dbMgr = DBManager.getDBManager();
            if (dbMgr.sqlExecuteIntQuery(HAS_OTHER_RIGHT_SQL, pSQLArgs) < 0) {
                cache.clear(this.getExitsRightKey(delRight.getObjType(), delRight.getObjId()));
            }
        }
        cache.clear(this.getRightCacheKey(delRight.getObjType(), delRight.getObjId(), delRight.getOperatorType(), delRight.getOperatorId()));
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof Right)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label11", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label12", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        this.putRightInCache((Right)_oObjModified);
    }

    private String makeKey(int _nObjType, int _nObjId, int _nOperType, int _nOperId) {
        return _nObjType + "_" + _nObjId + "_" + _nOperType + "_" + _nOperId;
    }
}

