/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.exception.ClientTransferException;
import com.trs.idm.exception.IdMException;
import com.trs.idm.interact.agent.AgentBase;
import com.trs.idm.interact.agent.ClientTransferManager;
import com.trs.idm.interact.agent.TransferResult;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AgentV2
extends AgentBase {
    private static final Logger LOG = Logger.getLogger(AgentV2.class);
    private ClientTransferManager clientTransferManager;

    public AgentV2(String cfgFile) throws IdMException {
        super(cfgFile);
    }

    @Override
    protected TransferResult doTransfer(byte[] request) throws IOException, ClientTransferException {
        return this.clientTransferManager.doTransfer(request);
    }

    @Override
    protected TransferResult doTransfer(byte[] request, String nodeKey) throws IOException, ClientTransferException {
        return this.clientTransferManager.doTransfer(request, nodeKey);
    }

    @Override
    protected void onLoadProperties() {
    }

    @Override
    protected void onStart() {
        this.clientTransferManager = new ClientTransferManager(this);
        this.clientTransferManager.start();
        this.beforeInit();
        this.clientTransferManager.init();
        this.getGlobalLoginUrl();
        this.getSameDomainSSOInfoFromIDS();
        this.getOriginalClientIPHttpHeaderTokenFromIDS();
        this.getIdmServerCharset();
    }

    protected void beforeInit() {
        if (this.shouldNotifyIdsToAddCoApp()) {
            this.notifyIdsToAddCoApp();
            this.notifyIdsToConfigGroupSync();
            this.notifyIdsToConfigUserSync();
        }
    }

    @Override
    protected void onStop() {
        this.clientTransferManager.stop();
    }

    public ClientTransferManager getClientTransferManager() {
        return this.clientTransferManager;
    }

    @Override
    public boolean isSocketAlive() {
        if (this.clientTransferManager == null) {
            LOG.error((Object)"clientTransferManager==null! so just return false.");
            return false;
        }
        return this.clientTransferManager.isSocketAliveNow();
    }

    public long currentIdleQueueSize() {
        if (this.clientTransferManager == null) {
            return -1L;
        }
        return this.clientTransferManager.currentIdleSize();
    }

    public long currentBusyQueueSize() {
        if (this.clientTransferManager == null) {
            return -1L;
        }
        return this.clientTransferManager.currentBusySize();
    }

    public long currentErrorQueueSize() {
        if (this.clientTransferManager == null) {
            return -1L;
        }
        return this.clientTransferManager.currentErrorSize();
    }

    public String currentSocketStatus() {
        if (this.clientTransferManager == null) {
            return "clientTransferManager is null!";
        }
        return this.clientTransferManager.currentSocketsStatus();
    }

    public int getTimeoutedSessionIdSize() {
        return this.asyncNotifier.getTimeoutedSessionIds().size();
    }

    public int getNotifyFailedSessionIdSize() {
        return this.asyncNotifier.getNotifyFailedSessionIds().size();
    }

    public void resetTimeoutedSessionId() {
        this.asyncNotifier.getTimeoutedSessionIds().clear();
    }

    public int getMaxAllowTimeOutSessionIdNumber() {
        return this.asyncNotifier.getMaxAllowSessionIdNumber();
    }

    @Override
    public String[] getHosts() {
        return this.hostIPs;
    }
}

