/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.interact.protocol.ProtocolConst;
import com.trs.idm.util.StringHelper;
import java.util.Map;

public class LoginResult {
    private boolean success;
    private int failCode = 1000;
    private String failInfo;
    private String failInfoCode;
    private String failInfoMessage;
    private SSOUser ssoUser;
    private String sdToken;

    public String getFailInfo() {
        return this.failInfo;
    }

    public void setFailInfo(String failInfo) {
        Map map;
        this.failInfo = failInfo;
        if (this.hasCodeAndMessage(failInfo) && (map = this.extractCodeAndeMessage(failInfo)) != null) {
            this.failInfoCode = (String)map.get(ProtocolConst.RESP_CODE);
            this.failInfoMessage = (String)map.get(ProtocolConst.RESP_MESSAGE);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getFailCode() {
        return this.failCode;
    }

    public void setFailCode(int failCode) {
        this.failCode = failCode;
    }

    public String getFailInfoCode() {
        return this.failInfoCode;
    }

    public void setFailInfoCode(String failInfoCode) {
        this.failInfoCode = failInfoCode;
    }

    public String getFailInfoMessage() {
        return this.failInfoMessage;
    }

    public void setFailInfoMessage(String failInfoMessage) {
        this.failInfoMessage = failInfoMessage;
    }

    private boolean hasCodeAndMessage(String failInfo) {
        boolean result = false;
        if (failInfo == null || "".equals(failInfo)) {
            return false;
        }
        try {
            if (failInfo.indexOf(String.valueOf(ProtocolConst.RESP_CODE) + ":") >= 0 || failInfo.indexOf(String.valueOf(ProtocolConst.RESP_MESSAGE) + ":") >= 0) {
                result = true;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private Map extractCodeAndeMessage(String failInfo) {
        if (StringHelper.isEmpty(failInfo)) {
            return null;
        }
        Map map = StringHelper.String2Map(failInfo, ";", ":");
        return map;
    }

    public SSOUser getSSOUser() {
        return this.ssoUser;
    }

    public void setSSOUser(SSOUser ssoUser) {
        this.ssoUser = ssoUser;
    }

    public String getSdToken() {
        return this.sdToken;
    }

    public void setSdToken(String sdToken) {
        this.sdToken = sdToken;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("success: ").append(this.success).append("; ");
        str.append("old failInfo: ").append(this.failInfo).append("; ");
        str.append("old failCode: ").append(this.failCode).append("; ");
        str.append("new failCode: ").append(this.failInfoCode).append("; ");
        str.append("new failInfo: ").append(this.failInfoMessage).append("; ");
        str.append("sdToken: ").append(this.sdToken).append("; ");
        str.append("ssoUser: ").append(this.ssoUser);
        return str.toString();
    }
}

