/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.actor.v2;

import com.trs.idm.client.actor.ActorException;
import com.trs.idm.client.actor.FormValues;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.actor.v2.IServletAppActorV2;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.StringHelper;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PagedServletAppActor
implements IServletAppActorV2 {
    private static final Logger LOG = Logger.getLogger(PagedServletAppActor.class);
    public static final String SESSION_LOGIN_FLAG = "pageActor.sessionLoginFlag";
    public static final String HANDLE_UPDATE_USER_PAGE = "pageActor.handleUpdateUserPage";
    public static final String HANDLE_DEL_USER_PAGE = "pageActor.handleDelUserPage";
    public static final String HANDLE_ADD_USER_PAGE = "pageActor.handleAddUserPage";
    public static final String HANDLE_LOGOUT_PAGE = "pageActor.handleLogoutPage";
    public static final String HANDLE_LOGIN_PAGE = "pageActor.handleLoginPage";
    public static final String LOGIN_INPUT_NAME_KEY = "sso.selfLoginPage.userName.field";
    public static final String LOGIN_INPUT_PASSWORD_KEY = "sso.selfLoginPage.password.field";
    public static final String PAGE_ACTION_RESULT = "trsids_pageActionResult";
    public static final String DEFAULT_LOGIN_FLAG = "loginUser";
    public static final String SSOUSER_FLAG = "ssoUser";
    private String handleLoginPage;
    private String handleLogoutPage;
    private String handleAddUserPage;
    private String handleDelUserPage;
    private String handleUpdateUserPage;
    private String agentName;
    private Properties props;
    private String sessionLoginFlag;

    public PagedServletAppActor() throws Exception {
        this.loadProps();
    }

    private void loadProps() throws Exception {
        this.props = PropertyUtil.assertAndLoadFromResource(PagedServletAppActor.class, "/trsids-agent.properties");
        this.handleLoginPage = PropertyUtil.getTrimString(this.props, HANDLE_LOGIN_PAGE, "/pageactor/handleLoginPage.jsp");
        this.handleLogoutPage = PropertyUtil.getTrimString(this.props, HANDLE_LOGOUT_PAGE, "/pageactor/handleLogoutPage.jsp");
        this.handleAddUserPage = PropertyUtil.getTrimString(this.props, HANDLE_ADD_USER_PAGE, "/pageactor/handleAddUserPage.jsp");
        this.handleDelUserPage = PropertyUtil.getTrimString(this.props, HANDLE_DEL_USER_PAGE, "/pageactor/handleDelUserPage.jsp");
        this.handleUpdateUserPage = PropertyUtil.getTrimString(this.props, HANDLE_UPDATE_USER_PAGE, "/pageactor/handleUpdateUserPage.jsp");
        this.sessionLoginFlag = PropertyUtil.getTrimString(this.props, SESSION_LOGIN_FLAG, DEFAULT_LOGIN_FLAG);
        LOG.info((Object)("page actor info: handleLoginPage:" + this.handleLoginPage + ", handleLogoutPage:" + this.handleLogoutPage + ", handleAddUserPage:" + this.handleAddUserPage + ", handleDelUserPage:" + this.handleDelUserPage + ",handleUpdateUserPage:" + this.handleUpdateUserPage + ", sessionLoginFlag:" + this.sessionLoginFlag));
    }

    public String getSessionId(HttpServletRequest request, HttpServletResponse response, boolean create) throws ActorException {
        return request.getSession().getId();
    }

    public boolean checkLocalLogin(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        try {
            return request.getSession().getAttribute(this.sessionLoginFlag) != null;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void loadLoginUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        request.setAttribute(SSOUSER_FLAG, (Object)user);
        LOG.info((Object)("user begin login by pageActor, userInfo:" + user + ", is committed?" + response.isCommitted()));
        try {
            request.getRequestDispatcher(this.handleLoginPage).forward((ServletRequest)request, (ServletResponse)response);
            LOG.info((Object)("user login success by pageActor, userInfo:" + user + ", is committed?" + response.isCommitted()));
        }
        catch (Exception e) {
            LOG.error((Object)("coapp login, session id: " + request.getSession().getId() + "ssoUser:" + user + ",error:"), (Throwable)e);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        LOG.info((Object)("user begin logout by pageActor, HttpResponse is committed? " + response.isCommitted()));
        try {
            request.getRequestDispatcher(this.handleLogoutPage).forward((ServletRequest)request, (ServletResponse)response);
            LOG.info((Object)("user begin logout by pageActor, HttpResponse is committed? " + response.isCommitted()));
        }
        catch (Exception e) {
            LOG.error((Object)"coapp logout, error:", (Throwable)e);
        }
        if (response.isCommitted()) {
            return;
        }
    }

    public FormValues extractExtraInput(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        return null;
    }

    public String extractUserName(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        String nameKey = request.getParameter(LOGIN_INPUT_NAME_KEY);
        String result = request.getParameter(StringHelper.isEmpty(nameKey) ? "userName" : nameKey);
        LOG.info((Object)("extract submitted userName, userName : " + result + ", name key:" + nameKey));
        return result == null ? "" : result;
    }

    public String extractUserPwd(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        String passwordKey = request.getParameter(LOGIN_INPUT_PASSWORD_KEY);
        String result = request.getParameter(StringHelper.isEmpty(passwordKey) ? "password" : passwordKey);
        LOG.info((Object)("extract submitted password, password: notVisible, password key:" + passwordKey));
        return result == null ? "" : result;
    }

    public void loadAnonymous(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"load anonymous");
        }
    }

    public boolean addUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        LOG.info((Object)("coapp begin add user by pageActor,userInfo:" + user + ", HttpResponse is committed? " + response.isCommitted()));
        request.setAttribute(SSOUSER_FLAG, (Object)user);
        request.setAttribute(PAGE_ACTION_RESULT, (Object)(String.valueOf(this.agentName) + "addUser"));
        try {
            request.getRequestDispatcher(this.handleAddUserPage).forward((ServletRequest)request, (ServletResponse)response);
            LOG.info((Object)("coapp add user success by pageActor,userInfo:" + user + ", HttpResponse is committed? " + response.isCommitted()));
        }
        catch (Exception e) {
            LOG.error((Object)"add user fail ,error:", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean updateUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        LOG.info((Object)("coapp begin update user by pageActor,userInfo:" + user + ", HttpResponse is committed? " + response.isCommitted()));
        request.setAttribute(SSOUSER_FLAG, (Object)user);
        request.setAttribute(PAGE_ACTION_RESULT, (Object)(String.valueOf(this.agentName) + "updUser"));
        try {
            request.getRequestDispatcher(this.handleUpdateUserPage).forward((ServletRequest)request, (ServletResponse)response);
            LOG.info((Object)("coapp update user success by pageActor,userInfo:" + user + ", HttpResponse is committed? " + response.isCommitted()));
        }
        catch (Exception e) {
            LOG.error((Object)"update user fail ,error:", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean removeUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        LOG.info((Object)("coapp begin delete user by pageActor,userInfo:" + user + ", HttpResponse is committed? " + response.isCommitted()));
        request.setAttribute(SSOUSER_FLAG, (Object)user);
        request.setAttribute(PAGE_ACTION_RESULT, (Object)(String.valueOf(this.agentName) + "delUser"));
        try {
            request.getRequestDispatcher(this.handleDelUserPage).forward((ServletRequest)request, (ServletResponse)response);
            LOG.info((Object)("coapp delete user success by pageActor,userInfo:" + user + ", HttpResponse is committed? " + response.isCommitted()));
        }
        catch (Exception e) {
            LOG.error((Object)"remove user fail ,error:", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean unremoveUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        return true;
    }

    public boolean disableUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        return true;
    }

    public boolean enableUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        return true;
    }

    public boolean userExist(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        return true;
    }

    public boolean useStandardHttpSession() {
        return true;
    }

    public boolean addGroup(HttpServletRequest request, HttpServletResponse response, SSOGroup group) {
        return true;
    }

    public boolean updateGroup(HttpServletRequest request, HttpServletResponse response, SSOGroup group) {
        return true;
    }

    public boolean delGroup(HttpServletRequest request, HttpServletResponse response, SSOGroup group) {
        return true;
    }

    public boolean moveToGroup(HttpServletRequest request, HttpServletResponse response, SSOUser user, SSOGroup group) throws ActorException {
        return true;
    }

    public boolean removeFromGroup(HttpServletRequest request, HttpServletResponse response, SSOUser user, SSOGroup group) throws ActorException {
        return true;
    }

    public void start(ServletContext application) {
    }

    public void stop() {
    }
}

