/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.actor;

import com.trs.idm.client.IWebCoAppActor;
import com.trs.idm.client.actor.ActorException;
import com.trs.idm.client.actor.FormValues;
import com.trs.idm.client.actor.IServletAppActor;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public final class LegacyActorAdapter
implements IServletAppActor {
    private IWebCoAppActor legacyActor;
    private String legacyActorClassName;
    private static final Logger LOG = Logger.getLogger(LegacyActorAdapter.class);

    public LegacyActorAdapter(IWebCoAppActor legacyActor) {
        if (legacyActor == null) {
            throw new IllegalArgumentException("legacyActor is null!");
        }
        this.legacyActorClassName = legacyActor.getClass().getName();
        this.legacyActor = legacyActor;
    }

    public void start(ServletContext application) {
        LOG.info((Object)("actor start, application" + application));
    }

    public void stop(ServletContext application) {
        LOG.info((Object)("actor stop, application:" + application));
    }

    public boolean addUser(SSOUser user, HttpServletRequest request) throws ActorException {
        return this.legacyActor.addUser(user.getUserName(), user.getProperties(), request);
    }

    public boolean checkLocalLogin(HttpServletRequest request) throws ActorException {
        return this.legacyActor.checkLocalLogin(request.getSession()) || this.legacyActor.canPass(request);
    }

    public boolean disableUser(SSOUser user) throws ActorException {
        throw new ActorException("legacyActor not implement disableUser()!");
    }

    public boolean enableUser(SSOUser user) throws ActorException {
        throw new ActorException("legacyActor not implement enableUser()!");
    }

    public FormValues extractExtraInput(HttpServletRequest request) throws ActorException {
        String sourceName = request.getParameter("sourceName");
        FormValues values = new FormValues();
        values.put("sourceName", sourceName);
        return values;
    }

    public String extractUserName(HttpServletRequest request) throws ActorException {
        return this.legacyActor.extractUserName(request);
    }

    public String extractUserPwd(HttpServletRequest request) throws ActorException {
        return this.legacyActor.extractUserPwd(request);
    }

    public void loadAnonymous(HttpServletRequest request) throws ActorException {
        this.legacyActor.loadAnonymous(request);
    }

    public void loadLoginUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        this.legacyActor.loadUserInfoToSession(user.getProperties(), request.getSession(), request);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        this.legacyActor.logout(request.getSession());
    }

    public boolean removeUser(SSOUser user, HttpServletRequest request) throws ActorException {
        return this.legacyActor.removeUser(user.getUserName(), request);
    }

    public boolean unremoveUser(SSOUser user, HttpServletRequest request) throws ActorException {
        throw new ActorException("legacyActor not implement unremoveUser()!");
    }

    public boolean updateUser(SSOUser user, HttpServletRequest request) throws ActorException {
        return this.legacyActor.updateUser(user.getUserName(), user.getProperties(), request);
    }

    public boolean userExist(SSOUser user) throws ActorException {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(160);
        sb.append("legacyActorClassName=").append(this.legacyActorClassName);
        sb.append("; legacyActor=").append(this.legacyActor);
        sb.append(". this=").append(super.toString());
        return sb.toString();
    }

    public String getSessionId(HttpServletRequest request, HttpServletResponse response, boolean create) throws ActorException {
        HttpSession session = request.getSession(create);
        if (session == null) {
            return null;
        }
        return session.getId();
    }

    public boolean useStandardHttpSession() {
        return true;
    }

    public boolean addGroup(SSOGroup group, HttpServletRequest req) {
        throw new ActorException("legacyActor not implement addGroup(),class name:" + this.legacyActorClassName);
    }

    public boolean delGroup(SSOGroup group, HttpServletRequest req) {
        throw new ActorException("legacyActor not implement delGroup(),class name:" + this.legacyActorClassName);
    }

    public boolean updateGroup(SSOGroup group, HttpServletRequest req) {
        throw new ActorException("legacyActor not implement updateGroup(),class name:" + this.legacyActorClassName);
    }

    public boolean moveToGroup(SSOUser user, SSOGroup group) throws ActorException {
        throw new ActorException("legacyActor not implement moveToGroup(),class name:" + this.legacyActorClassName);
    }

    public boolean removeFromGroup(SSOUser user, SSOGroup group) throws ActorException {
        throw new ActorException("legacyActor not implement removeFromGroup(),class name:" + this.legacyActorClassName);
    }

    public void stop() {
    }
}

