/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.ArrayUtil;
import com.trs.dev4.jdk16.utils.ReflectUtil;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONBuilder {
    JSONObject jsonObj = new JSONObject();
    private static final String[] ALLFIELDS = new String[]{"*"};

    public JSONBuilder add(String key, int value) {
        try {
            this.jsonObj.put(key, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public JSONBuilder add(String key, Object value) {
        try {
            this.jsonObj.put(key, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public JSONBuilder addArray(String key, List<?> values) {
        return this.addArray(key, values, "*");
    }

    public JSONBuilder addArray(String key, List<?> values, String ... selectedFields) {
        if (selectedFields.length == 0) {
            selectedFields = ALLFIELDS;
        }
        try {
            JSONArray ary = new JSONArray();
            for (Object obj : values) {
                if (ArrayUtil.equals(ALLFIELDS, selectedFields)) {
                    selectedFields = ReflectUtil.getAllFieldName(obj.getClass());
                }
                JSONArray aryObj = new JSONArray();
                int i = 0;
                while (i < selectedFields.length) {
                    aryObj.put(ReflectUtil.getFieldValue(obj, selectedFields[i]));
                    ++i;
                }
                ary.put((Object)aryObj);
            }
            this.jsonObj.put(key, (Object)ary);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String toJSONObjString() {
        return this.jsonObj.toString();
    }
}

