/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.EnvConst;
import com.trs.dev4.jdk16.utils.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static boolean equalsRegardlessOfOrder(List<? extends Object> lst, List<? extends Object> lst2) {
        if (lst == null || lst2 == null) {
            return lst == lst2;
        }
        return lst.containsAll(lst2) && lst2.containsAll(lst);
    }

    public static List<?> lastSubList(List<?> origin, int count) {
        if (origin == null || count <= 0) {
            return origin;
        }
        if (origin.size() < count) {
            count = origin.size();
        }
        return origin.subList(origin.size() - count, origin.size());
    }

    public static List<?> subList(List<?> origin, int count) {
        if (origin == null || count <= 0) {
            return origin;
        }
        if (origin.size() < count) {
            count = origin.size();
        }
        return origin.subList(0, count);
    }

    public static String lastSublines(List<String> output, int count) {
        List<String> lastLines = CollectionUtil.lastSubList(output, count);
        return CollectionUtil.toLines(lastLines);
    }

    public static String sublines(List<String> output, int count) {
        List<String> lastLines = CollectionUtil.subList(output, count);
        return CollectionUtil.toLines(lastLines);
    }

    public static <K, V> String toString(Map<K, V> map) {
        if (map == null) {
            return "null";
        }
        int maxIndex = map.size() - 1;
        if (maxIndex < 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(maxIndex + 1).append(" elements in " + map.getClass().getName() + ": {");
        int i = 0;
        for (K key : map.keySet()) {
            sb.append(EnvConst.NEWLINE);
            sb.append(++i).append(":\t").append(key).append(" = ").append(map.get(key));
        }
        sb.append("}");
        return sb.toString();
    }

    public static <T> String toString(Collection<T> list) {
        if (list == null) {
            return "null";
        }
        int maxIndex = list.size() - 1;
        if (maxIndex < 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(maxIndex + 1).append(" elements in " + list.getClass().getName() + ": {");
        int i = 0;
        for (T t : list) {
            sb.append(EnvConst.NEWLINE);
            sb.append(++i).append(":\t").append(t);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String toLines(List<String> lastLines) {
        if (lastLines == null) {
            return null;
        }
        int size = lastLines.size();
        if (size == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(80 * size);
        if (size == 1) {
            sb.append(lastLines.get(0));
            return sb.toString();
        }
        int i = 1;
        while (i < size) {
            sb.append(EnvConst.NEWLINE).append(lastLines.get(i));
            ++i;
        }
        return sb.toString();
    }

    public static boolean isEmpty(Collection<?> objs) {
        return objs == null || objs.size() == 0;
    }

    public static boolean isNotEmpty(Collection<?> objs) {
        return objs != null && objs.size() > 0;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    public static <T> List<T> popSubList(List<T> originList, int fromIndex, int toIndex) {
        List<T> subList = originList.subList(fromIndex, toIndex);
        ArrayList<T> result = new ArrayList<T>(subList);
        subList.clear();
        return result;
    }

    public static <T> List<T> popFirstSubList(List<T> originList, T fromObj, T toObj) {
        int fromIndex = originList.indexOf(fromObj);
        if (fromIndex == -1) {
            return null;
        }
        int toIndex = originList.indexOf(toObj) + 1;
        if (toIndex == 0) {
            return null;
        }
        return CollectionUtil.popSubList(originList, fromIndex, toIndex);
    }

    public static <T> List<List<T>> popAllSubList(List<T> originList, T fromObj, T toObj) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        List<T> subList = CollectionUtil.popFirstSubList(originList, fromObj, toObj);
        while (CollectionUtil.isNotEmpty(subList)) {
            result.add(subList);
            subList = CollectionUtil.popFirstSubList(originList, fromObj, toObj);
        }
        return result;
    }

    public static <K, V> int getValueAsInt(Map<K, V> map, String key, int defVal) {
        if (CollectionUtil.isEmpty(map)) {
            return defVal;
        }
        V val = map.get(key);
        return NumberUtil.parseInt(val, defVal);
    }
}

