/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.exec;

import com.trs.dev4.jdk16.exec.ProcessHelper;
import com.trs.dev4.jdk16.utils.AssertUtil;
import java.io.File;
import java.util.List;
import java.util.Map;

public class ExecuteResult {
    private ProcessHelper ph;

    public ExecuteResult(ProcessHelper ph) {
        AssertUtil.notNull(ph, "ProcessHelper is null!");
        this.ph = ph;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExecuteResult [");
        builder.append(this.ph);
        builder.append("]");
        return builder.toString();
    }

    public String getCommand() {
        return this.ph.getCmd();
    }

    public int getExitValue() {
        return this.ph.getExitValue();
    }

    public File getWorkDir() {
        return this.ph.getActualWorkDir();
    }

    public Map<String, String> getEnv() {
        return this.ph.getActualEnv();
    }

    public long getEstimatedTimeMillis() {
        return this.ph.getEstimatedTimeMillis();
    }

    public long getStartTime() {
        return this.ph.getStartTime();
    }

    public long getEndTime() {
        return this.ph.getEndTime();
    }

    public List<String> getOutput() {
        return this.ph.getStdOut();
    }

    public List<String> getErrorOutput() {
        return this.ph.getStdErr();
    }

    public boolean hasStdoutOutput() {
        return this.ph.hasStdOutput();
    }

    public boolean hasStderrOutput() {
        return this.ph.hasErrorOutput();
    }

    public String firstLinesOfStdout(int count) {
        return this.ph.sublinesOfStdout(count);
    }

    public String firstLinesOfStderr(int count) {
        return this.ph.sublinesOfStderr(count);
    }

    public String lastLinesOfStdout(int count) {
        return this.ph.lastSublinesOfStdout(count);
    }

    public String lastLinesOfStderr(int count) {
        return this.ph.lastSublinesOdStderr(count);
    }
}

