/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.actionlog.impl;

import com.trs.dev4.jdk16.actionlog.IActionlogManager;
import com.trs.dev4.jdk16.actionlog.LogEnums;
import com.trs.dev4.jdk16.actionlog.annotation.LogMe;
import com.trs.dev4.jdk16.actionlog.impl.Actionlog;
import com.trs.dev4.jdk16.model.IEntity;
import com.trs.dev4.jdk16.utils.ArrayUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ActionlogAspectHandler {
    protected static Logger logger = Logger.getLogger(ActionlogAspectHandler.class);
    @Autowired
    private IActionlogManager actionLogManager;

    @Pointcut(value="execution(* * ..*Service*.*(..))")
    public void service() {
    }

    @Pointcut(value="@annotation(logme)", argNames="logme")
    public void annolog(LogMe logme) {
    }

    @Around(value="(service() && annolog(logme))", argNames="logme")
    public Object aroundAnnoLog(ProceedingJoinPoint jointPoint, LogMe logMeAnno) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("aroundAnnoLog(method:" + jointPoint.getSignature() + " is method signature:" + (jointPoint.getSignature() instanceof MethodSignature) + ",args:" + StringHelper.join(jointPoint.getArgs())));
        }
        if (!this.checkAccess((JoinPoint)jointPoint)) {
            return this.execute(jointPoint);
        }
        MethodSignature methodSignature = (MethodSignature)jointPoint.getSignature();
        Method method = methodSignature.getMethod();
        Object targetObject = this.findTargetObject((JoinPoint)jointPoint, logMeAnno);
        if (targetObject == null) {
            logger.debug((Object)("targetObject is null.method:" + method.getName()));
            return this.execute(jointPoint);
        }
        String targetObjectName = String.valueOf(targetObject.getClass().getSimpleName().toLowerCase()) + ".";
        if (!IEntity.class.isInstance(targetObject)) {
            targetObjectName = "";
        }
        String operationName = logMeAnno.action().getSimpleName().toLowerCase();
        String loggingKey = String.valueOf(StringHelper.uncapitalize(targetObjectName)) + StringHelper.uncapitalize(operationName);
        Object operator = this.findOperator((JoinPoint)jointPoint, logMeAnno);
        logger.debug((Object)("targetobject(" + targetObject + "),operator(" + operator + "),operationName(" + operationName + "),loggingKey(" + loggingKey + ")."));
        long lStartTime = System.currentTimeMillis();
        Actionlog actionLog = null;
        try {
            actionLog = this.actionLogManager.createActionlog(operator, targetObject, loggingKey, LogEnums.Result.SUCCESS, lStartTime, 0L, "trsuc");
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (actionLog == null) {
            logger.error((Object)("Execute joinPoint(" + actionLog + ") without actionlog."));
            return this.execute(jointPoint);
        }
        try {
            Object object = this.execute(jointPoint);
            return object;
        }
        catch (Throwable tx) {
            logger.error((Object)("LOG error:" + tx.getMessage()), tx);
            this.recordException(tx, actionLog);
            throw tx;
        }
        finally {
            long lEndTime = System.currentTimeMillis();
            actionLog.setSpentTime(lEndTime - lStartTime);
            this.recordArguments(jointPoint, actionLog);
            this.actionLogManager.saveOrUpdate(actionLog);
        }
    }

    void recordArguments(ProceedingJoinPoint jointPoint, Actionlog actionLog) {
        Object[] args = jointPoint.getArgs();
        Object[] logArgs = new Object[]{"", "", ""};
        int index = 0;
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (!IEntity.class.isInstance(arg)) {
                logArgs[index++] = this.castArgValue(arg);
                if (index >= 3) break;
            }
            ++n2;
        }
        actionLog.setOperArgs(logArgs);
    }

    void recordException(Throwable error, Actionlog actionLog) {
        actionLog.setResult(LogEnums.Result.FAIL);
        String errorMessage = error.getMessage();
        if (errorMessage != null && errorMessage.length() > 2000) {
            errorMessage = StringHelper.adjustLength(errorMessage, 1800);
        }
        actionLog.setErrorMsg(errorMessage);
    }

    private Object castArgValue(Object arg) {
        Object value = arg;
        if (int[].class.isInstance(arg)) {
            value = StringHelper.join(ArrayUtil.toIntegerArray((int[])arg));
        } else if (arg.getClass().isArray()) {
            value = StringHelper.join((Object[])arg);
        }
        return value;
    }

    private Object execute(ProceedingJoinPoint jointPoint) throws Throwable {
        return jointPoint.proceed(jointPoint.getArgs());
    }

    private Object findOperator(JoinPoint jointPoint, LogMe logMeAnno) {
        Object[] args = jointPoint.getArgs();
        int operatorIndex = logMeAnno.operatorIndex();
        if (operatorIndex < args.length && operatorIndex >= 0) {
            logger.debug((Object)("LogMe() found operator(" + args[operatorIndex] + ") by index(" + operatorIndex + ")."));
            return args[operatorIndex];
        }
        logger.debug((Object)("LogMe(" + logMeAnno + ") not found operator by index(" + operatorIndex + ")."));
        return null;
    }

    private Object findTargetObject(JoinPoint jointPoint, LogMe logMeAnno) throws InstantiationException, IllegalAccessException {
        Object[] args = jointPoint.getArgs();
        int targetIndex = logMeAnno.targetIndex();
        if (targetIndex < args.length && targetIndex >= 0) {
            logger.debug((Object)("LogMe() found operator(" + args[targetIndex] + ") by index(" + targetIndex + ")."));
            return args[targetIndex];
        }
        logger.debug((Object)("LogMe(" + logMeAnno + ") not found operator by index(" + targetIndex + ")."));
        return null;
    }

    boolean checkAccess(JoinPoint jointPoint) {
        if (this.actionLogManager == null) {
            return false;
        }
        if (!(jointPoint.getSignature() instanceof MethodSignature)) {
            return false;
        }
        return !(jointPoint.getTarget() instanceof IActionlogManager);
    }
}

