/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cms.impl;

import com.trs.dev4.jdk16.cms.IContentGenerator;
import com.trs.dev4.jdk16.cms.IPublishable;
import com.trs.dev4.jdk16.cms.ITagParser;
import com.trs.dev4.jdk16.cms.ITemplateManager;
import com.trs.dev4.jdk16.cms.PageContext;
import com.trs.dev4.jdk16.cms.TemplateDocument;
import com.trs.dev4.jdk16.cms.impl.PageContent;
import com.trs.dev4.jdk16.cms.impl.TagContext;
import com.trs.dev4.jdk16.cms.impl.TagItem;
import com.trs.dev4.jdk16.dao.PagedList;
import com.trs.dev4.jdk16.utils.CollectionUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ContentGenerator
implements IContentGenerator {
    private Map<String, ITagParser> parsers = new HashMap<String, ITagParser>();
    private static final Logger LOG = Logger.getLogger(ContentGenerator.class);
    private ITemplateManager templateManager;

    @Override
    public ITagParser getParser(String tagName) {
        return this.parsers.get(tagName);
    }

    @Override
    public void registerParser(ITagParser tagParser) {
        this.parsers.put(tagParser.getBeanInfo().getName(), tagParser);
    }

    @Override
    public void unregisterParser(String tagName) {
        this.parsers.remove(tagName);
    }

    @Override
    public String generate(String templateName, PageContext pageContext) {
        if (StringHelper.isEmpty(templateName)) {
            return "";
        }
        TemplateDocument templateDoc = this.templateManager.getTemplateDocument(templateName);
        if (templateDoc == null) {
            return "";
        }
        return this.generate(templateDoc, pageContext);
    }

    public void setTemplateManager(ITemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    @Override
    public String generate(TemplateDocument templateDoc, PageContext pageContext) {
        PageContent pageContent = new PageContent();
        int i = 0;
        while (i < templateDoc.getItemCount()) {
            TagItem currentTag = templateDoc.getItemAt(i);
            if (currentTag != null) {
                TagContext tagContext = new TagContext(pageContext, currentTag);
                this.parseTag(currentTag, pageContent, pageContext, tagContext);
            }
            ++i;
        }
        return pageContent.merge();
    }

    protected void parseTag(TagItem currentTag, PageContent pageContent, PageContext pageContext, TagContext tagContext) {
        String tagName = currentTag.getName();
        if (StringHelper.isEmpty(tagName)) {
            pageContent.add(currentTag);
            return;
        }
        ITagParser tagParser = this.getParser(tagName);
        pageContent.add(new TagItem(tagParser.parse(currentTag, tagContext)));
    }

    @Override
    public String parseObjects(PagedList<IPublishable> objects, TagItem currentTag, TagContext tagContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("tagItem: " + tagContext + "\ntagContext: " + tagContext));
            LOG.debug((Object)("tagParser.pagedObjects: " + objects));
            LOG.debug((Object)("tagItem.getChildren: " + CollectionUtil.toString(currentTag.getChildren())));
        }
        PageContent childrenContent = new PageContent();
        for (IPublishable entity : objects.getPageItems()) {
            for (TagItem childTag : currentTag.getChildren()) {
                if (StringHelper.isEmpty(childTag.getName())) {
                    childrenContent.add(childTag);
                    continue;
                }
                TagContext entityTagContext = new TagContext(tagContext, currentTag);
                entityTagContext.setEntity(entity);
                this.parseTag(childTag, childrenContent, entityTagContext.getPageContext(), entityTagContext);
            }
        }
        return childrenContent.merge();
    }
}

