/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.Moment;
import org.junit.Assert;
import org.junit.Test;

public class MomentTest {
    private static final long LONG_MS_20101201 = 1291132800000L;

    @Test
    public void testConstructor() {
        this.valueIsCorrect(1291132800000L, 2010, 12, 1, 0, 0, 0, 0);
        this.valueIsWrong(1291132800000L, 2010, 1, 1, 0, 0, 0, 0);
        this.valueIsFail(2010, 0, 0, 0, 0, 0, 0);
        this.valueIsFail(2010, -1, 1, 0, 0, 0, 0);
        this.valueIsFail(2010, 12, 40, 0, 0, 0, 0);
    }

    void valueIsCorrect(long milliSeconds, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        Moment moment = new Moment(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        Assert.assertEquals((long)milliSeconds, (long)moment.getTimeMillis());
    }

    void valueIsWrong(long milliSeconds, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        Moment moment = new Moment(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        Assert.assertFalse((milliSeconds == moment.getTimeMillis() ? 1 : 0) != 0);
    }

    void valueIsFail(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        try {
            new Moment(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void basic() throws Exception {
        Moment moment = null;
        moment = new Moment(2008, 8, 8, 20, 9, 33, 17);
        Assert.assertEquals((Object)"08-8-8 20:9", (Object)moment.toShortForm());
        Assert.assertEquals((Object)"2008-8-8 20:09:33", (Object)moment.toMediumForm());
        Assert.assertEquals((Object)"2008-08-08 20:09:33.017", (Object)moment.toLongForm());
        Assert.assertEquals((Object)"2\u5e743\u4e2a\u6708\u524d", (Object)moment.toRelativeForm(1291132800000L));
        Assert.assertEquals((Object)"\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4", (Object)moment.getTimeZone());
        Assert.assertEquals((Object)"8\u67088\u65e5 \u661f\u671f\u4e94", (Object)moment.toMonthDateWeekForm());
        Assert.assertEquals((Object)"2008-08-08 20:09:33.017 \u661f\u671f\u4e94", (Object)moment.toFullForm());
        moment = new Moment(2009, 12, 8, 20, 9, 33, 17);
        Assert.assertEquals((Object)"09-12-8 20:9", (Object)moment.toShortForm());
        Assert.assertEquals((Object)"2009-12-8 20:09:33", (Object)moment.toMediumForm());
        Assert.assertEquals((Object)"2009-12-08 20:09:33.017", (Object)moment.toLongForm());
        Assert.assertEquals((Object)"11\u4e2a\u6708\u524d", (Object)moment.toRelativeForm(1291132800000L));
        moment = new Moment(2010, 12, 8, 20, 9, 33, 17);
        Assert.assertEquals((Object)"10-12-8 20:9", (Object)moment.toShortForm());
        Assert.assertEquals((Object)"2010-12-8 20:09:33", (Object)moment.toMediumForm());
        Assert.assertEquals((Object)"2010-12-08 20:09:33.017", (Object)moment.toLongForm());
        Assert.assertEquals((Object)"1\u546820\u5c0f\u65f6\u540e", (Object)moment.toRelativeForm(1291132800000L));
    }
}

